/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class ListModel
implements SerializableCompatibility {
    private static final int[] EMPTY_SELECTION = new int[0];
    private final boolean single;
    private final List<String> items;
    private int[] selection;

    public ListModel(boolean single) {
        this.single = single;
        this.items = new ArrayList<String>();
        this.selection = EMPTY_SELECTION;
    }

    public int getSelectionIndex() {
        int result = -1;
        if (this.selection.length > 0) {
            result = this.selection[0];
        }
        return result;
    }

    public int[] getSelectionIndices() {
        int[] result = new int[this.selection.length];
        System.arraycopy(this.selection, 0, result, 0, this.selection.length);
        return result;
    }

    public int getSelectionCount() {
        return this.selection.length;
    }

    public void setSelection(int selection) {
        this.deselectAll();
        if (selection >= 0 && selection <= this.getItemCount() - 1) {
            this.selection = new int[]{selection};
        }
    }

    public void setSelection(int[] selection) {
        if (selection == null) {
            SWT.error(4);
        }
        this.deselectAll();
        int length = selection.length;
        if (this.single) {
            int end = this.getItemCount() - 1;
            if (length == 1 && selection[0] >= 0 && selection[0] <= end) {
                this.selection = new int[]{selection[0]};
            }
        } else {
            int end = this.getItemCount() - 1;
            int newLength = 0;
            int i = 0;
            while (i < length) {
                if (selection[i] >= 0 && selection[i] <= end) {
                    ++newLength;
                }
                ++i;
            }
            this.selection = new int[newLength];
            int pos = 0;
            int i2 = 0;
            while (i2 < length) {
                if (selection[i2] >= 0 && selection[i2] <= end) {
                    this.selection[pos] = selection[i2];
                    ++pos;
                }
                ++i2;
            }
        }
    }

    public void setSelection(int start, int end) {
        this.deselectAll();
        if (end >= 0 && start <= end && start <= this.getItemCount() - 1) {
            if (this.single) {
                if (start == end) {
                    this.selection = new int[]{start};
                }
            } else {
                int first = Math.max(0, start);
                int last = Math.min(end, this.getItemCount() - 1);
                this.selection = new int[last - first + 1];
                int current = first;
                int i = 0;
                while (i < this.selection.length) {
                    this.selection[i] = current++;
                    ++i;
                }
            }
        }
    }

    public void setSelection(String[] selection) {
        if (selection == null) {
            SWT.error(4);
        }
        this.deselectAll();
        int length = selection.length;
        if (this.single && length == 1 || !this.single && length > 0) {
            int newLength = 0;
            int i = 0;
            while (i < length) {
                if (selection[i] != null && this.indexOf(selection[i]) != -1) {
                    ++newLength;
                }
                ++i;
            }
            this.selection = new int[newLength];
            int pos = 0;
            int i2 = 0;
            while (i2 < length) {
                if (selection[i2] != null && this.indexOf(selection[i2]) != -1) {
                    this.selection[pos] = this.indexOf(selection[i2]);
                    ++pos;
                }
                ++i2;
            }
        }
    }

    public void addSelection(int index) {
        if (index >= 0 && index < this.getItemCount()) {
            boolean exists = false;
            int i = 0;
            while (i < this.selection.length) {
                if (this.selection[i] == index) {
                    exists = true;
                }
                ++i;
            }
            if (!exists) {
                int newLength = this.selection.length + 1;
                int[] newSelection = new int[newLength];
                System.arraycopy(this.selection, 0, newSelection, 0, this.selection.length);
                newSelection[newLength - 1] = index;
                this.selection = newSelection;
            }
        }
    }

    public void selectAll() {
        if (!this.single) {
            this.selection = new int[this.items.size()];
            int i = 0;
            while (i < this.selection.length) {
                this.selection[i] = i;
                ++i;
            }
        }
    }

    public void deselectAll() {
        this.selection = EMPTY_SELECTION;
    }

    public void add(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.items.add(string);
    }

    public void add(String string, int index) {
        if (string == null) {
            SWT.error(4);
        }
        if (index != this.getItemCount()) {
            this.checkIndex(index);
        }
        this.items.add(index, string);
    }

    public void remove(int index) {
        this.checkIndex(index);
        this.items.remove(index);
        this.removeFromSelection(index);
    }

    public void remove(int start, int end) {
        this.checkIndex(start);
        this.checkIndex(end);
        int i = end;
        while (i >= start) {
            this.remove(i);
            --i;
        }
    }

    public void remove(int[] indices) {
        if (indices == null) {
            SWT.error(4);
        }
        if (indices.length > 0) {
            int[] newIndices = new int[indices.length];
            System.arraycopy(indices, 0, newIndices, 0, indices.length);
            Arrays.sort(newIndices);
            this.checkIndex(newIndices[0]);
            this.checkIndex(newIndices[newIndices.length - 1]);
            int i = newIndices.length - 1;
            while (i >= 0) {
                this.remove(newIndices[i]);
                --i;
            }
        }
    }

    public void remove(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int index = this.indexOf(string);
        this.checkIndex(index);
        this.remove(index);
    }

    public void removeAll() {
        this.items.clear();
        this.deselectAll();
    }

    public void setItem(int index, String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.checkIndex(index);
        this.items.set(index, string);
    }

    public void setItems(String[] items) {
        if (items == null) {
            SWT.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        this.items.clear();
        this.items.addAll(Arrays.asList(items));
        this.deselectAll();
    }

    public String getItem(int index) {
        this.checkIndex(index);
        return this.items.get(index);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String[] getItems() {
        return this.items.toArray(new String[this.items.size()]);
    }

    private void removeFromSelection(int index) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.selection.length) {
            if (index == this.selection[i]) {
                int length = this.selection.length;
                int[] newSelection = new int[this.selection.length - 1];
                System.arraycopy(this.selection, 0, newSelection, 0, i);
                if (i < length - 1) {
                    System.arraycopy(this.selection, i + 1, newSelection, i, length - i - 1);
                }
                int j = 0;
                while (j < newSelection.length) {
                    if (newSelection[j] > index) {
                        newSelection[j] = newSelection[j] - 1;
                    }
                    ++j;
                }
                this.selection = newSelection;
                found = true;
            }
            ++i;
        }
    }

    private int indexOf(String string) {
        return this.items.indexOf(string);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            SWT.error(6);
        }
    }
}

