/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rtp.configurator.rest.RestTemplate;
import org.eclipse.rtp.core.model.Source;
import org.eclipse.rtp.core.model.SourceVersion;

public class ComponentsTabContentUtil {
    private List<Source> sources;
    private List<Source> installedSources;
    private RestTemplate restTemplate;
    private String configurationURI;
    private static String[] comboLabels = new String[]{"all", "installed", "uninstalled"};
    private final Map<String, String> listMapping = new HashMap<String, String>(){
        {
            this.put(comboLabels[0], "/rt/list");
            this.put(comboLabels[1], "/rt/list/installed");
            this.put(comboLabels[2], "/rt/list/uninstalled");
        }
    };

    public void setConfigurationURI(String configurationURI) {
        this.configurationURI = configurationURI;
    }

    public String[] getComboLabels() {
        return comboLabels;
    }

    public List<Source> getSourcec() {
        return this.sources;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public boolean isInstalled(SourceVersion sourceVersion) {
        boolean result = false;
        int i = 0;
        while (i < this.installedSources.size() && !result) {
            Source source = this.installedSources.get(i);
            List versions = source.getVersions();
            int j = 0;
            while (j < versions.size() && !result) {
                result = ((SourceVersion)versions.get(j)).toString().equals(sourceVersion.toString());
                ++j;
            }
            ++i;
        }
        return result;
    }

    public Source getSourceVersionSource(SourceVersion sourceVersion) {
        Source result = null;
        if (this.sources != null) {
            for (Source source : this.sources) {
                List versions = source.getVersions();
                for (SourceVersion version : versions) {
                    if (!version.equals(sourceVersion)) continue;
                    result = source;
                }
            }
        }
        return result;
    }

    public void refresh(String componentsFilter) {
        this.restTemplate = new RestTemplate(this.configurationURI);
        this.sources = this.restTemplate.getForEntitiesAsList(this.listMapping.get(componentsFilter), Source.class);
        this.installedSources = this.restTemplate.getForEntitiesAsList(this.listMapping.get(comboLabels[1]), Source.class);
    }
}

