/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.engine;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.rwt.application.Application;
import org.eclipse.rwt.application.ApplicationConfiguration;
import org.eclipse.rwt.application.ApplicationConfigurator;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.lifecycle.IEntryPoint;

public class RWTServletContextListener
implements ServletContextListener {
    public static final String ENTRY_POINTS_PARAM = "org.eclipse.rwt.entryPoints";
    private Application application;

    public void contextInitialized(ServletContextEvent evt) {
        ServletContext servletContext = evt.getServletContext();
        ApplicationConfigurator configurator = this.readConfigurator(servletContext);
        this.application = new Application(configurator, servletContext);
        this.application.start();
    }

    public void contextDestroyed(ServletContextEvent evt) {
        this.application.stop();
        this.application = null;
    }

    private ApplicationConfigurator readConfigurator(ServletContext servletContext) {
        ApplicationConfigurator result = this.hasConfiguratorParam(servletContext) ? this.readApplicationConfigurator(servletContext) : this.readEntryPointRunnerConfigurator(servletContext);
        return result;
    }

    private boolean hasConfiguratorParam(ServletContext servletContext) {
        return servletContext.getInitParameter("org.eclipse.rwt.Configurator") != null;
    }

    private ApplicationConfigurator readApplicationConfigurator(ServletContext servletContext) {
        String name = servletContext.getInitParameter("org.eclipse.rwt.Configurator");
        return this.newConfigurator(name);
    }

    private ApplicationConfigurator newConfigurator(String className) {
        ClassLoader loader = this.getClass().getClassLoader();
        return (ApplicationConfigurator)ClassUtil.newInstance(loader, className);
    }

    private ApplicationConfigurator readEntryPointRunnerConfigurator(ServletContext context) {
        try {
            return this.doReadEntryPointRunnerConfigurator(context);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(cnfe);
        }
    }

    private ApplicationConfigurator doReadEntryPointRunnerConfigurator(ServletContext context) throws ClassNotFoundException {
        String className = context.getInitParameter(ENTRY_POINTS_PARAM);
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> entryPointClass = loader.loadClass(className);
        return new EntryPointRunnerConfigurator(entryPointClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryPointRunnerConfigurator
    implements ApplicationConfigurator {
        private final Class<? extends IEntryPoint> entryPointClass;

        private EntryPointRunnerConfigurator(Class<? extends IEntryPoint> entryPointClass) {
            this.entryPointClass = entryPointClass;
        }

        @Override
        public void configure(ApplicationConfiguration configuration) {
            configuration.addEntryPoint("/rap", this.entryPointClass, null);
        }
    }
}

