/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.engine;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.rwt.service.ISessionStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostDeserialization {
    private static final String PROCESSORS = String.valueOf(PostDeserialization.class.getName()) + "#processors";
    private static final Runnable[] EMPTY_PROCESSORS = new Runnable[0];

    public static void runProcessors(ISessionStore sessionStore) {
        Runnable[] processors = PostDeserialization.getProcessors(sessionStore);
        PostDeserialization.clearProcessors(sessionStore);
        Runnable[] runnableArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            Runnable processor = runnableArray[n2];
            processor.run();
            ++n2;
        }
    }

    public static void addProcessor(ISessionStore sessionStore, Runnable processor) {
        List<Runnable> processorsList = PostDeserialization.getProcessorsList(sessionStore);
        processorsList.add(processor);
    }

    private static Runnable[] getProcessors(ISessionStore sessionStore) {
        Runnable[] result = EMPTY_PROCESSORS;
        List list = (List)sessionStore.getAttribute(PROCESSORS);
        if (list != null) {
            result = list.toArray(new Runnable[list.size()]);
        }
        return result;
    }

    private static List<Runnable> getProcessorsList(ISessionStore sessionStore) {
        LinkedList result = (LinkedList)sessionStore.getAttribute(PROCESSORS);
        if (result == null) {
            result = new LinkedList();
            sessionStore.setAttribute(PROCESSORS, result);
        }
        return result;
    }

    private static void clearProcessors(ISessionStore sessionStore) {
        sessionStore.removeAttribute(PROCESSORS);
    }

    private PostDeserialization() {
    }
}

