/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.branding.Header;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.lifecycle.EntryPointUtil;
import org.eclipse.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.StartupPageTemplateHolder;
import org.eclipse.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.resources.IResource;

final class StartupPageConfigurer {
    private static final String PACKAGE_NAME = StartupPageConfigurer.class.getPackage().getName();
    private static final String FOLDER = PACKAGE_NAME.replace('.', '/');
    private static final String INDEX_TEMPLATE = String.valueOf(FOLDER) + "/rwt-index.html";
    private static final String DISPLAY_TYPE = "rwt.Display";
    private static final String PROPERTY_FONTS = "fonts";
    private static final String METHOD_PROBE = "probe";
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_ROOT_ID = "rootId";
    private static final String METHOD_INIT = "init";
    private final ResourceRegistry resourceRegistry;
    private final List<String> jsLibraries;
    private final List<String> themeDefinitions;
    private StartupPageTemplateHolder template;

    StartupPageConfigurer(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
        this.jsLibraries = new ArrayList<String>();
        this.themeDefinitions = new ArrayList<String>();
    }

    public StartupPageTemplateHolder getTemplate() throws IOException {
        this.readContent();
        this.template.reset();
        this.applyBranding();
        this.applyEntryPointProperties();
        this.applyLocalizeableMessages();
        this.addThemeDefinitions();
        this.template.replace(StartupPageTemplateHolder.VAR_LIBRARIES, this.getJsLibraries());
        this.template.replace(StartupPageTemplateHolder.VAR_APPSCRIPT, StartupPageConfigurer.getAppScript());
        return this.template;
    }

    public void addJsLibrary(String location) {
        ParamCheck.notNull(location, "resource");
        this.jsLibraries.add(location);
    }

    private void readContent() throws IOException {
        if (this.template == null) {
            InputStream stream = StartupPageConfigurer.loadTemplateFile();
            InputStreamReader streamReader = new InputStreamReader(stream, "UTF-8");
            BufferedReader reader = new BufferedReader(streamReader);
            try {
                String line = reader.readLine();
                StringBuilder buffer = new StringBuilder();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                this.template = new StartupPageTemplateHolder(buffer.toString());
            }
            finally {
                reader.close();
            }
        }
    }

    private static InputStream loadTemplateFile() throws IOException {
        ClassLoader classLoader = StartupPageConfigurer.class.getClassLoader();
        InputStream result = classLoader.getResourceAsStream(INDEX_TEMPLATE);
        if (result == null) {
            throw new IOException("Failed to startup page: " + INDEX_TEMPLATE);
        }
        return result;
    }

    private static String getAppScript() {
        StringBuilder code = new StringBuilder();
        code.append("org.eclipse.rwt.protocol.Processor.processMessage( ");
        code.append(StartupPageConfigurer.getStartupProtocolMessage("w1"));
        code.append(" );/*EOM*/");
        return code.toString();
    }

    private static String getStartupProtocolMessage(String id) {
        ProtocolMessageWriter writer = new ProtocolMessageWriter();
        StartupPageConfigurer.appendCreateDisplay(id, writer);
        StartupPageConfigurer.appendStartupTextSizeProbe(id, writer);
        StartupPageConfigurer.appendInitDisplay(id, writer);
        return writer.createMessage();
    }

    private static void appendCreateDisplay(String id, ProtocolMessageWriter writer) {
        writer.appendCreate(id, DISPLAY_TYPE);
    }

    private static void appendStartupTextSizeProbe(String id, ProtocolMessageWriter writer) {
        Object startupTextSizeProbeObject = StartupPageConfigurer.getStartupTextSizeProbeObject();
        if (startupTextSizeProbeObject != null) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put(PROPERTY_FONTS, startupTextSizeProbeObject);
            writer.appendCall(id, METHOD_PROBE, args);
        }
    }

    private static void appendInitDisplay(String id, ProtocolMessageWriter writer) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(PROPERTY_URL, StartupPageConfigurer.getUrl());
        args.put(PROPERTY_ROOT_ID, id);
        writer.appendCall(id, METHOD_INIT, args);
    }

    private static Object getStartupTextSizeProbeObject() {
        return MeasurementUtil.getStartupProbeObject();
    }

    private static String getUrl() {
        HttpServletRequest request = ContextProvider.getRequest();
        String url = request.getServletPath().substring(1);
        return ContextProvider.getResponse().encodeURL(url);
    }

    private void applyBranding() throws IOException {
        AbstractBranding branding = BrandingUtil.determineBranding();
        BrandingUtil.registerResources(branding);
        if (branding.getThemeId() != null) {
            ThemeUtil.setCurrentThemeId(branding.getThemeId());
        } else {
            ThemeUtil.setCurrentThemeId("org.eclipse.rap.rwt.theme.Default");
        }
        StartupPageConfigurer.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_BODY, branding.getBody());
        StartupPageConfigurer.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_TITLE, branding.getTitle());
        String headers = BrandingUtil.headerMarkup(branding);
        StartupPageConfigurer.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_HEADERS, headers);
    }

    private void applyEntryPointProperties() {
        Map<String, String> properties = EntryPointUtil.getCurrentEntryPointProperties();
        if (!properties.isEmpty()) {
            String headHtml;
            String themeId = properties.get("org.eclipse.rap.rwt.webclient.themeId");
            if (themeId != null && themeId.length() > 0) {
                ThemeUtil.setCurrentThemeId(themeId);
            }
            String bodyHtml = properties.get("org.eclipse.rap.rwt.webclient.bodyHtml");
            StartupPageConfigurer.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_BODY, bodyHtml);
            String title = properties.get("org.eclipse.rap.rwt.webclient.pageTitle");
            StartupPageConfigurer.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_TITLE, title);
            String headerMarkup = "";
            String favIcon = properties.get("org.eclipse.rap.rwt.webclient.favicon");
            if (favIcon != null && favIcon.length() > 0) {
                Header header = BrandingUtil.createHeaderForFavIcon(favIcon);
                headerMarkup = String.valueOf(headerMarkup) + BrandingUtil.createMarkupForHeaders(header);
            }
            if ((headHtml = properties.get("org.eclipse.rap.rwt.webclient.additionalHeaders")) != null) {
                headerMarkup = String.valueOf(headerMarkup) + headHtml;
            }
            StartupPageConfigurer.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_HEADERS, headerMarkup);
        }
    }

    private void applyLocalizeableMessages() {
        String noScriptWarning = RWTMessages.getMessage("RWT_NoScriptWarning");
        StartupPageConfigurer.replacePlaceholder(this.template, StartupPageTemplateHolder.VAR_NO_SCRIPT_MESSAGE, noScriptWarning);
    }

    private void addThemeDefinitions() {
        this.themeDefinitions.clear();
        ThemeManager themeManager = RWTFactory.getThemeManager();
        Theme fallbackTheme = themeManager.getTheme("org.eclipse.rap.rwt.theme.Fallback");
        this.themeDefinitions.add(fallbackTheme.getRegisteredLocation());
        Theme theme = ThemeUtil.getCurrentTheme();
        this.themeDefinitions.add(theme.getRegisteredLocation());
    }

    private String getJsLibraries() {
        IResource[] resources;
        StringBuilder buffer = new StringBuilder();
        for (String location : this.jsLibraries) {
            StartupPageConfigurer.writeScriptTag(buffer, location);
        }
        for (String location : this.themeDefinitions) {
            StartupPageConfigurer.writeScriptTag(buffer, location);
        }
        IResource[] iResourceArray = resources = this.resourceRegistry.get();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.isJSLibrary() && resource.isExternal()) {
                StartupPageConfigurer.writeScriptTag(buffer, resource.getLocation());
            }
            ++n2;
        }
        String location = RWTFactory.getJSLibraryConcatenator().getLocation();
        StartupPageConfigurer.writeScriptTag(buffer, location);
        return buffer.toString();
    }

    static void replacePlaceholder(StartupPageTemplateHolder template, StartupPageTemplateHolder.Variable variable, String replacement) {
        String safeReplacement = replacement == null ? "" : replacement;
        template.replace(variable, safeReplacement);
    }

    private static void writeScriptTag(StringBuilder buffer, String library) {
        if (library != null) {
            buffer.append("<script type=\"text/javascript\" src=\"");
            buffer.append(library);
            buffer.append("\" charset=\"");
            buffer.append("UTF-8");
            buffer.append("\"></script>\n");
        }
    }
}

