/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.options.Option;
import org.apache.felix.gogo.options.Options;
import org.apache.felix.gogo.shell.Shell;
import org.apache.felix.service.command.CommandSession;

public class Posix {
    static final String[] functions = new String[]{"cat", "echo", "grep"};

    public void cat(CommandSession session, String[] args) throws Exception {
        if (args.length == 0) {
            Posix.copy(System.in, (OutputStream)System.out);
            return;
        }
        URI cwd = Shell.cwd(session);
        for (String arg : args) {
            Posix.copy(cwd.resolve(arg), (OutputStream)System.out);
        }
    }

    public void echo(Object[] args) {
        StringBuilder buf = new StringBuilder();
        if (args == null) {
            System.out.println("Null");
            return;
        }
        for (Object arg : args) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(String.valueOf(arg));
        }
        System.out.println(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean grep(CommandSession session, String[] argv) throws IOException {
        String[] usage = new String[]{"grep -  search for PATTERN in each FILE or standard input.", "Usage: grep [OPTIONS] PATTERN [FILES]", "  -? --help                show help", "  -i --ignore-case         ignore case distinctions", "  -n --line-number         prefix each line with line number within its input file", "  -q --quiet, --silent     suppress all normal output", "  -v --invert-match        select non-matching lines"};
        Option opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            opt.usage();
            return true;
        }
        List<String> args = opt.args();
        if (args.size() == 0) {
            throw opt.usageError("no pattern supplied.");
        }
        String regex = args.remove(0);
        if (opt.isSet("ignore-case")) {
            regex = "(?i)" + regex;
        }
        if (args.isEmpty()) {
            args.add(null);
        }
        StringBuilder buf = new StringBuilder();
        if (args.size() > 1) {
            buf.append("%1$s:");
        }
        if (opt.isSet("line-number")) {
            buf.append("%2$s:");
        }
        buf.append("%3$s");
        String format = buf.toString();
        Pattern pattern = Pattern.compile(regex);
        boolean status = true;
        boolean match = false;
        for (String arg : args) {
            InputStream in = null;
            try {
                String s;
                URI cwd = Shell.cwd(session);
                in = arg == null ? System.in : cwd.resolve(arg).toURL().openStream();
                BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
                int line = 0;
                while ((s = rdr.readLine()) != null) {
                    ++line;
                    Matcher matcher = pattern.matcher(s);
                    if (matcher.find() ^ !opt.isSet("invert-match")) continue;
                    match = true;
                    if (opt.isSet("quiet")) break;
                    System.out.println(String.format(format, arg, line, s));
                }
                if (!match || !opt.isSet("quiet")) continue;
                break;
            }
            catch (IOException e) {
                System.err.println("grep: " + e.getMessage());
                status = false;
            }
            finally {
                if (arg == null || in == null) continue;
                in.close();
            }
        }
        return match && status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URI source, OutputStream out) throws IOException {
        InputStream in = source.toURL().openStream();
        try {
            Posix.copy(in, out);
        }
        finally {
            in.close();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[10240];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
    }
}

