/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.commands;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.eclipse.equinox.console.command.adapter.Activator;
import org.eclipse.equinox.console.commands.ConsoleMsg;
import org.eclipse.equinox.console.commands.EquinoxCommandsConverter;
import org.eclipse.equinox.console.commands.Util;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxCommandProvider
implements SynchronousBundleListener {
    private final BundleContext context;
    private ServiceRegistration<?> providerReg;
    private ServiceRegistration<?> converterReg;
    private static final String tab = "\t";
    private static final String newline = "\r\n";
    private final List<Bundle> lazyActivation = new ArrayList<Bundle>();
    private Activator activator;
    private static final String[] functions = new String[]{"exit", "shutdown", "sta", "start", "sto", "stop", "i", "install", "up", "up", "up", "update", "update", "update", "un", "uninstall", "s", "status", "se", "services", "p", "p", "packages", "packages", "bundles", "b", "bundle", "gc", "init", "close", "r", "refresh", "exec", "fork", "h", "headers", "pr", "props", "setp", "setprop", "ss", "t", "threads", "sl", "setfwsl", "setbsl", "setibsl", "requiredBundles", "classSpaces", "profilelog", "getPackages", "getprop", "diag", "enableBundle", "disableBundle", "disabledBundles"};
    private static final String POLICY_CONSOLE = "org.eclipse.equinox.console";

    public EquinoxCommandProvider(BundleContext context, Activator activator) {
        this.context = context;
        this.activator = activator;
    }

    public void startService() {
        EquinoxCommandsConverter converter = new EquinoxCommandsConverter(this.context);
        this.converterReg = this.context.registerService(Converter.class.getName(), (Object)converter, null);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.ranking", new Integer(Integer.MAX_VALUE));
        ((Dictionary)props).put("osgi.command.scope", "equinox");
        ((Dictionary)props).put("osgi.command.function", functions);
        this.providerReg = this.context.registerService(EquinoxCommandProvider.class.getName(), (Object)this, props);
        this.context.addBundleListener((BundleListener)this);
    }

    public void stopService() {
        if (this.converterReg != null) {
            this.converterReg.unregister();
        }
        this.context.removeBundleListener((BundleListener)this);
        if (this.providerReg != null) {
            this.providerReg.unregister();
        }
    }

    @Descriptor(value="exit immediately (System.exit)")
    public void exit() throws Exception {
        System.out.println();
        System.exit(0);
    }

    @Descriptor(value="shutdown the OSGi Framework")
    public void shutdown() throws Exception {
        this.context.getBundle(0L).stop();
    }

    @Descriptor(value="start the specified bundle(s)")
    public void sta(@Descriptor(value="bundle(s) to start") Bundle[] bundles) throws Exception {
        this.start(bundles);
    }

    @Descriptor(value="start the specified bundle(s)")
    public void start(@Descriptor(value="bundle(s) to start") Bundle[] bundles) throws Exception {
        if (bundles == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        if (bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            bundle.start();
            ++n2;
        }
    }

    @Descriptor(value="stop the specified bundle(s)")
    public void sto(@Descriptor(value="bundle(s) to stop") Bundle[] bundles) throws Exception {
        this.stop(bundles);
    }

    @Descriptor(value="stop the specified bundle(s)")
    public void stop(@Descriptor(value="bundle(s) to stop") Bundle[] bundles) throws Exception {
        if (bundles == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        if (bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            bundle.stop();
            ++n2;
        }
    }

    @Descriptor(value="install and optionally start bundle from the given URL")
    public void i(@Descriptor(value="spedify if the bundle should be started after installation") @Parameter(absentValue="false", presentValue="true", names={"-start"}) boolean shouldStart, @Descriptor(value="Location of bundle to install") String url) throws Exception {
        this.install(shouldStart, url);
    }

    @Descriptor(value="install and optionally start bundle from the given URL")
    public Bundle install(@Descriptor(value="spedify if the bundle should be started after installation") @Parameter(absentValue="false", presentValue="true", names={"-start"}) boolean shouldStart, @Descriptor(value="Location of bundle to install") String url) throws Exception {
        if (url == null) {
            System.out.println(ConsoleMsg.CONSOLE_NOTHING_TO_INSTALL_ERROR);
            return null;
        }
        Bundle bundle = this.context.installBundle(url);
        System.out.print(ConsoleMsg.CONSOLE_BUNDLE_ID_MESSAGE);
        System.out.println(bundle.getBundleId());
        if (shouldStart) {
            bundle.start();
        }
        return bundle;
    }

    @Descriptor(value="update the specified bundle(s)")
    public void up(@Descriptor(value="bundle(s) to update") Bundle[] bundles) throws Exception {
        this.update(bundles);
    }

    @Descriptor(value="Update the specified bundle from the specified location")
    public void up(@Descriptor(value="Bundle to update") Bundle bundle, @Descriptor(value="Location of the new bundle content") URL source) throws Exception {
        this.update(bundle, source);
    }

    @Descriptor(value="update the specified bundle(s)")
    public void update(@Descriptor(value="bundle(s) to update") Bundle[] bundles) throws Exception {
        if (bundles == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        if (bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            bundle.update();
            ++n2;
        }
    }

    @Descriptor(value="Update the specified bundle from the specified location")
    public void update(@Descriptor(value="Bundle to update") Bundle bundle, @Descriptor(value="Location of the new bundle content") URL source) throws Exception {
        bundle.update(source.openStream());
    }

    @Descriptor(value="uninstall the specified bundle(s)")
    public void un(@Descriptor(value="bundle(s) to uninstall") Bundle[] bundles) throws Exception {
        this.uninstall(bundles);
    }

    @Descriptor(value="uninstall the specified bundle(s)")
    public void uninstall(@Descriptor(value="bundle(s) to uninstall") Bundle[] bundles) throws Exception {
        if (bundles == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        if (bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            bundle.uninstall();
            ++n2;
        }
    }

    private int getStatesFromConstants(String states) throws IllegalArgumentException {
        int stateFilter = -1;
        if (!states.equals("")) {
            StringTokenizer tokens = new StringTokenizer(states, ",");
            while (tokens.hasMoreElements()) {
                String desiredState = (String)tokens.nextElement();
                Field match = null;
                try {
                    match = Bundle.class.getField(desiredState.toUpperCase());
                    if (stateFilter == -1) {
                        stateFilter = 0;
                    }
                    stateFilter |= match.getInt(match);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    System.out.println(String.valueOf(ConsoleMsg.CONSOLE_INVALID_INPUT) + ": " + desiredState);
                    throw new IllegalArgumentException();
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println(String.valueOf(ConsoleMsg.CONSOLE_INVALID_INPUT) + ": " + desiredState);
                    throw new IllegalArgumentException();
                }
            }
        }
        return stateFilter;
    }

    @Descriptor(value="display installed bundles and registered services")
    public void s(String ... arguments) throws Exception {
        this.status(arguments);
    }

    @Descriptor(value="display installed bundles and registered services")
    public void status(String ... arguments) throws Exception {
        int stateFilter;
        if (this.context.getBundle(0L).getState() == 32) {
            System.out.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE);
        } else {
            System.out.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE);
        }
        System.out.println();
        String states = "";
        String[] bsnSegments = null;
        if (arguments != null && arguments.length > 0) {
            if (arguments[0].equals("-s")) {
                if (arguments.length > 1) {
                    states = arguments[1];
                    if (arguments.length > 2) {
                        bsnSegments = new String[arguments.length - 2];
                        System.arraycopy(arguments, 2, bsnSegments, 0, bsnSegments.length);
                    }
                }
            } else {
                bsnSegments = arguments;
            }
        }
        try {
            stateFilter = this.getStatesFromConstants(states);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        Bundle[] bundles = this.context.getBundles();
        int size = bundles.length;
        if (size == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        System.out.print(ConsoleMsg.CONSOLE_ID);
        System.out.print(tab);
        System.out.println(ConsoleMsg.CONSOLE_BUNDLE_LOCATION_MESSAGE);
        System.out.println(ConsoleMsg.CONSOLE_STATE_BUNDLE_FILE_NAME_HEADER);
        int i = 0;
        while (i < size) {
            Bundle bundle = bundles[i];
            if (this.match(bundle, bsnSegments, stateFilter)) {
                System.out.print(bundle.getBundleId());
                System.out.print(tab);
                System.out.println(bundle.getLocation());
                System.out.print("  ");
                System.out.print(this.getStateName(bundle));
                System.out.println(bundle.toString());
            }
            ++i;
        }
        ServiceReference[] services = this.context.getServiceReferences(null, null);
        if (services != null) {
            System.out.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
            ServiceReference[] serviceReferenceArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference service = serviceReferenceArray[n2];
                System.out.println(service);
                ++n2;
            }
        }
    }

    @Descriptor(value="display registered service details. Examples for [filter]: (objectClass=com.xyz.Person); (&(objectClass=com.xyz.Person)(sn=Jensen)); passing only com.xyz.Person is a shortcut for (objectClass=com.xyz.Person). The filter syntax specification is available at http://www.ietf.org/rfc/rfc1960.txt")
    public void se(String ... filters) throws Exception {
        this.services(filters);
    }

    @Descriptor(value="display registered service details. Examples for [filter]: (objectClass=com.xyz.Person); (&(objectClass=com.xyz.Person)(sn=Jensen)); passing only com.xyz.Person is a shortcut for (objectClass=com.xyz.Person). The filter syntax specification is available at http://www.ietf.org/rfc/rfc1960.txt")
    public void services(String ... filters) throws Exception {
        int size;
        String filter = null;
        if (filters != null && filters.length > 0) {
            StringBuffer buf = new StringBuffer();
            String[] stringArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                String singleFilter = stringArray[n2];
                buf.append(' ');
                buf.append(singleFilter);
                ++n2;
            }
            filter = buf.toString();
        }
        InvalidSyntaxException originalException = null;
        ServiceReference[] services = null;
        try {
            services = this.context.getServiceReferences(null, filter);
        }
        catch (InvalidSyntaxException e) {
            originalException = e;
        }
        if (filter != null) {
            filter = filter.trim();
        }
        if (originalException != null && !filter.startsWith("(") && !filter.contains(" ")) {
            try {
                filter = "(objectClass=" + filter + ")";
                services = this.context.getServiceReferences(null, filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw originalException;
            }
        } else if (originalException != null) {
            throw originalException;
        }
        if (services != null && (size = services.length) > 0) {
            int j = 0;
            while (j < size) {
                ServiceReference service = services[j];
                System.out.println(service);
                System.out.print("  ");
                System.out.print(ConsoleMsg.CONSOLE_REGISTERED_BY_BUNDLE_MESSAGE);
                System.out.print(" ");
                System.out.println(service.getBundle());
                Bundle[] users = service.getUsingBundles();
                if (users != null) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_BUNDLES_USING_SERVICE_MESSAGE);
                    int k = 0;
                    while (k < users.length) {
                        System.out.print("    ");
                        System.out.println(users[k]);
                        ++k;
                    }
                } else {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLES_USING_SERVICE_MESSAGE);
                }
                ++j;
            }
            return;
        }
        System.out.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
    }

    @Descriptor(value="display imported/exported package details")
    public void p(Bundle ... bundle) throws Exception {
        this.packages(bundle);
    }

    @Descriptor(value="display imported/exported package details")
    public void p(@Descriptor(value="Package name of the package to display") String packageName) throws Exception {
        this.packages(packageName);
    }

    @Descriptor(value="display imported/exported package details")
    public void packages(Bundle ... bundle) throws Exception {
        if (this.activator.getPackageAdmin() != null) {
            ExportedPackage[] exportedPackages = bundle != null && bundle.length > 0 ? this.activator.getPackageAdmin().getExportedPackages(bundle[0]) : this.activator.getPackageAdmin().getExportedPackages(null);
            this.getPackages(exportedPackages);
        } else {
            System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
        }
    }

    @Descriptor(value="display imported/exported package details")
    public void packages(@Descriptor(value="Package name of the package to display") String packageName) throws Exception {
        if (this.activator.getPackageAdmin() != null) {
            ExportedPackage[] exportedPackages = this.activator.getPackageAdmin().getExportedPackages(packageName);
            this.getPackages(exportedPackages);
        } else {
            System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
        }
    }

    private void getPackages(ExportedPackage[] packages) throws Exception {
        if (packages == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
            return;
        }
        int i = 0;
        while (i < packages.length) {
            Bundle exporter;
            ExportedPackage pkg = packages[i];
            System.out.print(pkg);
            boolean removalPending = pkg.isRemovalPending();
            if (removalPending) {
                System.out.print("(");
                System.out.print(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                System.out.println(")");
            }
            if ((exporter = pkg.getExportingBundle()) != null) {
                System.out.print("<");
                System.out.print(exporter);
                System.out.println(">");
                Bundle[] importers = pkg.getImportingBundles();
                int j = 0;
                while (j < importers.length) {
                    System.out.print("  ");
                    System.out.print(importers[j]);
                    System.out.print(" ");
                    System.out.println(ConsoleMsg.CONSOLE_IMPORTS_MESSAGE);
                    ++j;
                }
            } else {
                System.out.print("<");
                System.out.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                System.out.println(">");
            }
            ++i;
        }
    }

    @Descriptor(value="display details for all installed bundles")
    public void bundles(String ... arguments) throws Exception {
        int stateFilter;
        String states = "";
        String[] bsnSegments = null;
        if (arguments != null && arguments.length > 0) {
            if (arguments[0].equals("-s")) {
                if (arguments.length > 1) {
                    states = arguments[1];
                    if (arguments.length > 2) {
                        bsnSegments = new String[arguments.length - 2];
                        System.arraycopy(arguments, 2, bsnSegments, 0, bsnSegments.length);
                    }
                }
            } else {
                bsnSegments = arguments;
            }
        }
        try {
            stateFilter = this.getStatesFromConstants(states);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        Bundle[] bundles = this.context.getBundles();
        int size = bundles.length;
        if (size == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        int i = 0;
        while (i < size) {
            Bundle bundle = bundles[i];
            if (this.match(bundle, bsnSegments, stateFilter)) {
                long id = bundle.getBundleId();
                System.out.println(bundle);
                System.out.print("  ");
                System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_ID_MESSAGE, (Object)String.valueOf(id)));
                System.out.print(", ");
                System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_STATUS_MESSAGE, (Object)this.getStateName(bundle)));
                if (id != 0L) {
                    File dataRoot = bundle.getDataFile("");
                    String root = dataRoot == null ? null : dataRoot.getAbsolutePath();
                    System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_DATA_ROOT_MESSAGE, (Object)root));
                } else {
                    System.out.println();
                }
                ServiceReference[] services = bundle.getRegisteredServices();
                if (services != null) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
                    int j = 0;
                    while (j < services.length) {
                        System.out.print("    ");
                        System.out.println(services[j]);
                        ++j;
                    }
                } else {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
                }
                services = bundle.getServicesInUse();
                if (services != null) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_SERVICES_IN_USE_MESSAGE);
                    int j = 0;
                    while (j < services.length) {
                        System.out.print("    ");
                        System.out.println(services[j]);
                        ++j;
                    }
                } else {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_NO_SERVICES_IN_USE_MESSAGE);
                }
            }
            ++i;
        }
    }

    @Descriptor(value="display details for the specified bundle(s)")
    public void b(@Descriptor(value="(<id>|<location>)") Bundle[] bundles) throws Exception {
        this.bundle(bundles);
    }

    @Descriptor(value="display details for the specified bundle(s)")
    public void bundle(@Descriptor(value="(<id>|<location>)") Bundle[] bundles) throws Exception {
        if (bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            long id = bundle.getBundleId();
            System.out.println(bundle);
            System.out.print("  ");
            System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_ID_MESSAGE, (Object)String.valueOf(id)));
            System.out.print(", ");
            System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_STATUS_MESSAGE, (Object)this.getStateName(bundle)));
            if (id != 0L) {
                File dataRoot = bundle.getDataFile("");
                String root = dataRoot == null ? null : dataRoot.getAbsolutePath();
                System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_DATA_ROOT_MESSAGE, (Object)root));
                System.out.println();
            } else {
                System.out.println();
            }
            ServiceReference[] services = bundle.getRegisteredServices();
            if (services != null) {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_REGISTERED_SERVICES_MESSAGE);
                int j = 0;
                while (j < services.length) {
                    System.out.print("    ");
                    System.out.println(services[j]);
                    ++j;
                }
            } else {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_NO_REGISTERED_SERVICES_MESSAGE);
            }
            services = bundle.getServicesInUse();
            if (services != null) {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_SERVICES_IN_USE_MESSAGE);
                int j = 0;
                while (j < services.length) {
                    System.out.print("    ");
                    System.out.println(services[j]);
                    ++j;
                }
            } else {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_NO_SERVICES_IN_USE_MESSAGE);
            }
            PackageAdmin packageAdmin = this.activator.getPackageAdmin();
            if (packageAdmin == null) {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
            } else {
                PlatformAdmin platAdmin = this.activator.getPlatformAdmin();
                if (platAdmin != null) {
                    BundleDescription desc = platAdmin.getState(false).getBundle(bundle.getBundleId());
                    if (desc != null) {
                        int j;
                        boolean title = true;
                        ExportPackageDescription[] exports = desc.getExportPackages();
                        if (exports == null || exports.length == 0) {
                            System.out.print("  ");
                            System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                        } else {
                            title = true;
                            int i = 0;
                            while (i < exports.length) {
                                if (title) {
                                    System.out.print("  ");
                                    System.out.println(ConsoleMsg.CONSOLE_EXPORTED_PACKAGES_MESSAGE);
                                    title = false;
                                }
                                System.out.print("    ");
                                System.out.print(exports[i].getName());
                                System.out.print("; version=\"");
                                System.out.print(exports[i].getVersion());
                                System.out.print("\"");
                                if (desc.isRemovalPending()) {
                                    System.out.println(ConsoleMsg.CONSOLE_EXPORTED_REMOVAL_PENDING_MESSAGE);
                                } else {
                                    System.out.println(ConsoleMsg.CONSOLE_EXPORTED_MESSAGE);
                                }
                                ++i;
                            }
                            if (title) {
                                System.out.print("  ");
                                System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE);
                            }
                        }
                        title = true;
                        if (desc != null) {
                            int i;
                            ImportPackageSpecification[] importPackages;
                            ArrayList<ImportPackageSpecification> fragmentsImportPackages = new ArrayList<ImportPackageSpecification>();
                            BundleDescription[] fragments = desc.getFragments();
                            int i2 = 0;
                            while (i2 < fragments.length) {
                                ImportPackageSpecification[] fragmentImports = fragments[i2].getImportPackages();
                                int j2 = 0;
                                while (j2 < fragmentImports.length) {
                                    fragmentsImportPackages.add(fragmentImports[j2]);
                                    ++j2;
                                }
                                ++i2;
                            }
                            if (fragmentsImportPackages.size() > 0) {
                                ImportPackageSpecification[] directImportPackages = desc.getImportPackages();
                                importPackages = new ImportPackageSpecification[directImportPackages.length + fragmentsImportPackages.size()];
                                int i3 = 0;
                                while (i3 < directImportPackages.length) {
                                    importPackages[i3] = directImportPackages[i3];
                                    ++i3;
                                }
                                int offset = directImportPackages.length;
                                i = 0;
                                while (i < fragmentsImportPackages.size()) {
                                    importPackages[offset + i] = (ImportPackageSpecification)fragmentsImportPackages.get(i);
                                    ++i;
                                }
                            } else {
                                importPackages = desc.getImportPackages();
                            }
                            ExportPackageDescription[] imports = null;
                            imports = desc.getContainingState().getStateHelper().getVisiblePackages(desc, 3);
                            ArrayList<ImportPackageSpecification> unresolvedImports = new ArrayList<ImportPackageSpecification>();
                            i = 0;
                            while (i < importPackages.length) {
                                if (importPackages[i].getDirective("resolution").equals("optional")) {
                                    if (importPackages[i].getSupplier() == null) {
                                        unresolvedImports.add(importPackages[i]);
                                    }
                                } else if (importPackages[i].getDirective("resolution").equals("dynamic")) {
                                    boolean isResolvable = false;
                                    j = 0;
                                    while (j < imports.length) {
                                        if (importPackages[i].isSatisfiedBy((BaseDescription)imports[j])) {
                                            isResolvable = true;
                                        }
                                        ++j;
                                    }
                                    if (!isResolvable) {
                                        unresolvedImports.add(importPackages[i]);
                                    }
                                }
                                ++i;
                            }
                            title = this.printImportedPackages(imports, title);
                            if (desc.isResolved() && !unresolvedImports.isEmpty()) {
                                this.printUnwiredDynamicImports(unresolvedImports);
                                title = false;
                            }
                        }
                        if (title) {
                            System.out.print("  ");
                            System.out.println(ConsoleMsg.CONSOLE_NO_IMPORTED_PACKAGES_MESSAGE);
                        }
                        if (packageAdmin != null) {
                            RequiredBundle rb;
                            System.out.print("  ");
                            if ((packageAdmin.getBundleType(bundle) & 1) > 0) {
                                Bundle[] hosts = packageAdmin.getHosts(bundle);
                                if (hosts != null) {
                                    System.out.println(ConsoleMsg.CONSOLE_HOST_MESSAGE);
                                    int i = 0;
                                    while (i < hosts.length) {
                                        System.out.print("    ");
                                        System.out.println(hosts[i]);
                                        ++i;
                                    }
                                } else {
                                    System.out.println(ConsoleMsg.CONSOLE_NO_HOST_MESSAGE);
                                }
                            } else {
                                Bundle[] fragments = packageAdmin.getFragments(bundle);
                                if (fragments != null) {
                                    System.out.println(ConsoleMsg.CONSOLE_FRAGMENT_MESSAGE);
                                    int i = 0;
                                    while (i < fragments.length) {
                                        System.out.print("    ");
                                        System.out.println(fragments[i]);
                                        ++i;
                                    }
                                } else {
                                    System.out.println(ConsoleMsg.CONSOLE_NO_FRAGMENT_MESSAGE);
                                }
                            }
                            RequiredBundle[] requiredBundles = packageAdmin.getRequiredBundles(null);
                            RequiredBundle requiredBundle = null;
                            if (requiredBundles != null) {
                                RequiredBundle[] requiredBundleArray = requiredBundles;
                                int n3 = requiredBundles.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    rb = requiredBundleArray[n4];
                                    if (rb.getBundle() == bundle) {
                                        requiredBundle = rb;
                                        break;
                                    }
                                    ++n4;
                                }
                            }
                            if (requiredBundle == null) {
                                System.out.print("  ");
                                System.out.println(ConsoleMsg.CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE);
                            } else {
                                System.out.print("  ");
                                System.out.println(ConsoleMsg.CONSOLE_NAMED_CLASS_SPACE_MESSAGE);
                                System.out.print("    ");
                                System.out.print(requiredBundle);
                                if (requiredBundle.isRemovalPending()) {
                                    System.out.println(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                                } else {
                                    System.out.println(ConsoleMsg.CONSOLE_PROVIDED_MESSAGE);
                                }
                            }
                            title = true;
                            if (requiredBundles != null) {
                                RequiredBundle[] requiredBundleArray = requiredBundles;
                                int n5 = requiredBundles.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    Bundle[] depBundles;
                                    rb = requiredBundleArray[n6];
                                    if (rb != requiredBundle && (depBundles = rb.getRequiringBundles()) != null) {
                                        j = 0;
                                        while (j < depBundles.length) {
                                            if (depBundles[j] == bundle) {
                                                if (title) {
                                                    System.out.print("  ");
                                                    System.out.println(ConsoleMsg.CONSOLE_REQUIRED_BUNDLES_MESSAGE);
                                                    title = false;
                                                }
                                                System.out.print("    ");
                                                System.out.print(rb);
                                                Bundle provider = rb.getBundle();
                                                System.out.print("<");
                                                System.out.print(provider);
                                                System.out.println(">");
                                            }
                                            ++j;
                                        }
                                    }
                                    ++n6;
                                }
                            }
                            if (title) {
                                System.out.print("  ");
                                System.out.println(ConsoleMsg.CONSOLE_NO_REQUIRED_BUNDLES_MESSAGE);
                            }
                        }
                    }
                    System.out.println();
                    System.out.println();
                } else {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PLATFORM_ADMIN_MESSAGE);
                }
            }
            ++n2;
        }
    }

    private boolean printImportedPackages(ExportPackageDescription[] importedPkgs, boolean title) {
        int i = 0;
        while (i < importedPkgs.length) {
            if (title) {
                System.out.print("  ");
                System.out.println(ConsoleMsg.CONSOLE_IMPORTED_PACKAGES_MESSAGE);
                title = false;
            }
            System.out.print("    ");
            System.out.print(importedPkgs[i].getName());
            System.out.print("; version=\"");
            System.out.print(importedPkgs[i].getVersion());
            System.out.print("\"");
            Bundle exporter = this.context.getBundle(importedPkgs[i].getSupplier().getBundleId());
            if (exporter != null) {
                System.out.print("<");
                System.out.print(exporter);
                System.out.println(">");
            } else {
                System.out.print("<");
                System.out.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                System.out.println(">");
            }
            ++i;
        }
        return title;
    }

    private void printUnwiredDynamicImports(List<ImportPackageSpecification> dynamicImports) {
        int i = 0;
        while (i < dynamicImports.size()) {
            ImportPackageSpecification importPackage = dynamicImports.get(i);
            System.out.print("    ");
            System.out.print(importPackage.getName());
            System.out.print("; version=\"");
            System.out.print(importPackage.getVersionRange());
            System.out.print("\"");
            System.out.print("<");
            System.out.print("unwired");
            System.out.print(">");
            System.out.print("<");
            System.out.print(importPackage.getDirective("resolution"));
            System.out.println(">");
            ++i;
        }
    }

    @Descriptor(value="perform a garbage collection")
    public void gc() throws Exception {
        long before = Runtime.getRuntime().freeMemory();
        System.gc();
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        long after = Runtime.getRuntime().freeMemory();
        System.out.print(ConsoleMsg.CONSOLE_TOTAL_MEMORY_MESSAGE);
        System.out.println(String.valueOf(Runtime.getRuntime().totalMemory()));
        System.out.print(ConsoleMsg.CONSOLE_FREE_MEMORY_BEFORE_GARBAGE_COLLECTION_MESSAGE);
        System.out.println(String.valueOf(before));
        System.out.print(ConsoleMsg.CONSOLE_FREE_MEMORY_AFTER_GARBAGE_COLLECTION_MESSAGE);
        System.out.println(String.valueOf(after));
        System.out.print(ConsoleMsg.CONSOLE_MEMORY_GAINED_WITH_GARBAGE_COLLECTION_MESSAGE);
        System.out.println(String.valueOf(after - before));
    }

    @Descriptor(value="uninstall all bundles")
    public void init() throws Exception {
        if (this.context.getBundle(0L).getState() == 32) {
            System.out.print(newline);
            System.out.println(ConsoleMsg.CONSOLE_FRAMEWORK_LAUNCHED_PLEASE_SHUTDOWN_MESSAGE);
            return;
        }
        Bundle[] bundles = this.context.getBundles();
        int size = bundles.length;
        if (size > 0) {
            int i = 0;
            while (i < size) {
                Bundle bundle = bundles[i];
                if (bundle.getBundleId() != 0L) {
                    try {
                        bundle.uninstall();
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        } else {
            System.out.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
        }
        PermissionAdmin securityAdmin = this.activator.getPermissionAdmin();
        ConditionalPermissionAdmin condPermAdmin = this.activator.getConditionalPermissionAdmin();
        if (securityAdmin != null) {
            securityAdmin.setDefaultPermissions(null);
            String[] permLocations = securityAdmin.getLocations();
            if (permLocations != null) {
                int i = 0;
                while (i < permLocations.length) {
                    securityAdmin.setPermissions(permLocations[i], null);
                    ++i;
                }
            }
            ConditionalPermissionUpdate update = condPermAdmin.newConditionalPermissionUpdate();
            update.getConditionalPermissionInfos().clear();
            update.commit();
        }
        if (securityAdmin != null) {
            Enumeration infos = condPermAdmin.getConditionalPermissionInfos();
            while (infos.hasMoreElements()) {
                ((ConditionalPermissionInfo)infos.nextElement()).delete();
            }
        }
    }

    @Descriptor(value="shutdown and exit")
    public void close() throws Exception {
        this.context.getBundle(0L).stop();
        System.exit(0);
    }

    @Descriptor(value="refresh the packages of the specified bundles; if -all option is specified refresh packages of all installed bundles")
    public void r(@Descriptor(value="specify to refresh the packages of all installed bundles") @Parameter(absentValue="false", presentValue="true", names={"-all"}) boolean shouldRefreshAll, Bundle ... bundles) throws Exception {
        this.refresh(shouldRefreshAll, bundles);
    }

    @Descriptor(value="refresh the packages of the specified bundles; if -all option is specified refresh packages of all installed bundles")
    public void refresh(@Descriptor(value="specify to refresh the packages of all installed bundles") @Parameter(absentValue="false", presentValue="true", names={"-all"}) boolean shouldRefreshAll, Bundle ... bundles) throws Exception {
        PackageAdmin packageAdmin = this.activator.getPackageAdmin();
        if (packageAdmin != null) {
            if (bundles != null && bundles.length > 0) {
                packageAdmin.refreshPackages(bundles);
            } else if (shouldRefreshAll) {
                packageAdmin.refreshPackages(this.context.getBundles());
            } else {
                packageAdmin.refreshPackages(null);
            }
        } else {
            System.out.println(ConsoleMsg.CONSOLE_CAN_NOT_REFRESH_NO_PACKAGE_ADMIN_ERROR);
        }
    }

    @Descriptor(value="execute a command in a separate process and wait")
    public void exec(@Descriptor(value="command to be executed") String command) throws Exception {
        if (command == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_COMMAND_SPECIFIED_ERROR);
            return;
        }
        Process p = Runtime.getRuntime().exec(command);
        System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_STARTED_IN_MESSAGE, (Object)command, (Object)String.valueOf(p)));
        int result = p.waitFor();
        System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_EXECUTED_RESULT_CODE_MESSAGE, (Object)command, (Object)String.valueOf(result)));
    }

    @Descriptor(value="execute a command in a separate process")
    public void fork(@Descriptor(value="command to be executed") String command) throws Exception {
        if (command == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_COMMAND_SPECIFIED_ERROR);
            return;
        }
        Process p = Runtime.getRuntime().exec(command);
        System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_STARTED_IN_MESSAGE, (Object)command, (Object)String.valueOf(p)));
    }

    @Descriptor(value="print bundle headers")
    public List<Dictionary<String, String>> h(Bundle ... bundles) throws Exception {
        return this.headers(bundles);
    }

    @Descriptor(value="print bundle headers")
    public List<Dictionary<String, String>> headers(Bundle ... bundles) throws Exception {
        ArrayList<Dictionary<String, String>> headers = new ArrayList<Dictionary<String, String>>();
        if (bundles == null || bundles.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return headers;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            headers.add(bundle.getHeaders());
            ++n2;
        }
        return headers;
    }

    @Descriptor(value="Display system properties")
    public Dictionary<?, ?> pr() throws Exception {
        return this.props();
    }

    @Descriptor(value="Display system properties")
    public Dictionary<?, ?> props() throws Exception {
        System.out.println(ConsoleMsg.CONSOLE_SYSTEM_PROPERTIES_TITLE);
        return System.getProperties();
    }

    @Descriptor(value="set OSGi properties")
    public void setp(@Descriptor(value="list of properties with values to be set; the format is <key>=<value> and the pairs are separated with space if more than one") String[] arguments) throws Exception {
        this.setprop(arguments);
    }

    @Descriptor(value="set OSGi properties")
    public void setprop(@Descriptor(value="list of properties with values to be set; the format is <key>=<value> and the pairs are separated with space if more than one") String[] arguments) throws Exception {
        if (arguments == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_PARAMETERS_SPECIFIED_TITLE);
            this.props();
        } else {
            ServiceReference envInfoRef = this.context.getServiceReference(EnvironmentInfo.class);
            if (envInfoRef != null) {
                EnvironmentInfo envInfo = (EnvironmentInfo)this.context.getService(envInfoRef);
                if (envInfo != null) {
                    System.out.println(ConsoleMsg.CONSOLE_SETTING_PROPERTIES_TITLE);
                    String[] stringArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String argument = stringArray[n2];
                        int index = argument.indexOf("=");
                        if (index > -1) {
                            String key = argument.substring(0, index);
                            String value = argument.substring(index + 1, argument.length());
                            envInfo.setProperty(key, value);
                            System.out.println(tab + key + " = " + value);
                        }
                        ++n2;
                    }
                } else {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_CANNOT_ACCESS_SYSTEM_PROPERTIES);
                }
            }
        }
    }

    @Descriptor(value="display installed bundles (short status)")
    public void ss(String ... arguments) throws Exception {
        int stateFilter;
        if (this.context.getBundle(0L).getState() == 32) {
            System.out.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE);
        } else {
            System.out.println(ConsoleMsg.CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE);
        }
        System.out.println();
        String states = "";
        String[] bsnSegments = null;
        if (arguments != null && arguments.length > 0) {
            if (arguments[0].equals("-s")) {
                if (arguments.length > 1) {
                    states = arguments[1];
                    if (arguments.length > 2) {
                        bsnSegments = new String[arguments.length - 2];
                        System.arraycopy(arguments, 2, bsnSegments, 0, bsnSegments.length);
                    }
                }
            } else {
                bsnSegments = arguments;
            }
        }
        try {
            stateFilter = this.getStatesFromConstants(states);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        Bundle[] bundles = this.context.getBundles();
        int size = bundles.length;
        if (size == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_INSTALLED_BUNDLES_ERROR);
            return;
        }
        System.out.print(newline);
        System.out.print(ConsoleMsg.CONSOLE_ID);
        System.out.print(tab);
        System.out.println(ConsoleMsg.CONSOLE_STATE_BUNDLE_TITLE);
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (this.match(b, bsnSegments, stateFilter)) {
                String label = b.getSymbolicName();
                label = label == null || label.length() == 0 ? b.toString() : String.valueOf(label) + "_" + b.getVersion();
                System.out.println(String.valueOf(b.getBundleId()) + tab + this.getStateName(b) + label);
                PackageAdmin packageAdmin = this.activator.getPackageAdmin();
                if ((packageAdmin.getBundleType(b) & 1) != 0) {
                    Bundle[] hosts = packageAdmin.getHosts(b);
                    if (hosts != null) {
                        int j = 0;
                        while (j < hosts.length) {
                            System.out.println("\t            Master=" + hosts[j].getBundleId());
                            ++j;
                        }
                    }
                } else {
                    Bundle[] fragments = packageAdmin.getFragments(b);
                    if (fragments != null) {
                        System.out.print("\t            Fragments=");
                        int f = 0;
                        while (f < fragments.length) {
                            Bundle fragment = fragments[f];
                            System.out.print(String.valueOf(f > 0 ? ", " : "") + fragment.getBundleId());
                            ++f;
                        }
                        System.out.println();
                    }
                }
            }
            ++n2;
        }
    }

    private boolean match(Bundle toFilter, String[] searchedName, int searchedState) {
        if ((toFilter.getState() & searchedState) == 0) {
            return false;
        }
        return searchedName == null || searchedName.length <= 0 || toFilter.getSymbolicName() == null || toFilter.getSymbolicName().indexOf(searchedName[0]) != -1;
    }

    @Descriptor(value="display threads and thread groups")
    public void t() throws Exception {
        this.threads();
    }

    @Descriptor(value="display threads and thread groups")
    public void threads() throws Exception {
        Object[] threadGroups = this.getThreadGroups();
        Util.sortByString(threadGroups);
        Object tg = this.getTopThreadGroup();
        Object[] threads = new Thread[((ThreadGroup)tg).activeCount()];
        int count = ((ThreadGroup)tg).enumerate((Thread[])threads, true);
        Util.sortByString(threads);
        StringBuffer sb = new StringBuffer(120);
        System.out.println();
        System.out.println(ConsoleMsg.CONSOLE_THREADGROUP_TITLE);
        int i = 0;
        while (i < threadGroups.length) {
            tg = threadGroups[i];
            int all = ((ThreadGroup)tg).activeCount();
            int local = ((ThreadGroup)tg).enumerate(new Thread[all], false);
            ThreadGroup p = ((ThreadGroup)tg).getParent();
            String parent = p == null ? "-none-" : p.getName();
            sb.setLength(0);
            sb.append(Util.toString(this.simpleClassName(tg), 18)).append(" ").append(Util.toString(((ThreadGroup)tg).getName(), 21)).append(" ").append(Util.toString(parent, 16)).append(Util.toString(((ThreadGroup)tg).getMaxPriority(), 3)).append(Util.toString(local, 4)).append("/").append(Util.toString(String.valueOf(all), 6));
            System.out.println(sb.toString());
            ++i;
        }
        System.out.print(newline);
        System.out.println(ConsoleMsg.CONSOLE_THREADTYPE_TITLE);
        int j = 0;
        while (j < count) {
            Object t = threads[j];
            if (t != null) {
                sb.setLength(0);
                sb.append(Util.toString(this.simpleClassName(t), 18)).append(" ").append(Util.toString(((Thread)t).getName(), 21)).append(" ").append(Util.toString(((Thread)t).getThreadGroup().getName(), 16)).append(Util.toString(((Thread)t).getPriority(), 3));
                if (((Thread)t).isDaemon()) {
                    sb.append(" [daemon]");
                }
                System.out.println(sb.toString());
            }
            ++j;
        }
    }

    @Descriptor(value="display the start level for the specified bundle, or for the framework if no bundle specified")
    public void sl(Bundle ... bundle) throws Exception {
        StartLevel startLevel = this.activator.getStartLevel();
        if (startLevel != null) {
            int value = 0;
            if (bundle == null || bundle.length == 0) {
                value = startLevel.getStartLevel();
                System.out.println(NLS.bind((String)ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, (Object)String.valueOf(value)));
            } else {
                value = startLevel.getBundleStartLevel(bundle[0]);
                System.out.println(NLS.bind((String)ConsoleMsg.STARTLEVEL_BUNDLE_STARTLEVEL, (Object)bundle[0].getBundleId(), (Object)value));
            }
        }
    }

    @Descriptor(value="set the framework start level")
    public void setfwsl(@Descriptor(value="new start level") int newSL) throws Exception {
        StartLevel startLevel = this.activator.getStartLevel();
        if (startLevel != null) {
            try {
                startLevel.setStartLevel(newSL);
                System.out.println(NLS.bind((String)ConsoleMsg.STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL, (Object)String.valueOf(newSL)));
            }
            catch (IllegalArgumentException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Descriptor(value="set the start level for the bundle(s)")
    public void setbsl(@Descriptor(value="new start level") int newSL, Bundle ... bundles) throws Exception {
        StartLevel startLevel = this.activator.getStartLevel();
        if (startLevel != null) {
            if (bundles == null) {
                System.out.println(ConsoleMsg.STARTLEVEL_NO_STARTLEVEL_OR_BUNDLE_GIVEN);
                return;
            }
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                try {
                    startLevel.setBundleStartLevel(bundle, newSL);
                    System.out.println(NLS.bind((String)ConsoleMsg.STARTLEVEL_BUNDLE_STARTLEVEL, (Object)bundle.getBundleId(), (Object)newSL));
                }
                catch (IllegalArgumentException e) {
                    System.out.println(e.getMessage());
                }
                ++n2;
            }
        }
    }

    @Descriptor(value="set the initial bundle start level")
    public void setibsl(@Descriptor(value="new start level") int newInitialSL) throws Exception {
        StartLevel startLevel = this.activator.getStartLevel();
        if (startLevel != null) {
            try {
                startLevel.setInitialBundleStartLevel(newInitialSL);
                System.out.println(NLS.bind((String)ConsoleMsg.STARTLEVEL_INITIAL_BUNDLE_STARTLEVEL, (Object)String.valueOf(newInitialSL)));
            }
            catch (IllegalArgumentException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Descriptor(value="lists required bundles having the specified symbolic name")
    public void requiredBundles(String ... symbolicName) {
        this.classSpaces(symbolicName);
    }

    @Descriptor(value="lists required bundles having the specified symbolic name")
    public void classSpaces(String ... symbolicName) {
        PackageAdmin packageAdmin = this.activator.getPackageAdmin();
        if (packageAdmin != null) {
            RequiredBundle[] symBundles = null;
            String name = symbolicName == null || symbolicName.length == 0 ? null : symbolicName[0];
            symBundles = packageAdmin.getRequiredBundles(name);
            if (symBundles == null) {
                System.out.println(ConsoleMsg.CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE);
            } else {
                RequiredBundle[] requiredBundleArray = symBundles;
                int n = symBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle provider;
                    RequiredBundle symBundle = requiredBundleArray[n2];
                    System.out.print(symBundle);
                    boolean removalPending = symBundle.isRemovalPending();
                    if (removalPending) {
                        System.out.print("(");
                        System.out.print(ConsoleMsg.CONSOLE_REMOVAL_PENDING_MESSAGE);
                        System.out.println(")");
                    }
                    if ((provider = symBundle.getBundle()) != null) {
                        System.out.print("<");
                        System.out.print(provider);
                        System.out.println(">");
                        Bundle[] requiring = symBundle.getRequiringBundles();
                        if (requiring != null) {
                            int j = 0;
                            while (j < requiring.length) {
                                System.out.print("  ");
                                System.out.print(requiring[j]);
                                System.out.print(" ");
                                System.out.println(ConsoleMsg.CONSOLE_REQUIRES_MESSAGE);
                                ++j;
                            }
                        }
                    } else {
                        System.out.print("<");
                        System.out.print(ConsoleMsg.CONSOLE_STALE_MESSAGE);
                        System.out.println(">");
                    }
                    ++n2;
                }
            }
        } else {
            System.out.println(ConsoleMsg.CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE);
        }
    }

    @Descriptor(value="Display & flush the profile log messages")
    public void profilelog() throws Exception {
        Class<?> profileClass = BundleContext.class.getClassLoader().loadClass("org.eclipse.osgi.internal.profile.Profile");
        Method getProfileLog = profileClass.getMethod("getProfileLog", null);
        System.out.println(getProfileLog.invoke(null, null));
    }

    @Descriptor(value="lists all packages visible from the specified bundle")
    public void getPackages(@Descriptor(value="bundle to list the visible packages") Bundle bundle) {
        PlatformAdmin platformAdmin = this.activator.getPlatformAdmin();
        if (platformAdmin == null) {
            return;
        }
        BundleDescription bundleDescription = platformAdmin.getState(false).getBundle(bundle.getBundleId());
        ExportPackageDescription[] exports = platformAdmin.getStateHelper().getVisiblePackages(bundleDescription, 3);
        int i = 0;
        while (i < exports.length) {
            System.out.println(exports[i] + ": " + platformAdmin.getStateHelper().getAccessCode(bundleDescription, exports[i]));
            ++i;
        }
    }

    protected int getStartLevelFromToken(String value) {
        int retval = -1;
        try {
            retval = Integer.parseInt(value);
            if (Integer.parseInt(value) <= 0) {
                System.out.println(ConsoleMsg.STARTLEVEL_POSITIVE_INTEGER);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(ConsoleMsg.STARTLEVEL_POSITIVE_INTEGER);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getStateName(Bundle bundle) {
        int state = bundle.getState();
        switch (state) {
            case 1: {
                return "UNINSTALLED ";
            }
            case 2: {
                if (this.isDisabled(bundle)) {
                    return "<DISABLED>  ";
                }
                return "INSTALLED   ";
            }
            case 4: {
                return "RESOLVED    ";
            }
            case 8: {
                List<Bundle> list = this.lazyActivation;
                synchronized (list) {
                    if (this.lazyActivation.contains(bundle)) {
                        return "<<LAZY>>    ";
                    }
                    return "STARTING    ";
                }
            }
            case 16: {
                return "STOPPING    ";
            }
            case 32: {
                return "ACTIVE      ";
            }
        }
        return Integer.toHexString(state);
    }

    private boolean isDisabled(Bundle bundle) {
        boolean disabled = false;
        ServiceReference platformAdminRef = null;
        try {
            BundleDescription bundleDesc;
            State state;
            DisabledInfo[] disabledInfos;
            PlatformAdmin platAdmin;
            platformAdminRef = this.context.getServiceReference(PlatformAdmin.class.getName());
            if (platformAdminRef != null && (platAdmin = (PlatformAdmin)this.context.getService(platformAdminRef)) != null && (disabledInfos = (state = platAdmin.getState(false)).getDisabledInfos(bundleDesc = state.getBundle(bundle.getBundleId()))) != null && disabledInfos.length != 0) {
                disabled = true;
            }
        }
        finally {
            if (platformAdminRef != null) {
                this.context.ungetService(platformAdminRef);
            }
        }
        return disabled;
    }

    protected ThreadGroup[] getThreadGroups() {
        ThreadGroup[] groups;
        ThreadGroup tg = this.getTopThreadGroup();
        int count = tg.enumerate(groups = new ThreadGroup[tg.activeGroupCount()], true);
        if (count == groups.length) {
            return groups;
        }
        ThreadGroup[] ngroups = new ThreadGroup[count];
        System.arraycopy(groups, 0, ngroups, 0, count);
        return ngroups;
    }

    protected ThreadGroup getTopThreadGroup() {
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        if (topGroup != null) {
            while (topGroup.getParent() != null) {
                topGroup = topGroup.getParent();
            }
        }
        return topGroup;
    }

    public String simpleClassName(Object o) {
        StringTokenizer t = new StringTokenizer(o.getClass().getName(), ".");
        int ct = t.countTokens();
        int i = 1;
        while (i < ct) {
            t.nextToken();
            ++i;
        }
        return t.nextToken();
    }

    @Descriptor(value="displays the system properties with the given name, or all of them")
    public void getprop(String ... propName) throws Exception {
        Properties allProperties = System.getProperties();
        for (String string : new TreeSet<Object>(allProperties.keySet())) {
            if (propName != null && propName.length != 0 && !string.startsWith(propName[0])) continue;
            System.out.println(String.valueOf(string) + '=' + allProperties.getProperty(string));
        }
    }

    @Descriptor(value="Displays unsatisfied constraints for the specified bundle(s)")
    public void diag(@Descriptor(value="IDs of bundle(s), for which to display unsatisfied constraints") long[] bundleIds) throws Exception {
        if (bundleIds.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        PlatformAdmin platformAdmin = this.activator.getPlatformAdmin();
        if (platformAdmin == null) {
            System.out.println(ConsoleMsg.CONSOLE_NO_CONSTRAINTS_NO_PLATFORM_ADMIN_MESSAGE);
            return;
        }
        State systemState = platformAdmin.getState(false);
        long[] lArray = bundleIds;
        int n = bundleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long bundleId = lArray[n2];
            BundleDescription bundle = systemState.getBundle(bundleId);
            if (bundle == null) {
                System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_CANNOT_FIND_BUNDLE_ERROR, (Object)bundleId));
            } else {
                System.out.println(String.valueOf(bundle.getLocation()) + " [" + bundle.getBundleId() + "]");
                VersionConstraint[] unsatisfied = platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundle);
                ResolverError[] resolverErrors = platformAdmin.getState(false).getResolverErrors(bundle);
                int i = 0;
                while (i < resolverErrors.length) {
                    if ((resolverErrors[i].getType() & 0x8007) == 0) {
                        System.out.print("  ");
                        System.out.println(resolverErrors[i].toString());
                    }
                    ++i;
                }
                if (unsatisfied.length == 0 && resolverErrors.length == 0) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_NO_CONSTRAINTS);
                }
                if (unsatisfied.length > 0) {
                    System.out.print("  ");
                    System.out.println(ConsoleMsg.CONSOLE_DIRECT_CONSTRAINTS);
                }
                i = 0;
                while (i < unsatisfied.length) {
                    System.out.print("    ");
                    System.out.println(this.getResolutionFailureMessage(unsatisfied[i]));
                    ++i;
                }
                VersionConstraint[] unsatisfiedLeaves = platformAdmin.getStateHelper().getUnsatisfiedLeaves(new BundleDescription[]{bundle});
                boolean foundLeaf = false;
                int i2 = 0;
                while (i2 < unsatisfiedLeaves.length) {
                    if (unsatisfiedLeaves[i2].getBundle() != bundle) {
                        if (!foundLeaf) {
                            foundLeaf = true;
                            System.out.print("  ");
                            System.out.println(ConsoleMsg.CONSOLE_LEAF_CONSTRAINTS);
                        }
                        System.out.print("    ");
                        System.out.println(String.valueOf(unsatisfiedLeaves[i2].getBundle().getLocation()) + " [" + unsatisfiedLeaves[i2].getBundle().getBundleId() + "]");
                        System.out.print("      ");
                        System.out.println(this.getResolutionFailureMessage(unsatisfiedLeaves[i2]));
                    }
                    ++i2;
                }
            }
            ++n2;
        }
    }

    @Descriptor(value="Enable the specified bundle(s)")
    public void enableBundle(@Descriptor(value="IDs of bundle(s) to enable") long[] bundleIds) throws Exception {
        if (bundleIds.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        PlatformAdmin platformAdmin = this.activator.getPlatformAdmin();
        if (platformAdmin == null) {
            System.out.println(ConsoleMsg.CONSOLE_CANNOT_ENABLE_NO_PLATFORM_ADMIN_MESSAGE);
            return;
        }
        State systemState = platformAdmin.getState(false);
        long[] lArray = bundleIds;
        int n = bundleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long bundleId = lArray[n2];
            BundleDescription bundle = systemState.getBundle(bundleId);
            if (bundle == null) {
                System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_CANNOT_FIND_BUNDLE_ERROR, (Object)bundleId));
            } else {
                DisabledInfo[] infos = systemState.getDisabledInfos(bundle);
                int i = 0;
                while (i < infos.length) {
                    platformAdmin.removeDisabledInfo(infos[i]);
                    ++i;
                }
            }
            ++n2;
        }
    }

    @Descriptor(value="Disable the specified bundle(s)")
    public void disableBundle(@Descriptor(value="IDs of bundle(s) to disable") long[] bundleIds) throws Exception {
        if (bundleIds.length == 0) {
            System.out.println(ConsoleMsg.CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        PlatformAdmin platformAdmin = this.activator.getPlatformAdmin();
        if (platformAdmin == null) {
            System.out.println(ConsoleMsg.CONSOLE_CANNOT_DISABLE_NO_PLATFORM_ADMIN_MESSAGE);
            return;
        }
        State systemState = platformAdmin.getState(false);
        long[] lArray = bundleIds;
        int n = bundleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long bundleId = lArray[n2];
            BundleDescription bundle = systemState.getBundle(bundleId);
            if (bundle == null) {
                System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_CANNOT_FIND_BUNDLE_ERROR, (Object)bundleId));
            } else {
                DisabledInfo info = new DisabledInfo(POLICY_CONSOLE, ConsoleMsg.CONSOLE_CONSOLE_BUNDLE_DISABLED_MESSAGE, bundle);
                platformAdmin.addDisabledInfo(info);
            }
            ++n2;
        }
    }

    @Descriptor(value="List disabled bundles in the system")
    public void disabledBundles() throws Exception {
        PlatformAdmin platformAdmin = this.activator.getPlatformAdmin();
        if (platformAdmin == null) {
            System.out.println(ConsoleMsg.CONSOLE_CANNOT_LIST_DISABLED_NO_PLATFORM_ADMIN_MESSAGE);
            return;
        }
        State systemState = platformAdmin.getState(false);
        BundleDescription[] disabledBundles = systemState.getDisabledBundles();
        System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_DISABLED_COUNT_MESSAGE, (Object)String.valueOf(disabledBundles.length)));
        if (disabledBundles.length > 0) {
            System.out.println();
        }
        int i = 0;
        while (i < disabledBundles.length) {
            DisabledInfo[] disabledInfos = systemState.getDisabledInfos(disabledBundles[i]);
            System.out.println(NLS.bind((String)ConsoleMsg.CONSOLE_DISABLED_BUNDLE_HEADER, (Object)this.formatBundleName(disabledBundles[i]), (Object)String.valueOf(disabledBundles[i].getBundleId())));
            System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_DISABLED_BUNDLE_REASON, (Object)disabledInfos[0].getMessage(), (Object)disabledInfos[0].getPolicyName()));
            int j = 1;
            while (j < disabledInfos.length) {
                System.out.print(NLS.bind((String)ConsoleMsg.CONSOLE_DISABLED_BUNDLE_REASON, (Object)disabledInfos[j].getMessage(), (Object)String.valueOf(disabledInfos[j].getPolicyName())));
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    private String formatBundleName(BundleDescription b) {
        String label = b.getSymbolicName();
        label = label == null || label.length() == 0 ? b.toString() : String.valueOf(label) + "_" + b.getVersion();
        return label;
    }

    private String getResolutionFailureMessage(VersionConstraint unsatisfied) {
        if (unsatisfied.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (unsatisfied instanceof ImportPackageSpecification) {
            if ("optional".equals(((ImportPackageSpecification)unsatisfied).getDirective("resolution"))) {
                return NLS.bind((String)ConsoleMsg.CONSOLE_MISSING_OPTIONAL_IMPORTED_PACKAGE, (Object)EquinoxCommandProvider.versionToString(unsatisfied));
            }
            if ("dynamic".equals(((ImportPackageSpecification)unsatisfied).getDirective("resolution"))) {
                return NLS.bind((String)ConsoleMsg.CONSOLE_MISSING_DYNAMIC_IMPORTED_PACKAGE, (Object)EquinoxCommandProvider.versionToString(unsatisfied));
            }
            return NLS.bind((String)ConsoleMsg.CONSOLE_MISSING_IMPORTED_PACKAGE, (Object)EquinoxCommandProvider.versionToString(unsatisfied));
        }
        if (unsatisfied instanceof BundleSpecification) {
            if (((BundleSpecification)unsatisfied).isOptional()) {
                return NLS.bind((String)ConsoleMsg.CONSOLE_MISSING_OPTIONAL_REQUIRED_BUNDLE, (Object)EquinoxCommandProvider.versionToString(unsatisfied));
            }
            return NLS.bind((String)ConsoleMsg.CONSOLE_MISSING_REQUIRED_BUNDLE, (Object)EquinoxCommandProvider.versionToString(unsatisfied));
        }
        if (unsatisfied instanceof HostSpecification) {
            return NLS.bind((String)ConsoleMsg.CONSOLE_MISSING_HOST, (Object)EquinoxCommandProvider.versionToString(unsatisfied));
        }
        if (unsatisfied instanceof NativeCodeSpecification) {
            return NLS.bind((String)ConsoleMsg.CONSOLE_MISSING_NATIVECODE, (Object)unsatisfied.toString());
        }
        if (unsatisfied instanceof GenericSpecification) {
            return NLS.bind((String)ConsoleMsg.CONSOLE_MISSING_REQUIRED_CAPABILITY, (Object)unsatisfied.toString());
        }
        return NLS.bind((String)ConsoleMsg.CONSOLE_MISSING_REQUIREMENT, (Object)unsatisfied.toString());
    }

    private static String versionToString(VersionConstraint constraint) {
        VersionRange versionRange = constraint.getVersionRange();
        if (versionRange == null) {
            return constraint.getName();
        }
        return String.valueOf(constraint.getName()) + '_' + versionRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Bundle bundle = event.getBundle();
        List<Bundle> list = this.lazyActivation;
        synchronized (list) {
            switch (type) {
                case 512: {
                    if (this.lazyActivation.contains(bundle)) break;
                    this.lazyActivation.add(bundle);
                    break;
                }
                default: {
                    this.lazyActivation.remove(bundle);
                }
            }
        }
    }
}

