/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rtp.configurator.ui.ComponentsTab;
import org.eclipse.rtp.configurator.ui.ConfiguratorUiBody;
import org.eclipse.rtp.configurator.ui.ConfiguratorUiFooter;
import org.eclipse.rtp.configurator.ui.ConfiguratorUiHeader;
import org.eclipse.rtp.configurator.ui.TabContribution;
import org.eclipse.rtp.configurator.ui.UiHelper;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UIEntryPoint
implements IEntryPoint {
    private final List<TabContribution> contributions = new ArrayList<TabContribution>();
    private ConfiguratorUiHeader configuratorUiHeader;
    private ConfiguratorUiBody configuratorUiBody;
    private ConfiguratorUiFooter configuratorUiFooter;

    public int createUI() {
        this.initUI();
        this.openUI();
        return 0;
    }

    private void initUI() {
        this.configuratorUiHeader = new ConfiguratorUiHeader();
        this.configuratorUiBody = new ConfiguratorUiBody();
        this.configuratorUiFooter = new ConfiguratorUiFooter();
    }

    private void openUI() {
        Display display = new Display();
        Shell shell = UiHelper.createShell(display);
        this.initShell(shell);
        this.configuratorUiHeader.createHeader(display, shell);
        this.contributions.add(new ComponentsTab());
        this.configuratorUiBody.createBody(shell, this.contributions);
        this.configuratorUiFooter.createFooter(shell);
        shell.open();
    }

    private void initShell(Shell shell) {
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                UIEntryPoint.this.disposeUI();
            }
        });
    }

    private void disposeUI() {
        this.configuratorUiHeader.dispose();
        this.configuratorUiBody.dispose();
        this.configuratorUiFooter.dispose();
    }
}

