/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.ui;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rtp.configurator.ui.AbstractTabContribution;
import org.eclipse.rtp.configurator.ui.ComponentsFilter;
import org.eclipse.rtp.configurator.ui.ComponentsTabContentUtil;
import org.eclipse.rtp.configurator.ui.RefreshButtonSelectionListener;
import org.eclipse.rtp.configurator.ui.SourcesContentProvider;
import org.eclipse.rtp.configurator.ui.SourcesLabelProvider;
import org.eclipse.rtp.configurator.ui.UiHelper;
import org.eclipse.rtp.configurator.ui.internal.event.EventingServiceUtil;
import org.eclipse.rtp.configurator.ui.internal.event.IConfigurationEvent;
import org.eclipse.rtp.configurator.ui.internal.event.IConfigurationListener;
import org.eclipse.rtp.core.model.Source;
import org.eclipse.rtp.core.model.SourceVersion;
import org.eclipse.rwt.RWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ComponentsTab
extends AbstractTabContribution {
    private final SourcesContentProvider contentProvider = new SourcesContentProvider();
    TreeViewer viewer;
    private Combo combo;
    private Button addSource;
    private Button removeSource;
    private Button updateWorld;
    private Display display;
    ComponentsTabContentUtil contentUtil = new ComponentsTabContentUtil();

    @Override
    public String getTitle() {
        return "Runtime Components";
    }

    @Override
    protected void populateControl(Display display, Composite composite) {
        this.display = display;
        Composite tab = UiHelper.createGreedyGridComposite(composite, 1, true);
        ComponentsFilter filter = this.createToolBar(tab);
        this.createTreeView(display, tab, filter);
        Composite provisioningActionsComposite = UiHelper.createGridComposite(tab, 2, false);
        this.addInstallButton(provisioningActionsComposite);
        this.addUninstallButton(provisioningActionsComposite);
        this.addUpdateWorldButton(provisioningActionsComposite);
        this.registerTabForConfigurationChanges();
    }

    private ComponentsFilter createToolBar(Composite tab) {
        Composite tabToolbarComposite = UiHelper.createGridComposite(tab, 3, true);
        Composite searchComposite = new Composite(tabToolbarComposite, 0);
        searchComposite.setLayout((Layout)new GridLayout(2, false));
        searchComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label searchLabel = new Label(searchComposite, 0);
        searchLabel.setText("Search: ");
        final Text filterText = UiHelper.createText(searchComposite, 1, "Please enter filter");
        final ComponentsFilter filter = new ComponentsFilter();
        filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                filter.setSearchText(filterText.getText());
                ComponentsTab.this.viewer.refresh();
            }
        });
        Composite filterComposite = new Composite(tabToolbarComposite, 0);
        filterComposite.setLayout((Layout)new GridLayout(2, false));
        filterComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label filterLabel = new Label(filterComposite, 0);
        filterLabel.setText("Filter: ");
        this.combo = UiHelper.createComboBox(filterComposite, 1, this.contentUtil.getComboLabels());
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentsTab.this.refresh();
            }
        });
        Composite refreshComposite = new Composite(tabToolbarComposite, 0);
        refreshComposite.setLayout((Layout)new GridLayout(2, true));
        refreshComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(refreshComposite, 0);
        Button refreshButton = UiHelper.createPushButton(refreshComposite, "refresh");
        refreshButton.addSelectionListener((SelectionListener)new RefreshButtonSelectionListener(this));
        return filter;
    }

    private void createTreeView(Display display, Composite tab, ComponentsFilter filter) {
        Composite treeComposite = UiHelper.createGreedyGridComposite(tab, 1, true);
        this.viewer = UiHelper.createTreeViewer(new Composite(treeComposite, 0));
        this.viewer.addFilter((ViewerFilter)filter);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object eventSource = event.getSource();
                TreeViewer viewer = (TreeViewer)eventSource;
                ISelection selection = viewer.getSelection();
                TreeSelection treeSelection = (TreeSelection)selection;
                Object selectedElement = treeSelection.getFirstElement();
                ComponentsTab.this.updateButtons(selectedElement);
            }
        };
        this.viewer.addSelectionChangedListener(listener);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        SourcesLabelProvider labelProvider = new SourcesLabelProvider(this.contentUtil);
        labelProvider.init(display);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setInput(new ArrayList());
    }

    private void registerTabForConfigurationChanges() {
        IConfigurationListener configurationListenerService = EventingServiceUtil.getConfigurationListenerService();
        configurationListenerService.addInterestedView(RWT.getSessionStore().getId(), this);
    }

    private void addUninstallButton(Composite tab) {
        this.removeSource = UiHelper.createPushButton(tab, 1, "remove");
        this.removeSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentsTab.this.contentUtil.getRestTemplate().delete("/rt/uninstall" + ComponentsTab.this.generateSelectedSourceUri());
            }
        });
    }

    private void addUpdateWorldButton(Composite tab) {
        this.updateWorld = UiHelper.createPushButton(tab, 2, "updateWorld");
        this.updateWorld.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentsTab.this.contentUtil.getRestTemplate().put("/rt/updateworld");
            }
        });
    }

    private void addInstallButton(Composite tab) {
        this.addSource = UiHelper.createPushButton(tab, 1, "add");
        this.addSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String uri = "/rt/install" + ComponentsTab.this.generateSelectedSourceUri();
                ComponentsTab.this.contentUtil.getRestTemplate().put(uri);
            }
        });
    }

    void updateButtons(Object selectedElement) {
        SourceVersion sourceVersion = selectedElement instanceof Source ? (SourceVersion)((Source)selectedElement).getVersions().get(0) : (SourceVersion)selectedElement;
        if (sourceVersion == null) {
            this.addSource.setEnabled(false);
            this.removeSource.setEnabled(false);
        } else if (this.contentUtil.isInstalled(sourceVersion)) {
            this.addSource.setEnabled(false);
            this.removeSource.setEnabled(true);
        } else {
            this.addSource.setEnabled(true);
            this.removeSource.setEnabled(false);
        }
    }

    String generateSelectedSourceUri() {
        String version = null;
        String name = null;
        Object selectedElement = this.viewer.getTree().getSelection()[0].getData();
        if (selectedElement instanceof Source) {
            version = ((SourceVersion)((Source)selectedElement).getVersions().get(0)).getVersion();
            name = ((Source)selectedElement).getName();
        } else if (selectedElement instanceof SourceVersion) {
            version = ((SourceVersion)selectedElement).getVersion();
            name = this.contentUtil.getSourceVersionSource((SourceVersion)selectedElement).getName();
        }
        String uri = "/" + name + "/" + version;
        return uri;
    }

    public void configurationChanged(IConfigurationEvent event) {
        this.contentUtil.setConfigurationURI(event.getNewIntanceURI());
        this.refresh();
    }

    public void refresh() {
        if (this.contentUtil != null && !this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    int selectionIndex = ComponentsTab.this.combo.getSelectionIndex();
                    ComponentsTab.this.contentUtil.refresh(ComponentsTab.this.contentUtil.getComboLabels()[selectionIndex]);
                    ComponentsTab.this.viewer.setInput(ComponentsTab.this.contentUtil.getSourcec());
                    ComponentsTab.this.addSource.setEnabled(false);
                    ComponentsTab.this.removeSource.setEnabled(false);
                }
            });
        }
    }

    @Override
    public void dispose() {
        IConfigurationListener configurationListenerService = EventingServiceUtil.getConfigurationListenerService();
        configurationListenerService.removeInterestedView(RWT.getSessionStore().getId());
    }
}

