/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ip.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.equinox.internal.ip.ProvisioningInfoProvider;
import org.eclipse.equinox.internal.ip.ProvisioningStorage;
import org.eclipse.equinox.internal.ip.impl.Log;
import org.eclipse.equinox.internal.ip.impl.ProvisioningData;
import org.eclipse.equinox.internal.util.timer.Timer;
import org.eclipse.equinox.internal.util.timer.TimerListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.provisioning.ProvisioningService;

public class ProvisioningAgent
implements BundleActivator,
ProvisioningService,
ServiceListener,
FrameworkListener,
TimerListener {
    public static final String STORAGE = "Prv-Storage";
    public static final String URL_HANDLERS = "Url-Handlers";
    public static final String MULTICAST_HOST = "equinox.provisioning.multicast.host";
    public static final String MULTICAST_PORT = "equinox.provisioning.multicast.port";
    public static final String HTTP_ALLOWED = "equinox.provisioning.httpprv.allowed";
    public static final String WAIT_FW_START = "equinox.provisioning.prv.fwstart";
    public static final String REPROVISIONING_ON_START = "equinox.provisioning.reprovision.onstart";
    public static final String CLOSE_ZIP = "equinox.provisioning.close.zip";
    public static final String DEBUG = "equinox.provisioning.debug";
    public static final String REMOTE_DEBUG = "equinox.provisioning.remote.debug";
    public static BundleContext bc;
    private ProvisioningData info;
    private ServiceRegistration sreg;
    private ProvisioningStorage storage;
    private boolean httpAllowed;
    private boolean destroyStorageOnStop = false;
    private Vector providers;
    private Vector urlHandlers;
    private Runnable da;
    private boolean wfs;
    private boolean active;
    private boolean startProcessed;
    private boolean reprovision;
    private boolean registered;
    private boolean closeZip;
    private static final int PROVISIONING = 1;
    private static final String HAS_FAILED_PROVISIONG = "!@#$_hasFailedPrv";
    private boolean reAfterPrvFailureDisabled;
    private int a;
    private int b;
    private int changePeriod;
    private int maxPeriod;
    private Timer timer;
    private long nextProvisioningAfter;
    private int times;
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_LOAD_STORE_DATA = 1;
    public static final int ERROR_MALFORMED_URL = 2;
    public static final int ERROR_IO_EXCEPTION = 3;
    public static final int ERROR_CORRUPTED_ZIP = 4;
    private static final ByteArrayOutputStream baos;
    private static final byte[] buffer;
    static final String TYPE = "type";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        baos = new ByteArrayOutputStream();
        buffer = new byte[1024];
    }

    public void start(BundleContext bc) throws Exception {
        ProvisioningAgent.bc = bc;
        this.active = false;
        this.startProcessed = false;
        this.wfs = true;
        if (bc.getProperty(WAIT_FW_START) != null && bc.getProperty(WAIT_FW_START).equals("false")) {
            this.wfs = false;
        }
        this.httpAllowed = true;
        if (bc.getProperty(HTTP_ALLOWED) != null && bc.getProperty(HTTP_ALLOWED).equals("false")) {
            this.httpAllowed = false;
        }
        this.reprovision = ProvisioningAgent.getBoolean(REPROVISIONING_ON_START);
        this.closeZip = ProvisioningAgent.getBoolean(CLOSE_ZIP);
        this.reAfterPrvFailureDisabled = ProvisioningAgent.getBoolean("equinox.provisioning.provisioning.reAfterPrvFailure.disabled");
        this.a = ProvisioningAgent.getInteger("equinox.provisioning.provisioning.reAfterPrvFailure.a", 60000);
        this.b = ProvisioningAgent.getInteger("equinox.provisioning.provisioning.reAfterPrvFailure.b", 60000);
        this.changePeriod = ProvisioningAgent.getInteger("equinox.provisioning.provisioning.reAfterPrvFailure.changePeriod", 300000);
        this.maxPeriod = ProvisioningAgent.getInteger("equinox.provisioning.provisioning.reAfterPrvFailure.maxperiod", 3600000);
        this.nextProvisioningAfter = this.a;
        Log.j9workAround = ProvisioningAgent.getBoolean("equinox.provisioning.j9.2.0.workaround");
        Log.debug = ProvisioningAgent.getBoolean(DEBUG);
        Log.remoteDebug = ProvisioningAgent.getBoolean(REMOTE_DEBUG);
        Log.sendTrace = ProvisioningAgent.getBoolean("equinox.provisioning.send.trace");
        Log.prvSrv = this;
        org.eclipse.equinox.internal.util.ref.Log log = new org.eclipse.equinox.internal.util.ref.Log(bc);
        log.setDebug(true);
        log.setPrintOnConsole(Log.debug);
        Log.log = log;
        try {
            this.start0(bc);
        }
        catch (Exception exc) {
            Log.log.close();
            Log.log = null;
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start0(BundleContext bc) throws Exception {
        block82: {
            ServiceReference[] srefs;
            ProvisioningAgent e3;
            String providersHeader;
            String storageName;
            Log.debug("Starting provisioning agent ...");
            Bundle thisBundle = bc.getBundle();
            String urlHandlersHeader = (String)thisBundle.getHeaders().get(URL_HANDLERS);
            if (urlHandlersHeader != null) {
                StringTokenizer strTok = new StringTokenizer(urlHandlersHeader, ", ");
                this.urlHandlers = new Vector(strTok.countTokens());
                while (strTok.hasMoreTokens()) {
                    try {
                        BundleActivator handler = (BundleActivator)Class.forName(strTok.nextToken().trim()).newInstance();
                        handler.start(bc);
                        this.urlHandlers.addElement(handler);
                    }
                    catch (Exception e2) {
                        Log.debug("Can't instantiate or start a handler!");
                        throw e2;
                    }
                }
                urlHandlersHeader = null;
            }
            if ((storageName = (String)thisBundle.getHeaders().get(STORAGE)) != null) {
                storageName.trim();
            }
            if ((providersHeader = (String)thisBundle.getHeaders().get("PrvInfo-Providers")) != null) {
                this.providers = new Vector(5);
                StringTokenizer strTok = new StringTokenizer(providersHeader, ",; ");
                while (strTok.hasMoreTokens()) {
                    String providerName = strTok.nextToken().trim();
                    strTok.nextToken();
                    Object provider = Class.forName(providerName).newInstance();
                    if (provider instanceof BundleActivator) {
                        ((BundleActivator)provider).start(bc);
                    }
                    if (providerName.equals(storageName)) {
                        this.storage = (ProvisioningStorage)provider;
                        this.destroyStorageOnStop = true;
                    }
                    this.providers.addElement(provider);
                }
            }
            if (this.storage == null && storageName != null && storageName.length() != 0) {
                try {
                    this.storage = (ProvisioningStorage)Class.forName(storageName).newInstance();
                    if (this.storage instanceof BundleActivator) {
                        ((BundleActivator)this.storage).start(bc);
                        this.destroyStorageOnStop = true;
                    }
                }
                catch (Exception e3) {
                    Log.debug("Can't instantiate or start storage \"" + this.storage + "\"!");
                    throw e3;
                }
            }
            this.info = new ProvisioningData();
            if (this.storage == null) {
                e3 = this;
                synchronized (e3) {
                    StringBuffer stringBuffer = new StringBuffer("(|(objectClass=");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.equinox.internal.ip.ProvisioningStorage");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append(")").append('(').append("objectClass").append('=');
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.eclipse.equinox.internal.ip.ProvisioningInfoProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StringBuffer stringBuffer3 = stringBuffer2.append(clazz2.getName()).append(")").append('(').append("objectClass").append('=');
                    Class<?> clazz3 = class$2;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$2 = Class.forName("org.eclipse.equinox.internal.util.timer.Timer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    bc.addServiceListener((ServiceListener)this, stringBuffer3.append(clazz3.getName()).append(')').append(")").toString());
                    this.storage = this.getStorage();
                }
            }
            StringBuffer stringBuffer = new StringBuffer("(|(objectClass=");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.equinox.internal.ip.ProvisioningInfoProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer4 = stringBuffer.append(clazz.getName()).append(')').append('(').append("objectClass").append('=');
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("org.eclipse.equinox.internal.util.timer.Timer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bc.addServiceListener((ServiceListener)this, stringBuffer4.append(clazz4.getName()).append(')').append(")").toString());
            e3 = this;
            synchronized (e3) {
                if (this.timer == null) {
                    ServiceReference sRef;
                    Class<?> clazz5 = class$2;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$2 = Class.forName("org.eclipse.equinox.internal.util.timer.Timer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((sRef = bc.getServiceReference(clazz5.getName())) != null) {
                        this.timer = (Timer)bc.getService(sRef);
                    }
                }
            }
            if (this.storage != null) {
                Log.debug("Loads from " + this.storage + " storage.");
                try {
                    Dictionary storedInfo = this.storage.getStoredInfo();
                    if (storedInfo != null && storedInfo.size() != 0) {
                        this.info.add(storedInfo);
                    }
                }
                catch (Exception e4) {
                    Log.debug(e4);
                    this.setError(1, e4.toString());
                    if (this.destroyStorageOnStop) {
                        Log.debug("Warning: the storage could be unavailable!");
                    }
                    this.storage = null;
                }
            }
            if (this.getHasFailedPrv() && !this.reAfterPrvFailureDisabled) {
                this.reprovision = true;
            }
            boolean hasLoadedInfo = false;
            Class<?> clazz6 = class$1;
            if (clazz6 == null) {
                try {
                    clazz6 = class$1 = Class.forName("org.eclipse.equinox.internal.ip.ProvisioningInfoProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((srefs = bc.getServiceReferences(clazz6.getName(), null)) != null) {
                this.sort(srefs);
                int i = 0;
                while (i < srefs.length) {
                    ProvisioningInfoProvider provider = (ProvisioningInfoProvider)bc.getService(srefs[i]);
                    try {
                        ProvisioningData provisioningData = this.info;
                        synchronized (provisioningData) {
                            if (!this.info.providers.contains(provider)) {
                                Log.debug("Loads from " + provider + " provider.");
                                this.info.providers.addElement(provider);
                                Dictionary toAdd = provider.init(this);
                                if (toAdd != null && toAdd.size() != 0) {
                                    String prvref = (String)toAdd.get("provisioning.reference");
                                    if (prvref != null && prvref.trim().length() != 0) {
                                        this.reprovision = true;
                                    }
                                    this.info.add(toAdd);
                                    hasLoadedInfo = true;
                                }
                            }
                        }
                    }
                    catch (Exception e5) {
                        Log.debug(e5);
                    }
                    ++i;
                }
            }
            if (!this.isFrameworkStarted()) {
                bc.addFrameworkListener((FrameworkListener)this);
            } else {
                this.wfs = false;
            }
            if (hasLoadedInfo) {
                this.store();
            }
            this.active = true;
            this.processStart();
            try {
                String host = "225.0.0.0";
                if (bc.getProperty(MULTICAST_HOST) != null) {
                    host = bc.getProperty(MULTICAST_HOST);
                }
                String port = Integer.toString(ProvisioningAgent.getInteger(MULTICAST_PORT, 7777));
                if (host.length() == 0 || port.length() == 0) break block82;
                Class<?> dscAgentClass = Class.forName("org.eclipse.equinox.internal.ip.impl.dscagent.DiscoveryAgent");
                Class[] classArray = new Class[4];
                Class<?> clazz7 = class$3;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$3 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz7;
                classArray[1] = Integer.TYPE;
                Class<?> clazz8 = class$4;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$4 = Class.forName("org.osgi.framework.BundleContext");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz8;
                Class<?> clazz9 = class$5;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$5 = Class.forName("org.eclipse.equinox.internal.ip.impl.ProvisioningAgent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[3] = clazz9;
                Constructor<?> constr = dscAgentClass.getConstructor(classArray);
                this.da = (Runnable)constr.newInstance(host, new Integer(Integer.parseInt(port)), bc, this);
                new Thread(this.da, "Discovery Agent").start();
            }
            catch (Throwable throwable) {
                Log.debug("Can't create discovery agent!");
            }
        }
        Log.debug("Provisioning agent started ...");
    }

    public void stop(BundleContext bc) throws Exception {
        Log.debug("Stopping provisionig agent ...");
        if (this.timer != null) {
            try {
                this.timer.removeListener((TimerListener)this, 1);
            }
            catch (Throwable throwable) {}
            this.timer = null;
        }
        this.registered = false;
        try {
            bc.removeServiceListener((ServiceListener)this);
        }
        catch (Exception exception) {}
        try {
            bc.removeFrameworkListener((FrameworkListener)this);
        }
        catch (Exception exception) {}
        if (this.sreg != null) {
            try {
                this.sreg.unregister();
            }
            catch (Exception exception) {}
            this.sreg = null;
        }
        if (this.da != null) {
            try {
                Method close = this.da.getClass().getMethod("close", new Class[0]);
                close.invoke((Object)this.da, new Object[0]);
            }
            catch (Exception e) {
                Log.debug(e);
            }
            this.da = null;
        }
        if (this.storage != null) {
            if (this.destroyStorageOnStop) {
                try {
                    if (this.storage instanceof BundleActivator) {
                        ((BundleActivator)this.storage).stop(bc);
                    }
                }
                catch (Exception e) {
                    Log.debug(e);
                }
                this.destroyStorageOnStop = false;
            }
            this.storage = null;
        }
        if (this.providers != null) {
            int i = this.providers.size();
            while (i-- > 0) {
                try {
                    ((BundleActivator)this.providers.elementAt(i)).stop(bc);
                }
                catch (Exception e) {
                    Log.debug(e);
                }
            }
            this.providers = null;
        }
        if (this.urlHandlers != null) {
            int i = this.urlHandlers.size();
            while (i-- > 0) {
                try {
                    ((BundleActivator)this.urlHandlers.elementAt(i)).stop(bc);
                }
                catch (Exception e) {
                    Log.debug(e);
                }
            }
            this.urlHandlers = null;
        }
        this.info = null;
        Log.debug("Provisioning agent stopped ...");
        Log.log.close();
        Log.log = null;
    }

    public Dictionary getInformation() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInformation(Dictionary info) {
        boolean refChanged = info.get("provisioning.reference") != null;
        ProvisioningData provisioningData = this.info;
        synchronized (provisioningData) {
            Integer version = (Integer)this.info.get("provisioning.update.count");
            Integer newVersion = new Integer(version + 1);
            this.info.set(info);
            this.incrementUC(newVersion);
        }
        this.modify();
        this.updated(refChanged);
    }

    public void addInformation(Dictionary info) {
        this.addInformation(info, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readStream(InputStream is) throws IOException {
        byte[] byArray = buffer;
        synchronized (buffer) {
            int read;
            baos.reset();
            while ((read = is.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, read);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return baos.toByteArray();
        }
    }

    private Bundle installBundle(String name, InputStream is) {
        Bundle bundle = null;
        try {
            bundle = this.getBundle(name);
            if (bundle == null) {
                if (Log.debug) {
                    Log.debug("Installing management bundle '" + name + "'");
                }
                bundle = bc.installBundle(name, is);
            } else {
                if (Log.debug) {
                    Log.debug("Updating management bundle '" + name + "'");
                }
                bundle.update(is);
            }
        }
        catch (Throwable t) {
            this.setHasFailedPrv(true);
            Log.debug("WARNING: Failed to install management bundle '" + name + "'", t);
        }
        return bundle;
    }

    public void addInformation(ZipInputStream zis) {
        Log.debug("Add Information form ZIS.");
        Hashtable<String, byte[]> entries = new Hashtable<String, byte[]>(2);
        boolean manifestFound = false;
        Hashtable info = new Hashtable(5);
        Dictionary entriesFromHeader = null;
        Hashtable<String, String> extraFileds = null;
        Vector bundlesToStart = new Vector(5);
        String header = null;
        try {
            String name;
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                byte[] extra;
                String type;
                name = ze.getName();
                if (name.endsWith("/")) {
                    zis.closeEntry();
                    continue;
                }
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                String string = type = (extra = ze.getExtra()) == null ? null : new String(extra).toLowerCase();
                if (extra != null && !"META-INF/MANIFEST.MF".equals(name)) {
                    if (extraFileds == null) {
                        extraFileds = new Hashtable<String, String>(3, 3.0f);
                    }
                    ((Dictionary)extraFileds).put(name, type);
                }
                if (!manifestFound) {
                    if ("META-INF/MANIFEST.MF".equals(name)) {
                        manifestFound = true;
                        header = ProvisioningAgent.getHeaderFromManifest(zis);
                        entriesFromHeader = ProvisioningAgent.filterAttributes(TYPE, ProvisioningAgent.parseEntries(header));
                    } else {
                        System.out.println("---put : " + name);
                        entries.put(name, ProvisioningAgent.readStream(zis));
                    }
                } else {
                    this.processEntry(extraFileds, name, null, zis, info, entriesFromHeader, bundlesToStart);
                }
                zis.closeEntry();
            }
            Enumeration names = entries.keys();
            while (names.hasMoreElements()) {
                name = (String)names.nextElement();
                this.processEntry(extraFileds, name, (byte[])entries.get(name), null, info, entriesFromHeader, bundlesToStart);
            }
        }
        catch (Throwable e) {
            this.info.setError(4, e.toString());
            Log.debug("Error reading provisioning package", e);
            this.setHasFailedPrv(true);
        }
        if (this.closeZip) {
            try {
                zis.close();
            }
            catch (Exception exception) {}
        }
        this.addInformation(info, bundlesToStart);
    }

    private void processEntry(Dictionary extraFileds, String name, byte[] content, InputStream is, Dictionary info, Dictionary entriesFromHeader, Vector bundlesToStart) throws IOException {
        String type;
        String string = type = entriesFromHeader == null ? null : (String)entriesFromHeader.get(name);
        if (type == null && extraFileds != null) {
            type = (String)extraFileds.get(name);
        }
        if (type == null) {
            type = ProvisioningAgent.getMIMEfromExtension(name);
        }
        if (Log.debug) {
            Log.debug("Processing entry '" + name + "' of type " + type);
        }
        if ("application/vnd.osgi.bundle".equals(type) || "application/x-osgi-bundle".equals(type)) {
            this.installBundle(name, content == null ? new ISWrapper(is) : new ISWrapper(new ByteArrayInputStream(content)));
        } else if ("application/octet-stream".equals(type)) {
            info.put(name, content == null ? ProvisioningAgent.readStream(is) : content);
        } else if ("text/plain;charset=utf-8".equals(type)) {
            String value = this.getUTF8String(content == null ? ProvisioningAgent.readStream(is) : content);
            info.put(name, value);
            if ("provisioning.start.bundle".equals(name)) {
                try {
                    this.grantAllPermissions(value);
                }
                catch (Throwable e) {
                    Log.debug("Failed to grant all permissions", e);
                }
                bundlesToStart.addElement(value);
            }
        } else if ("text/x-osgi-bundle-url".equals(type)) {
            String value = this.getUTF8String(content == null ? ProvisioningAgent.readStream(is) : content);
            this.installBundle(name, new URL(value).openStream());
        } else {
            this.info.setError(4, "Unknown MIME type (" + type + ") for entry '" + name + "'");
            this.setHasFailedPrv(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent se) {
        ProvisioningAgent provisioningAgent;
        Object service;
        block44: {
            service = bc.getService(se.getServiceReference());
            if (service instanceof ProvisioningStorage) {
                if (se.getType() == 1) {
                    provisioningAgent = this;
                    synchronized (provisioningAgent) {
                        if (this.storage != null) {
                            return;
                        }
                        this.storage = (ProvisioningStorage)service;
                    }
                    try {
                        Object oldUC = this.info.get("provisioning.update.count");
                        int iOldUC = 0;
                        if (oldUC != null && oldUC instanceof Integer) {
                            iOldUC = (Integer)oldUC;
                        }
                        Dictionary toAdd = this.storage.getStoredInfo();
                        Object newUC = toAdd.get("provisioning.update.count");
                        int iNewUC = 0;
                        if (newUC != null && newUC instanceof Integer) {
                            iNewUC = (Integer)newUC;
                        }
                        boolean refChanged = toAdd.get("provisioning.reference") != null && (iNewUC == 0 || this.reprovision);
                        boolean increment = iNewUC > iOldUC;
                        ProvisioningData provisioningData = this.info;
                        synchronized (provisioningData) {
                            this.info.set(toAdd);
                            if (increment) {
                                this.incrementUC(new Integer(iNewUC));
                                this.modify();
                            }
                        }
                        this.updated(refChanged);
                    }
                    catch (Exception e) {
                        Log.debug(e);
                    }
                    Log.debug("Storage is available.");
                } else if (se.getType() == 4 && this.storage == bc.getService(se.getServiceReference())) {
                    Log.debug("Storage is removed!");
                    try {
                        this.storage.store(this.info);
                    }
                    catch (Exception e) {
                        Log.debug("Can't store provisioning info!", e);
                    }
                    this.storage = null;
                }
            }
            if (service instanceof ProvisioningInfoProvider) {
                if (se.getType() == 1) {
                    ProvisioningInfoProvider provider = (ProvisioningInfoProvider)service;
                    Log.debug("Loads from " + provider + " provider.");
                    try {
                        String prvref;
                        if (this.info.providers.contains(provider)) break block44;
                        Dictionary toAdd = provider.init(this);
                        boolean refChanged = false;
                        if (toAdd != null && (prvref = (String)toAdd.get("provisioning.reference")) != null && prvref.trim().length() != 0) {
                            refChanged = true;
                        }
                        boolean added = true;
                        ProvisioningData provisioningData = this.info;
                        synchronized (provisioningData) {
                            if (!this.info.providers.contains(provider)) {
                                this.info.providers.addElement(provider);
                                this.info.add(toAdd);
                                if (refChanged) {
                                    this.reprovision = true;
                                }
                                Integer version = (Integer)this.info.get("provisioning.update.count");
                                Integer newVersion = new Integer(version + 1);
                                this.incrementUC(newVersion);
                            } else {
                                added = false;
                            }
                        }
                        if (added) {
                            this.modify();
                            this.updated(refChanged);
                        }
                    }
                    catch (Exception e) {
                        Log.debug(e);
                    }
                } else if (se.getType() == 4) {
                    this.info.providers.removeElement(service);
                }
            }
        }
        if (service instanceof Timer) {
            switch (se.getType()) {
                case 1: {
                    provisioningAgent = this;
                    synchronized (provisioningAgent) {
                        if (this.timer == null) {
                            this.timer = (Timer)service;
                            if (this.getHasFailedPrv() && !this.reAfterPrvFailureDisabled) {
                                try {
                                    this.timer.notifyAfterMillis((TimerListener)this, this.nextPrvAfter(), 1);
                                }
                                catch (Exception e) {
                                    Log.debug(e);
                                }
                            }
                        }
                        break;
                    }
                }
                case 4: {
                    this.timer = null;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void timer(int event) {
        Log.debug("Timer event " + event);
        try {
            switch (event) {
                case 1: {
                    Log.debug("Remake failed provisioning.");
                    if (!this.getHasFailedPrv()) return;
                    this.processPrvAssignment();
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            Log.debug(e);
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            this.wfs = false;
            this.processStart();
        }
    }

    public boolean getHttpAllowed() {
        return this.httpAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStart() {
        ProvisioningAgent provisioningAgent = this;
        synchronized (provisioningAgent) {
            try {
                Log.debug("Reprovision = " + this.reprovision + ", update counter = " + this.info.get("provisioning.update.count") + ", provisioning reference = " + this.info.get("provisioning.reference"));
                if ((this.reprovision || (Integer)this.info.get("provisioning.update.count") == 0) && this.info.get("provisioning.reference") != null && !this.startProcessed && this.processPrvAssignment()) {
                    this.startProcessed = true;
                }
            }
            catch (Throwable t) {
                Log.debug(t);
            }
        }
        provisioningAgent = this;
        synchronized (provisioningAgent) {
            if (!this.active || this.wfs || this.registered) {
                return;
            }
            this.registered = true;
        }
        Log.debug("Registering ProvisioningService.");
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.osgi.service.provisioning.ProvisioningService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.sreg = bc.registerService(clazz.getName(), (Object)this, this.getRegProps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updated(boolean refUpdated) {
        Log.debug("ProvisioingDictionary updated. Reference updated = " + refUpdated);
        this.store();
        ProvisioningAgent provisioningAgent = this;
        synchronized (provisioningAgent) {
            if (refUpdated && !this.processPrvAssignment()) {
                this.reprovision = true;
            }
        }
    }

    private void store() {
        if (this.storage != null) {
            try {
                ProvisioningData info = this.info;
                if (info != null) {
                    this.storage.store(info);
                }
            }
            catch (Exception e) {
                Log.debug(e);
            }
        } else {
            Log.debug("Warning: No storage available.");
        }
    }

    private boolean processPrvAssignment() {
        if (this.active && !this.wfs) {
            new Thread(){

                public void run() {
                    try {
                        ProvisioningAgent.this.process();
                    }
                    catch (Exception e) {
                        Log.debug(e);
                    }
                }
            }.start();
            return true;
        }
        return false;
    }

    synchronized void process() {
        block41: {
            if (this.info == null) {
                return;
            }
            this.setHasFailedPrv(false);
            String ref = (String)this.info.get("provisioning.reference");
            Log.debug("Reference = \"" + ref + '\"');
            if (ref != null && (ref = ref.trim()).length() != 0) {
                URLConnection conn;
                block40: {
                    String spid = (String)this.info.get("provisioning.spid");
                    Log.debug("Setup from \"" + ref + "\", SPID = " + spid);
                    if (!this.httpAllowed && ref.startsWith("http://")) {
                        Log.debug("Won't make setup to " + ref + " because http is forbidden!");
                        this.setError(2, "Provisioning reference is a HTTP URL, but non-secure HTTP is forbidden!");
                        this.setHasFailedPrv(true);
                        return;
                    }
                    if (!ref.startsWith("file:") && ref.indexOf("service_platform_id") == -1) {
                        ref = ref.indexOf(63) == -1 ? String.valueOf(ref) + '?' : String.valueOf(ref) + '&';
                        ref = String.valueOf(ref) + "service_platform_id=" + URLEncoder.encode(spid == null ? "" : spid);
                    }
                    Log.debug("Setup url = \"" + ref);
                    conn = null;
                    try {
                        try {
                            URL url = new URL(ref);
                            InputStream is = null;
                            try {
                                conn = url.openConnection();
                                if (conn == null) {
                                    throw new IOException("Can't open connection to " + url + "!");
                                }
                                conn.setRequestProperty("Connection", "close");
                                conn.connect();
                                String error = conn.getHeaderField("error");
                                if (error == null) {
                                    if (conn instanceof HttpURLConnection && ((HttpURLConnection)conn).getResponseCode() != 200) {
                                        String errorMsg = "Warning! ResponseCode = " + ((HttpURLConnection)conn).getResponseCode() + "!";
                                        Log.debug(errorMsg);
                                        this.setError(3, errorMsg);
                                    } else {
                                        is = conn.getInputStream();
                                    }
                                } else {
                                    this.setError(3, error);
                                    Log.debug("Error from Backend: " + error + "! Setup failed!");
                                }
                            }
                            catch (IOException e) {
                                this.setError(3, e.toString());
                                Log.debug(e);
                            }
                            if (is == null) {
                                this.setHasFailedPrv(true);
                                break block40;
                            }
                            try {
                                ZipInputStream zis = new ZipInputStream(is);
                                try {
                                    this.addInformation(zis);
                                    Log.debug("Setup ended.");
                                }
                                catch (Throwable throwable) {
                                    if (!this.closeZip) {
                                        try {
                                            zis.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                    throw throwable;
                                }
                                if (this.closeZip) break block40;
                                try {
                                    zis.close();
                                }
                                catch (Exception exception) {
                                }
                            }
                            catch (Exception e) {
                                this.setError(4, e.toString());
                                this.setHasFailedPrv(true);
                                Log.debug(e);
                            }
                        }
                        catch (IOException iOException) {
                            this.setError(2, "Invalid Provisioning Reference: " + ref);
                            if (conn != null && conn instanceof HttpURLConnection) {
                                try {
                                    ((HttpURLConnection)conn).disconnect();
                                }
                                catch (Exception exception) {}
                            }
                            break block41;
                        }
                    }
                    catch (Throwable throwable) {
                        if (conn != null && conn instanceof HttpURLConnection) {
                            try {
                                ((HttpURLConnection)conn).disconnect();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                }
                if (conn != null && conn instanceof HttpURLConnection) {
                    try {
                        ((HttpURLConnection)conn).disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.getHasFailedPrv()) {
            if (!this.reAfterPrvFailureDisabled) {
                try {
                    if (this.timer != null) {
                        this.timer.notifyAfterMillis((TimerListener)this, this.nextPrvAfter(), 1);
                    }
                }
                catch (Exception e) {
                    Log.debug(e);
                }
            }
        } else {
            this.times = 0;
            this.nextProvisioningAfter = this.a;
        }
    }

    private synchronized long nextPrvAfter() {
        ++this.times;
        if (this.nextProvisioningAfter < (long)this.maxPeriod && this.nextProvisioningAfter * (long)this.times > (long)this.changePeriod) {
            this.nextProvisioningAfter += (long)this.b;
            this.times = 0;
        }
        Log.debug("Next bootstrap after " + this.nextProvisioningAfter + "ms");
        return this.nextProvisioningAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInformation(Dictionary info, Vector bundlesToStart) {
        boolean refChanged = info.get("provisioning.reference") != null;
        ProvisioningData provisioningData = this.info;
        synchronized (provisioningData) {
            this.info.add(info);
            Integer version = (Integer)this.info.get("provisioning.update.count");
            Integer newVersion = new Integer(version + 1);
            this.incrementUC(newVersion);
        }
        Log.debug("Bundles to start: " + bundlesToStart);
        if (bundlesToStart != null) {
            int i = 0;
            while (i < bundlesToStart.size()) {
                Object next = bundlesToStart.elementAt(i);
                try {
                    if (next instanceof Bundle) {
                        ((Bundle)next).start();
                    } else {
                        Bundle b = this.getBundle((String)next);
                        if (b != null) {
                            b.start();
                        } else {
                            Log.debug("Can't find '" + next + "' bundle to start it!");
                        }
                    }
                }
                catch (Exception e) {
                    Log.debug("Exception while starting " + (next instanceof Bundle ? ((Bundle)next).getLocation() : next), e);
                    this.setHasFailedPrv(true);
                    return;
                }
                ++i;
            }
            this.clearError();
        }
        this.modify();
        this.updated(refChanged);
    }

    private boolean isFrameworkStarted() {
        if (!this.wfs) {
            return true;
        }
        Bundle system = bc.getBundle(0L);
        return system != null ? system.getState() == 32 : true;
    }

    private void grantAllPermissions(String location) {
        block14: {
            try {
                ServiceReference sref = bc.getServiceReference("org.osgi.service.permissionadmin.PermissionAdmin");
                if (sref == null) break block14;
                Class<?> clazz = Class.forName("org.osgi.service.permissionadmin.PermissionAdmin");
                Class[] classArray = new Class[2];
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                classArray[1] = Class.forName("[Lorg.osgi.service.permissionadmin.PermissionInfo;");
                Method method = clazz.getMethod("setPermissions", classArray);
                Object[] allPerms = (Object[])Array.newInstance(Class.forName("org.osgi.service.permissionadmin.PermissionInfo"), 1);
                Class<?> clazz3 = Class.forName("org.osgi.service.permissionadmin.PermissionInfo");
                Class[] classArray2 = new Class[3];
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[0] = clazz4;
                Class<?> clazz5 = class$3;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$3 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[1] = clazz5;
                Class<?> clazz6 = class$3;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$3 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[2] = clazz6;
                Constructor<?> constr = clazz3.getConstructor(classArray2);
                allPerms[0] = constr.newInstance("java.security.AllPermission", "", "");
                method.invoke(bc.getService(sref), location, allPerms);
            }
            catch (Exception e) {
                Log.debug(e);
            }
        }
    }

    private ProvisioningStorage getStorage() {
        ServiceReference sref;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.ip.ProvisioningStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (sref = bc.getServiceReference(clazz.getName())) != null ? (ProvisioningStorage)bc.getService(sref) : null;
    }

    private Bundle getBundle(String location) {
        Bundle[] bundles = bc.getBundles();
        int i = bundles.length;
        while (i-- > 0) {
            if (!location.equalsIgnoreCase(bundles[i].getLocation())) continue;
            return bundles[i];
        }
        return null;
    }

    private void incrementUC(Integer uc) {
        if (!this.active) {
            return;
        }
        this.info.putUC(uc);
    }

    private void modify() {
        if (!this.active || this.sreg == null) {
            return;
        }
        try {
            this.sreg.setProperties(this.getRegProps());
        }
        catch (Exception exception) {}
    }

    private Dictionary getRegProps() {
        Hashtable<String, Object> prvsprops = new Hashtable<String, Object>(1, 1.0f);
        prvsprops.put("Vendor", "ProSyst");
        prvsprops.put("provisioning.update.count", this.info.get("provisioning.update.count"));
        return prvsprops;
    }

    private void sort(ServiceReference[] srefs) {
        int i = srefs.length - 1;
        while (i > 0) {
            int j = 0;
            while (j < i) {
                if (this.less(srefs[j + 1], srefs[j])) {
                    ServiceReference temp = srefs[j];
                    srefs[j] = srefs[j + 1];
                    srefs[j + 1] = temp;
                }
                ++j;
            }
            --i;
        }
    }

    private boolean less(ServiceReference sref1, ServiceReference sref2) {
        return this.getRanking(sref1) < this.getRanking(sref2);
    }

    private int getRanking(ServiceReference sref) {
        Integer ranking = (Integer)sref.getProperty("service.ranking");
        return ranking == null ? 0 : ranking;
    }

    private String getUTF8String(byte[] body) {
        try {
            return new String(body, "UTF-8");
        }
        catch (Exception exception) {
            try {
                return new String(body, "UTF8");
            }
            catch (Exception exception2) {
                return new String(body);
            }
        }
    }

    private void setError(int code, String message) {
        ProvisioningData data = this.info;
        if (data == null) {
            return;
        }
        data.setError(code, message);
        Integer version = (Integer)data.get("provisioning.update.count");
        Integer newVersion = new Integer(version + 1);
        this.info.putUC(newVersion);
        this.modify();
    }

    private void clearError() {
        ProvisioningData data = this.info;
        if (data == null) {
            return;
        }
        data.clearError();
    }

    private boolean getHasFailedPrv() {
        return "true".equals(this.info.get(HAS_FAILED_PROVISIONG));
    }

    private void setHasFailedPrv(boolean hasFailedPrv) {
        if (this.getHasFailedPrv() != hasFailedPrv) {
            this.info.putPrivate(HAS_FAILED_PROVISIONG, hasFailedPrv ? "true" : null);
            this.store();
        }
    }

    private static Dictionary parseEntries(String header) {
        Hashtable entries = null;
        Hashtable<String, String> attributes = null;
        if ((header = ProvisioningAgent.removeWhiteSpaces(header)) == null || header.length() == 0) {
            return null;
        }
        int begin = 0;
        int end = 1;
        int length = header.length();
        boolean quoted = false;
        block9: while (end != -1 && begin < length - 1) {
            String path;
            end = ProvisioningAgent.readToken(header, begin, false, false);
            if (end == -1) break;
            block0 : switch (header.charAt(end)) {
                case ';': {
                    if (begin == end) {
                        end = ProvisioningAgent.readToken(header, end + 1, false, true);
                        begin = end + 1;
                        continue block9;
                    }
                    path = header.substring(begin, end);
                    begin = end + 1;
                    while (end != -1 && begin < length - 1) {
                        String value;
                        end = ProvisioningAgent.readToken(header, begin, quoted, false);
                        if (end == -1) break block9;
                        if (header.charAt(end) != '=' || begin == end) {
                            end = ProvisioningAgent.readToken(header, begin, false, true);
                            begin = end + 1;
                            continue block9;
                        }
                        String attribute = header.substring(begin, end);
                        if (header.charAt(begin) == '\"') {
                            quoted = true;
                            begin = end + 2;
                        } else {
                            begin = end + 1;
                        }
                        if (begin >= length - 1) break block9;
                        end = ProvisioningAgent.readToken(header, begin, quoted, false);
                        if (end == -1) {
                            if (quoted) {
                                end = ProvisioningAgent.readToken(header, begin, false, true);
                                begin = end + 1;
                                continue block9;
                            }
                            value = header.substring(begin, length);
                            if (attributes == null) {
                                attributes = new Hashtable<String, String>(2, 3.0f);
                            }
                            ((Dictionary)attributes).put(attribute, value);
                            begin = end + 1;
                            break block0;
                        }
                        switch (header.charAt(end)) {
                            case ',': {
                                value = header.substring(begin, end);
                                if (attributes == null) {
                                    attributes = new Hashtable(2, 3.0f);
                                }
                                ((Dictionary)attributes).put(attribute, value);
                                if (entries == null) {
                                    entries = new Hashtable(3, 3.0f);
                                }
                                ((Dictionary)entries).put(path, attributes);
                                attributes = null;
                                continue block9;
                            }
                            case ';': {
                                value = header.substring(begin, end);
                                if (attributes == null) {
                                    attributes = new Hashtable(2, 3.0f);
                                }
                                ((Dictionary)attributes).put(attribute, value);
                                begin = end + 1;
                                break;
                            }
                            case '\"': {
                                quoted = false;
                                value = header.substring(begin, end - 1);
                                if (attributes == null) {
                                    attributes = new Hashtable(2, 3.0f);
                                }
                                ((Dictionary)attributes).put(attribute, value);
                                begin = end + 1;
                                break;
                            }
                            default: {
                                end = ProvisioningAgent.readToken(header, begin, false, true);
                                begin = end + 1;
                                continue block9;
                            }
                        }
                    }
                    break;
                }
                case ',': {
                    if (begin == end) {
                        begin = end + 2;
                        continue block9;
                    }
                    begin = end + 1;
                    continue block9;
                }
                default: {
                    end = ProvisioningAgent.readToken(header, end + 1, false, true);
                    begin = end + 1;
                    continue block9;
                }
            }
            if (attributes == null) continue;
            if (entries == null) {
                entries = new Hashtable(3, 3.0f);
            }
            ((Dictionary)entries).put(path, attributes);
            attributes = null;
        }
        return entries;
    }

    /*
     * Unable to fully structure code
     */
    private static int readToken(String token, int begin, boolean quoted, boolean skipInvalidPath) {
        c = '\u0000';
        len = token.length();
        if (begin >= len) {
            return -1;
        }
        if (quoted) {
            while ((c = token.charAt(begin)) != '\"') {
                if (++begin != len) continue;
                return -1;
            }
            return begin;
        }
        if (!skipInvalidPath) ** GOTO lbl17
        while ((c = token.charAt(begin)) != ',') {
            if (++begin != len) continue;
            return -1;
        }
        return begin;
lbl-1000:
        // 1 sources

        {
            if (++begin != len) continue;
            return -1;
lbl17:
            // 2 sources

            ** while ((c = token.charAt((int)begin)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '/' || c == '.' || c == ':')
        }
lbl18:
        // 1 sources

        return begin;
    }

    private static Dictionary filterAttributes(String attribute, Dictionary entries) {
        if (entries == null) {
            return null;
        }
        Hashtable<String, String> filtered = null;
        Enumeration paths = entries.keys();
        Dictionary attributes = null;
        String path = null;
        String type = null;
        String mime = null;
        while (paths.hasMoreElements()) {
            path = (String)paths.nextElement();
            attributes = (Dictionary)entries.get(path);
            type = (String)attributes.get(attribute);
            if (type == null || (mime = ProvisioningAgent.typeToMIME(type)) == null) continue;
            if (filtered == null) {
                filtered = new Hashtable<String, String>(3, 3.0f);
            }
            ((Dictionary)filtered).put(path, mime);
        }
        return filtered;
    }

    private static String typeToMIME(String type) {
        if ("text".equals(type)) {
            return "text/plain;charset=utf-8";
        }
        if ("binary".equals(type)) {
            return "application/octet-stream";
        }
        if ("bundle".equals(type)) {
            return "application/vnd.osgi.bundle";
        }
        if ("bundle-url".equals(type)) {
            return "text/x-osgi-bundle-url";
        }
        return null;
    }

    static String getMIMEfromExtension(String filename) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        String extension = filename.substring(index + 1);
        if (extension.equals("jar")) {
            return "application/vnd.osgi.bundle";
        }
        if (extension.equals("txt")) {
            return "text/plain;charset=utf-8";
        }
        if (extension.equals("url")) {
            return "text/x-osgi-bundle-url";
        }
        return "application/octet-stream";
    }

    private static String getHeaderFromManifest(InputStream is) {
        boolean blank = false;
        StringBuffer header = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        boolean loop = true;
        try {
            while ((line = br.readLine()) != null && loop) {
                if (line.length() == 0) {
                    if (!blank) {
                        blank = true;
                        continue;
                    }
                    break;
                }
                blank = false;
                if (!line.startsWith("InitialProvisioning-Entries")) continue;
                header.append(ProvisioningAgent.removeWhiteSpaces(line.substring("InitialProvisioning-Entries".length() + 1)));
                line = br.readLine();
                while (loop = line.length() != 0 && Character.isWhitespace(line.charAt(0))) {
                    header.append(ProvisioningAgent.removeWhiteSpaces(line));
                    line = br.readLine();
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return header.length() == 0 ? null : header.toString();
    }

    private static String removeWhiteSpaces(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char curr = s.charAt(i);
            if (!Character.isWhitespace(curr)) {
                sb.append(curr);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean getBoolean(String property) {
        String prop;
        String string = prop = bc != null ? bc.getProperty(property) : System.getProperty(property);
        return prop != null && prop.equalsIgnoreCase("true");
    }

    public static int getInteger(String property, int defaultValue) {
        String prop;
        String string = prop = bc != null ? bc.getProperty(property) : System.getProperty(property);
        if (prop != null) {
            try {
                return Integer.decode(prop);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private static class ISWrapper
    extends InputStream {
        private InputStream is;

        ISWrapper(InputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] src, int off, int len) throws IOException {
            return this.is.read(src, off, len);
        }

        public void close() {
        }
    }
}

