/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.events;

import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public final class EventLCAUtil {
    private static final String EVENT_SCROLLBAR_SELECTED = "scrollBarSelected";

    public static int readStateMask(Widget widget, String eventName) {
        String altKey = ProtocolUtil.readEventPropertyValueAsString(WidgetUtil.getId(widget), eventName, "altKey");
        String ctrlKey = ProtocolUtil.readEventPropertyValueAsString(WidgetUtil.getId(widget), eventName, "ctrlKey");
        String shiftKey = ProtocolUtil.readEventPropertyValueAsString(WidgetUtil.getId(widget), eventName, "shiftKey");
        return EventLCAUtil.translateModifier(altKey, ctrlKey, shiftKey);
    }

    static int translateModifier(String altKey, String ctrlKey, String shiftKey) {
        int result = 0;
        if ("true".equals(ctrlKey)) {
            result |= 0x40000;
        }
        if ("true".equals(altKey)) {
            result |= 0x10000;
        }
        if ("true".equals(shiftKey)) {
            result |= 0x20000;
        }
        return result;
    }

    public static int translateButton(int value) {
        int result = 0;
        switch (value) {
            case 1: {
                result = 524288;
                break;
            }
            case 2: {
                result = 0x100000;
                break;
            }
            case 3: {
                result = 0x200000;
                break;
            }
            case 4: {
                result = 0x800000;
                break;
            }
            case 5: {
                result = 0x2000000;
            }
        }
        return result;
    }

    public static boolean hasScrollBarsSelectionListener(Scrollable scrollable) {
        ScrollBar verticalBar;
        boolean result = false;
        ScrollBar horizontalBar = scrollable.getHorizontalBar();
        if (horizontalBar != null) {
            boolean bl = result = result || horizontalBar.isListening(13);
        }
        if ((verticalBar = scrollable.getVerticalBar()) != null) {
            result = result || verticalBar.isListening(13);
        }
        return result;
    }

    public static void processScrollBarSelection(Scrollable scrollable) {
        String eventName = EVENT_SCROLLBAR_SELECTED;
        if (WidgetLCAUtil.wasEventSent(scrollable, eventName)) {
            ScrollBar vScroll;
            String horizontal = WidgetLCAUtil.readEventPropertyValue(scrollable, eventName, "horizontal");
            String vertical = WidgetLCAUtil.readEventPropertyValue(scrollable, eventName, "vertical");
            ScrollBar hScroll = scrollable.getHorizontalBar();
            if (hScroll != null && "true".equals(horizontal)) {
                hScroll.notifyListeners(13, new Event());
            }
            if ((vScroll = scrollable.getVerticalBar()) != null && "true".equals(vertical)) {
                vScroll.notifyListeners(13, new Event());
            }
        }
    }

    public static void processRadioSelection(Widget widget, boolean isWidgetSelected) {
        String eventName = "Selection";
        if (WidgetLCAUtil.wasEventSent(widget, eventName)) {
            Event event = new Event();
            if (!isWidgetSelected) {
                event.time = -1;
            }
            event.stateMask = EventLCAUtil.readStateMask(widget, eventName);
            widget.notifyListeners(13, event);
        }
    }

    private EventLCAUtil() {
    }
}

