/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.Part;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.TypeUtil;

public class MultiPartInputStream {
    public static final MultipartConfigElement __DEFAULT_MULTIPART_CONFIG = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
    protected InputStream _in;
    protected MultipartConfigElement _config;
    protected String _contentType;
    protected MultiMap<String> _parts;
    protected File _tmpDir;
    protected File _contextTmpDir;

    public MultiPartInputStream(InputStream in, String contentType, MultipartConfigElement config, File contextTmpDir) {
        this._in = new BufferedInputStream(in);
        this._contentType = contentType;
        this._config = config;
        this._contextTmpDir = contextTmpDir;
        if (this._contextTmpDir == null) {
            this._contextTmpDir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (this._config == null) {
            this._config = new MultipartConfigElement(this._contextTmpDir.getAbsolutePath());
        }
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        this.parse();
        Collection<Object> values = this._parts.values();
        ArrayList<Part> parts = new ArrayList<Part>();
        for (Object o : values) {
            List asList = LazyList.getList(o, false);
            parts.addAll(asList);
        }
        return parts;
    }

    public Part getPart(String name) throws IOException, ServletException {
        this.parse();
        return (Part)this._parts.getValue(name, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse() throws IOException, ServletException {
        String line;
        File f;
        if (this._parts != null) {
            return;
        }
        long total = 0L;
        this._parts = new MultiMap();
        if (this._contentType == null || !this._contentType.startsWith("multipart/form-data")) {
            return;
        }
        this._tmpDir = this._config.getLocation() == null ? this._contextTmpDir : ("".equals(this._config.getLocation()) ? this._contextTmpDir : ((f = new File(this._config.getLocation())).isAbsolute() ? f : new File(this._contextTmpDir, this._config.getLocation())));
        if (!this._tmpDir.exists()) {
            this._tmpDir.mkdirs();
        }
        String boundary = "--" + QuotedStringTokenizer.unquote(this.value(this._contentType.substring(this._contentType.indexOf("boundary="))).trim());
        byte[] byteBoundary = (boundary + "--").getBytes("ISO-8859-1");
        byte[] bytes = TypeUtil.readLine(this._in);
        String string = line = bytes == null ? null : new String(bytes, "UTF-8");
        if (line == null || !line.equals(boundary)) {
            throw new IOException("Missing initial multi part boundary");
        }
        boolean lastPart = false;
        String contentDisposition = null;
        String contentType = null;
        String contentTransferEncoding = null;
        block3: while (!lastPart) {
            MultiMap<String> headers = new MultiMap<String>();
            while ((bytes = TypeUtil.readLine(this._in)) != null) {
                if (bytes.length != 0) {
                    if (this._config.getMaxRequestSize() > 0L && (total += (long)bytes.length) > this._config.getMaxRequestSize()) {
                        throw new ServletException("Request exceeds maxRequestSize (" + this._config.getMaxRequestSize() + ")");
                    }
                    line = new String(bytes, "UTF-8");
                    int c = line.indexOf(58, 0);
                    if (c <= 0) continue;
                    String key = line.substring(0, c).trim().toLowerCase();
                    String value = line.substring(c + 1, line.length()).trim();
                    headers.put(key, value);
                    if (key.equalsIgnoreCase("content-disposition")) {
                        contentDisposition = value;
                    }
                    if (key.equalsIgnoreCase("content-type")) {
                        contentType = value;
                    }
                    if (!key.equals("content-transfer-encoding")) continue;
                    contentTransferEncoding = value;
                    continue;
                }
                boolean form_data = false;
                if (contentDisposition == null) {
                    throw new IOException("Missing content-disposition");
                }
                QuotedStringTokenizer tok = new QuotedStringTokenizer(contentDisposition, ";");
                String name = null;
                String filename = null;
                while (tok.hasMoreTokens()) {
                    String t = tok.nextToken().trim();
                    String tl = t.toLowerCase();
                    if (t.startsWith("form-data")) {
                        form_data = true;
                        continue;
                    }
                    if (tl.startsWith("name=")) {
                        name = this.value(t);
                        continue;
                    }
                    if (!tl.startsWith("filename=")) continue;
                    filename = this.value(t);
                }
                if (!form_data || name == null) continue block3;
                if ("base64".equalsIgnoreCase(contentTransferEncoding)) {
                    this._in = new Base64InputStream(this._in);
                } else if ("quoted-printable".equalsIgnoreCase(contentTransferEncoding)) {
                    this._in = new FilterInputStream(this._in){

                        @Override
                        public int read() throws IOException {
                            int c = this.in.read();
                            if (c >= 0 && c == 61) {
                                int hi = this.in.read();
                                int lo = this.in.read();
                                if (hi < 0 || lo < 0) {
                                    throw new IOException("Unexpected end to quoted-printable byte");
                                }
                                char[] chars = new char[]{(char)hi, (char)lo};
                                c = Integer.parseInt(new String(chars), 16);
                            }
                            return c;
                        }
                    };
                }
                MultiPart part = new MultiPart(name, filename);
                part.setHeaders(headers);
                part.setContentType(contentType);
                this._parts.add(name, part);
                part.open();
                try {
                    int state = -2;
                    boolean cr = false;
                    boolean lf = false;
                    while (true) {
                        int c;
                        int b = 0;
                        while ((c = state != -2 ? state : this._in.read()) != -1) {
                            if (this._config.getMaxRequestSize() > 0L && ++total > this._config.getMaxRequestSize()) {
                                throw new ServletException("Request exceeds maxRequestSize (" + this._config.getMaxRequestSize() + ")");
                            }
                            state = -2;
                            if (c == 13 || c == 10) {
                                if (c != 13) break;
                                state = this._in.read();
                                break;
                            }
                            if (b >= 0 && b < byteBoundary.length && c == byteBoundary[b]) {
                                ++b;
                                continue;
                            }
                            if (cr) {
                                part.write(13);
                            }
                            if (lf) {
                                part.write(10);
                            }
                            lf = false;
                            cr = false;
                            if (b > 0) {
                                part.write(byteBoundary, 0, b);
                            }
                            b = -1;
                            part.write(c);
                        }
                        if (b > 0 && b < byteBoundary.length - 2 || b == byteBoundary.length - 1) {
                            if (cr) {
                                part.write(13);
                            }
                            if (lf) {
                                part.write(10);
                            }
                            lf = false;
                            cr = false;
                            part.write(byteBoundary, 0, b);
                            b = -1;
                        }
                        if (b > 0 || c == -1) {
                            if (b == byteBoundary.length) {
                                lastPart = true;
                            }
                            if (state != 10) continue block3;
                            state = -2;
                            continue block3;
                        }
                        if (cr) {
                            part.write(13);
                        }
                        if (lf) {
                            part.write(10);
                        }
                        cr = c == 13;
                        boolean bl = lf = c == 10 || state == 10;
                        if (state != 10) continue;
                        state = -2;
                    }
                }
                finally {
                    part.close();
                    continue block3;
                }
            }
            break block3;
        }
    }

    private String value(String nameEqualsValue) {
        String value = nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
        int i = value.indexOf(59);
        if (i > 0) {
            value = value.substring(0, i);
        }
        if (value.startsWith("\"")) {
            value = value.substring(1, value.indexOf(34, 1));
        } else {
            i = value.indexOf(32);
            if (i > 0) {
                value = value.substring(0, i);
            }
        }
        return value;
    }

    private static class Base64InputStream
    extends InputStream {
        BufferedReader _in;
        String _line;
        byte[] _buffer;
        int _pos;

        public Base64InputStream(InputStream in) {
            this._in = new BufferedReader(new InputStreamReader(in));
        }

        @Override
        public int read() throws IOException {
            if (this._buffer == null || this._pos >= this._buffer.length) {
                this._line = this._in.readLine();
                if (this._line == null) {
                    return -1;
                }
                this._buffer = this._line.startsWith("--") ? (this._line + "\r\n").getBytes() : (this._line.length() == 0 ? "\r\n".getBytes() : B64Code.decode(this._line));
                this._pos = 0;
            }
            return this._buffer[this._pos++];
        }
    }

    public class MultiPart
    implements Part {
        protected String _name;
        protected String _filename;
        protected File _file;
        protected OutputStream _out;
        protected ByteArrayOutputStream2 _bout;
        protected String _contentType;
        protected MultiMap<String> _headers;
        protected long _size = 0L;

        public MultiPart(String name, String filename) throws IOException {
            this._name = name;
            this._filename = filename;
        }

        protected void setContentType(String contentType) {
            this._contentType = contentType;
        }

        protected void open() throws FileNotFoundException, IOException {
            if (this._filename != null && this._filename.trim().length() > 0) {
                this.createFile();
            } else {
                this._bout = new ByteArrayOutputStream2();
                this._out = this._bout;
            }
        }

        protected void close() throws IOException {
            this._out.close();
        }

        protected void write(int b) throws IOException, ServletException {
            if (MultiPartInputStream.this._config.getMaxFileSize() > 0L && this._size + 1L > MultiPartInputStream.this._config.getMaxFileSize()) {
                throw new ServletException("Multipart Mime part " + this._name + " exceeds max filesize");
            }
            if (MultiPartInputStream.this._config.getFileSizeThreshold() > 0 && this._size + 1L > (long)MultiPartInputStream.this._config.getFileSizeThreshold() && this._file == null) {
                this.createFile();
            }
            this._out.write(b);
            ++this._size;
        }

        protected void write(byte[] bytes, int offset, int length) throws IOException, ServletException {
            if (MultiPartInputStream.this._config.getMaxFileSize() > 0L && this._size + (long)length > MultiPartInputStream.this._config.getMaxFileSize()) {
                throw new ServletException("Multipart Mime part " + this._name + " exceeds max filesize");
            }
            if (MultiPartInputStream.this._config.getFileSizeThreshold() > 0 && this._size + (long)length > (long)MultiPartInputStream.this._config.getFileSizeThreshold() && this._file == null) {
                this.createFile();
            }
            this._out.write(bytes, offset, length);
            this._size += (long)length;
        }

        protected void createFile() throws IOException {
            this._file = File.createTempFile("MultiPart", "", MultiPartInputStream.this._tmpDir);
            FileOutputStream fos = new FileOutputStream(this._file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            if (this._size > 0L && this._out != null) {
                this._out.flush();
                this._bout.writeTo(bos);
                this._out.close();
                this._bout = null;
            }
            this._out = bos;
        }

        protected void setHeaders(MultiMap<String> headers) {
            this._headers = headers;
        }

        public String getContentType() {
            return this._contentType;
        }

        public String getHeader(String name) {
            if (name == null) {
                return null;
            }
            return (String)this._headers.getValue(name.toLowerCase(), 0);
        }

        public Collection<String> getHeaderNames() {
            return this._headers.keySet();
        }

        public Collection<String> getHeaders(String name) {
            return this._headers.getValues(name);
        }

        public InputStream getInputStream() throws IOException {
            if (this._file != null) {
                return new BufferedInputStream(new FileInputStream(this._file));
            }
            return new ByteArrayInputStream(this._bout.getBuf(), 0, this._bout.size());
        }

        public byte[] getBytes() {
            if (this._bout != null) {
                return this._bout.toByteArray();
            }
            return null;
        }

        public String getName() {
            return this._name;
        }

        public long getSize() {
            return this._size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(String fileName) throws IOException {
            if (this._file == null) {
                this._file = new File(MultiPartInputStream.this._tmpDir, fileName);
                FilterOutputStream bos = null;
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(this._file));
                    this._bout.writeTo(bos);
                    ((BufferedOutputStream)bos).flush();
                }
                finally {
                    if (bos != null) {
                        bos.close();
                    }
                    this._bout = null;
                }
            } else {
                File f = new File(MultiPartInputStream.this._tmpDir, fileName);
                if (this._file.renameTo(f)) {
                    this._file = f;
                }
            }
        }

        public void delete() throws IOException {
            if (this._file != null) {
                this._file.delete();
            }
        }

        public File getFile() {
            return this._file;
        }

        public String getContentDispositionFilename() {
            return this._filename;
        }
    }
}

