/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.coordinator;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.eclipse.equinox.coordinator.CoordinationImpl;
import org.eclipse.equinox.coordinator.CoordinationReferent;
import org.eclipse.equinox.coordinator.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinationWeakReference
extends WeakReference<CoordinationReferent> {
    private static final ReferenceQueue<CoordinationReferent> referenceQueue = new ReferenceQueue();
    private final CoordinationImpl coordination;

    public static void processOrphanedCoordinations() {
        CoordinationWeakReference r;
        while ((r = (CoordinationWeakReference)referenceQueue.poll()) != null) {
            CoordinationImpl c = r.getCoordination();
            try {
                try {
                    c.fail(Coordination.ORPHANED);
                }
                catch (Throwable t) {
                    c.getLogService().log(1, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), t);
                    try {
                        c.end();
                    }
                    catch (CoordinationException e) {
                        if (Coordination.ORPHANED.equals(e.getCause())) continue;
                        c.getLogService().log(1, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), (Throwable)e);
                    }
                    catch (Throwable t2) {
                        c.getLogService().log(1, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), t2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    c.end();
                }
                catch (CoordinationException e) {
                    if (!Coordination.ORPHANED.equals(e.getCause())) {
                        c.getLogService().log(1, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    c.getLogService().log(1, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), t);
                }
                throw throwable;
            }
            try {
                c.end();
            }
            catch (CoordinationException e) {
                if (Coordination.ORPHANED.equals(e.getCause())) continue;
                c.getLogService().log(1, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), (Throwable)e);
            }
            catch (Throwable t) {
                c.getLogService().log(1, NLS.bind((String)Messages.OrphanedCoordinationError, (Object)c.getName(), (Object)c.getId()), t);
            }
        }
    }

    public CoordinationWeakReference(CoordinationReferent referent, CoordinationImpl coordination) {
        super(referent, referenceQueue);
        if (coordination == null) {
            throw new NullPointerException();
        }
        this.coordination = coordination;
    }

    public CoordinationImpl getCoordination() {
        return this.coordination;
    }
}

