/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.util.Locale;

public final class LifeCycleAdapterUtil {
    private LifeCycleAdapterUtil() {
    }

    public static String[] getKitPackageVariants(Class clazz) {
        String packageName = null;
        Package packageObject = clazz.getPackage();
        if (packageObject != null) {
            packageName = packageObject.getName();
        }
        String className = LifeCycleAdapterUtil.getSimpleClassName(clazz);
        return LifeCycleAdapterUtil.getKitPackageVariants(packageName, className);
    }

    static String[] getKitPackageVariants(String packageName, String className) {
        String[] result;
        if (packageName == null || "".equals(packageName)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("internal.");
            buffer.append(className.toLowerCase(Locale.ENGLISH));
            buffer.append("kit");
            result = new String[]{buffer.toString()};
        } else {
            String[] segments = packageName.split("\\.");
            result = new String[segments.length + 1];
            int i = 0;
            while (i < result.length) {
                StringBuilder buffer = new StringBuilder();
                int j = 0;
                while (j < segments.length) {
                    if (j == i) {
                        buffer.append("internal.");
                    }
                    buffer.append(segments[j]);
                    if (j < segments.length - 1) {
                        buffer.append('.');
                    }
                    ++j;
                }
                if (i == segments.length) {
                    buffer.append(".internal");
                }
                buffer.append('.');
                buffer.append(className.toLowerCase(Locale.ENGLISH));
                buffer.append("kit");
                result[i] = buffer.toString();
                ++i;
            }
        }
        return result;
    }

    public static String getSimpleClassName(Class clazz) {
        String className = clazz.getName();
        int index = className.lastIndexOf(46);
        return className.substring(index + 1);
    }
}

