/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.SingletonManager;
import org.eclipse.rap.rwt.internal.application.ApplicationContext;
import org.eclipse.rap.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.service.ISessionStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionStoreBuilder {
    private final ApplicationContext applicationContext;
    private final HttpServletRequest request;
    private final HttpSession session;
    private final SessionStoreImpl sessionStore;

    public SessionStoreBuilder(ApplicationContext applicationContext, HttpServletRequest request) {
        this.applicationContext = applicationContext;
        this.request = request;
        this.session = request.getSession(true);
        this.sessionStore = new SessionStoreImpl(this.session);
    }

    public ISessionStore buildSessionStore() {
        SessionStoreImpl.attachInstanceToSession(this.session, this.sessionStore);
        ApplicationContextUtil.set(this.sessionStore, this.applicationContext);
        SingletonManager.install(this.sessionStore);
        this.setCurrentTheme();
        this.selectClient();
        return this.sessionStore;
    }

    private void setCurrentTheme() {
        Map<String, String> properties = this.getEntryPointProperties();
        String themeId = properties.get("org.eclipse.rap.rwt.webclient.themeId");
        if (themeId != null && themeId.length() > 0) {
            this.verifyThemeId(themeId);
            ThemeUtil.setCurrentThemeId(this.sessionStore, themeId);
        } else {
            ThemeUtil.setCurrentThemeId(this.sessionStore, "org.eclipse.rap.rwt.theme.Default");
        }
    }

    private void selectClient() {
        this.applicationContext.getClientSelector().selectClient(this.request, this.sessionStore);
    }

    private void verifyThemeId(String themeId) {
        if (!this.applicationContext.getThemeManager().hasTheme(themeId)) {
            throw new IllegalArgumentException("Illegal theme id: " + themeId);
        }
    }

    private Map<String, String> getEntryPointProperties() {
        String servletPath;
        Map<String, String> result = Collections.emptyMap();
        EntryPointManager entryPointManager = this.applicationContext.getEntryPointManager();
        EntryPointRegistration registration = entryPointManager.getRegistrationByPath(servletPath = this.request.getServletPath());
        if (registration != null) {
            result = registration.getProperties();
        }
        return result;
    }
}

