/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.widgets.ITextAdapter;
import org.eclipse.swt.internal.widgets.textkit.TextThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Text
extends Scrollable {
    private static final double LINE_HEIGHT_FACTOR = 1.2;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";
    private ITextAdapter textAdapter;
    private String text = "";
    private String message = "";
    private int textLimit = Integer.MAX_VALUE;
    private final Point selection = new Point(0, 0);
    private char echoChar = '\u0000';

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
        if ((style & 0x400000) != 0) {
            this.echoChar = (char)63;
        }
        if ((style & 0x80) != 0) {
            if ((style & 0x100) != 0) {
                this.style |= 0x100;
            }
            if ((style & 0x200) != 0) {
                this.style |= 0x200;
            }
        }
    }

    @Override
    void initState() {
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0) {
            this.state |= 0x100;
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (ITextAdapter.class.equals(adapter)) {
            if (this.textAdapter == null) {
                this.textAdapter = new ITextAdapter(){

                    public void setText(String text, Point selection) {
                        Text.this.setText(text, selection);
                    }
                };
            }
            result = this.textAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public void setText(String text) {
        String verifiedText;
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        if ((verifiedText = this.verifyText(text, 0, this.text.length())) != null) {
            this.text = verifiedText.length() > this.textLimit ? verifiedText.substring(0, this.textLimit) : verifiedText;
            this.selection.x = 0;
            this.selection.y = 0;
            this.notifyListeners(24, new Event());
        }
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setTextChars(char[] text) {
        this.checkWidget();
        if (text == null) {
            this.error(4);
        }
        this.setText(new String(text));
    }

    public char[] getTextChars() {
        this.checkWidget();
        int length = this.text.length();
        char[] chars = new char[length];
        if (length > 0) {
            this.text.getChars(0, length, chars, 0);
        }
        return chars;
    }

    public String getText(int start, int end) {
        String result;
        this.checkWidget();
        if (start > end || end < 0) {
            result = "";
        } else {
            int safeEnd = Math.min(end, this.text.length() - 1);
            if (start > safeEnd) {
                result = "";
            } else {
                int safeStart = Math.max(0, start);
                result = this.text.substring(safeStart, safeEnd + 1);
            }
        }
        return result;
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.setText(String.valueOf(this.text) + string);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        int fontSize = FontUtil.getData(this.getFont()).getHeight();
        return (int)Math.floor((double)fontSize * 1.2);
    }

    public void setMessage(String message) {
        this.checkWidget();
        if (message == null) {
            this.error(4);
        }
        this.message = message;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            this.echoChar = echo;
        }
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoChar;
    }

    public void setTextLimit(int textLimit) {
        this.checkWidget();
        if (textLimit == 0) {
            this.error(7);
        }
        this.textLimit = textLimit;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getCharCount() {
        this.checkWidget();
        return this.text.length();
    }

    public void setSelection(int start) {
        this.checkWidget();
        this.setSelection(start, start);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        int validatedStart = this.selection.x;
        int validatedEnd = this.selection.y;
        if (start >= 0 && end >= start) {
            validatedStart = Math.min(start, this.text.length());
            validatedEnd = Math.min(end, this.text.length());
        } else if (end >= 0 && start > end) {
            validatedStart = Math.min(end, this.text.length());
            validatedEnd = Math.min(start, this.text.length());
        }
        this.selection.x = validatedStart;
        this.selection.y = validatedEnd;
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.y - this.selection.x;
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.text.substring(this.selection.x, this.selection.y);
    }

    public void clearSelection() {
        this.checkWidget();
        this.selection.x = this.selection.y;
    }

    public void selectAll() {
        this.checkWidget();
        this.selection.x = 0;
        this.selection.y = this.text.length();
    }

    public int getCaretPosition() {
        this.checkWidget();
        return this.selection.x;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
    }

    public boolean getEditable() {
        this.checkWidget();
        return (this.style & 8) == 0;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(5);
        }
        String oldText = this.getText();
        Point sel = this.getSelection();
        String replace = oldText.substring(0, sel.x);
        replace = String.valueOf(replace) + string;
        replace = String.valueOf(replace) + oldText.substring(sel.y);
        this.setText(replace);
        this.setSelection(sel.x + string.length());
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int height = 0;
        int width = 0;
        if (wHint == -1 || hHint == -1) {
            Point extent;
            boolean wrap = (this.style & 0x42) != 0;
            int wrapWidth = 0;
            if (wrap && wHint != -1) {
                wrapWidth = wHint;
            }
            if ((this.getStyle() & 4) != 0) {
                extent = Graphics.stringExtent(this.getFont(), this.text);
                Point messageExtent = Graphics.stringExtent(this.getFont(), this.message);
                extent.x = Math.max(extent.x, messageExtent.x);
                extent.y = Math.max(extent.y, messageExtent.y);
            } else {
                extent = Graphics.textExtent(this.getFont(), this.text, wrapWidth);
            }
            if (extent.x != 0) {
                width = extent.x;
            }
            if (extent.y != 0) {
                height = extent.y;
            }
            Point searchIconSize = this.getSearchIconOuterSize();
            Point cancelIconSize = this.getCancelIconOuterSize();
            width += searchIconSize.x + cancelIconSize.x;
            height = Math.max(height, searchIconSize.y);
            height = Math.max(height, cancelIconSize.y);
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, ++width, height += 2);
        return new Point(trim.width, trim.height);
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle result = super.computeTrim(x, y, width, height);
        if ((this.style & 2) != 0 && (this.style & 0x100) != 0) {
            ++result.width;
        }
        return result;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(24, listener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(25, listener);
    }

    @Override
    boolean isTabGroup() {
        return true;
    }

    private String verifyText(String text, int start, int end) {
        Event event = new Event();
        event.text = text;
        event.start = start;
        event.end = end;
        this.notifyListeners(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        String result = event.text;
        return result;
    }

    private void setText(String text, Point selection) {
        String verifiedText = this.verifyText(text, 0, this.text.length());
        if (verifiedText != null) {
            this.text = verifiedText;
            if (selection != null) {
                this.setSelection(selection.x, selection.y);
            }
            this.notifyListeners(24, new Event());
        }
    }

    private static int checkStyle(int style) {
        int result = style;
        if ((result & 0x80) != 0) {
            result |= 0x804;
            result &= 0xFFBFFFFF;
        }
        if ((result & 4) != 0 && (result & 2) != 0) {
            result &= 0xFFFFFFFD;
        }
        if (((result = Text.checkBits(result, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            result &= 0xFFFFFCBF;
        }
        if ((result & 0x40) != 0) {
            result |= 2;
            result &= 0xFFFFFEFF;
        }
        if ((result & 2) != 0) {
            result &= 0xFFBFFFFF;
        }
        if ((result & 6) != 0) {
            return result;
        }
        if ((style & 0x300) != 0) {
            return result | 2;
        }
        return result | 4;
    }

    private Point getSearchIconOuterSize() {
        Point result = new Point(0, 0);
        if ((this.style & 0x80) != 0 && (this.style & 0x200) != 0) {
            result = this.getThemeAdapter().getSearchIconImageSize(this);
            result.x += this.getThemeAdapter().getSearchIconSpacing(this);
        }
        return result;
    }

    private Point getCancelIconOuterSize() {
        Point result = new Point(0, 0);
        if ((this.style & 0x80) != 0 && (this.style & 0x100) != 0) {
            result = this.getThemeAdapter().getCancelIconImageSize(this);
            result.x += this.getThemeAdapter().getCancelIconSpacing(this);
        }
        return result;
    }

    private TextThemeAdapter getThemeAdapter() {
        return (TextThemeAdapter)this.getAdapter(IThemeAdapter.class);
    }
}

