/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.device;

import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Calendar;
import org.eclipse.equinox.device.LogTrackerMsg;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class LogTracker
extends ServiceTracker
implements LogService {
    protected static final String clazz = "org.osgi.service.log.LogService";
    protected PrintStream out;
    private static Calendar calendar;
    private static DateFormat dateFormat;
    private String timestamp;

    public LogTracker(BundleContext context, PrintStream out) {
        super(context, clazz, null);
        this.out = out;
        calendar = Calendar.getInstance();
        dateFormat = DateFormat.getDateTimeInstance();
        this.open();
    }

    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    public void log(int level, String message, Throwable exception) {
        this.log(null, level, message, exception);
    }

    public void log(ServiceReference reference, int level, String message) {
        this.log(reference, level, message, null);
    }

    public synchronized void log(ServiceReference reference, int level, String message, Throwable exception) {
        ServiceReference[] references = this.getServiceReferences();
        if (references != null) {
            int size = references.length;
            int i = 0;
            while (i < size) {
                LogService service = (LogService)this.getService(references[i]);
                if (service != null) {
                    try {
                        service.log(reference, level, message, exception);
                    }
                    catch (Exception exception2) {}
                }
                ++i;
            }
            return;
        }
        this.noLogService(level, message, exception, reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void noLogService(int level, String message, Throwable throwable, ServiceReference reference) {
        if (this.out != null) {
            PrintStream printStream = this.out;
            synchronized (printStream) {
                this.timestamp = dateFormat.format(calendar.getTime());
                this.out.print(String.valueOf(this.timestamp) + " ");
                switch (level) {
                    case 4: {
                        this.out.print("Debug: ");
                        break;
                    }
                    case 3: {
                        this.out.print(LogTrackerMsg.Info);
                        break;
                    }
                    case 2: {
                        this.out.print(LogTrackerMsg.Warning);
                        break;
                    }
                    case 1: {
                        this.out.print(LogTrackerMsg.Error);
                        break;
                    }
                    default: {
                        this.out.print("[");
                        this.out.print(LogTrackerMsg.Unknown_Log_level);
                        this.out.print("]: ");
                    }
                }
                this.out.println(message);
                if (reference != null) {
                    this.out.println(reference);
                }
                if (throwable != null) {
                    throwable.printStackTrace(this.out);
                }
            }
        }
    }
}

