/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menukit;

import java.util.HashMap;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

final class MenuLCAUtil {
    private static final String TYPE = "rwt.widgets.Menu";
    private static final String[] ALLOWED_STYLES = new String[]{"BAR", "DROP_DOWN", "POP_UP", "NO_RADIO_GROUP"};
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_SHOW_LISTENER = "Show";
    private static final String PROP_HIDE_LISTENER = "Hide";
    private static final String METHOD_UNHIDE_ITEMS = "unhideItems";

    MenuLCAUtil() {
    }

    static void preserveValues(Menu menu) {
        WidgetLCAUtil.preserveCustomVariant(menu);
        WidgetLCAUtil.preserveProperty((Widget)menu, PROP_ENABLED, menu.getEnabled());
        WidgetLCAUtil.preserveListener(menu, PROP_SHOW_LISTENER, MenuLCAUtil.hasShowListener(menu));
        WidgetLCAUtil.preserveListener(menu, PROP_HIDE_LISTENER, menu.isListening(23));
        WidgetLCAUtil.preserveHelpListener(menu);
    }

    static void renderInitialization(Menu menu) {
        IClientObject clientObject = ClientObjectFactory.getClientObject(menu);
        clientObject.create(TYPE);
        clientObject.set("style", WidgetLCAUtil.getStyles(menu, ALLOWED_STYLES));
    }

    static void renderChanges(Menu menu) {
        WidgetLCAUtil.renderCustomVariant(menu);
        WidgetLCAUtil.renderProperty((Widget)menu, PROP_ENABLED, menu.getEnabled(), true);
        WidgetLCAUtil.renderListener(menu, PROP_SHOW_LISTENER, MenuLCAUtil.hasShowListener(menu), false);
        WidgetLCAUtil.renderListener(menu, PROP_HIDE_LISTENER, menu.isListening(23), false);
        WidgetLCAUtil.renderListenHelp(menu);
    }

    public static void readMenuEvent(Menu menu) {
        if (WidgetLCAUtil.wasEventSent(menu, PROP_SHOW_LISTENER)) {
            menu.notifyListeners(22, new Event());
        }
        if (WidgetLCAUtil.wasEventSent(menu, PROP_HIDE_LISTENER)) {
            menu.notifyListeners(23, new Event());
        }
    }

    static void renderUnhideItems(Menu menu) {
        if (WidgetLCAUtil.wasEventSent(menu, PROP_SHOW_LISTENER)) {
            Boolean reveal = menu.getItemCount() > 0;
            IClientObject clientObject = ClientObjectFactory.getClientObject(menu);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("reveal", reveal);
            clientObject.call(METHOD_UNHIDE_ITEMS, args);
        }
    }

    private static boolean hasShowListener(Menu menu) {
        boolean result = menu.isListening(22);
        if (!result) {
            MenuItem[] items = menu.getItems();
            int i = 0;
            while (!result && i < items.length && !result) {
                result = items[i].isListening(30);
                ++i;
            }
        }
        return result;
    }
}

