/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.resources;

import java.io.ByteArrayInputStream;
import org.eclipse.rap.rwt.internal.resources.ContentBuffer;
import org.eclipse.rap.rwt.resources.IResourceManager;

public class JSLibraryConcatenator {
    private final IResourceManager resourceManager;
    private ContentBuffer jsBuffer;
    private String location;

    public JSLibraryConcatenator(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void startJSConcatenation() {
        this.jsBuffer = new ContentBuffer();
    }

    public void appendJSLibrary(byte[] content) {
        if (this.jsBuffer != null) {
            this.jsBuffer.append(content);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void activate() {
        byte[] content;
        if (this.location == null && (content = this.readContent()).length > 0) {
            this.location = this.register(content, "resources.js");
        }
    }

    public void deactivate() {
        this.resourceManager.unregister("resources.js");
        this.jsBuffer = null;
        this.location = null;
    }

    byte[] readContent() {
        byte[] content;
        if (this.jsBuffer != null) {
            content = this.jsBuffer.getContent();
            this.jsBuffer = null;
        } else {
            content = new byte[]{};
        }
        return content;
    }

    private String register(byte[] content, String name) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
        this.resourceManager.register(name, inputStream);
        return this.resourceManager.getLocation(name);
    }
}

