/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.rap.rwt.internal.util.StreamUtil;
import org.eclipse.rap.rwt.resources.IResourceManager;
import org.eclipse.rap.rwt.resources.ResourceLoader;

public class ResourceRegistry {
    private final Collection<ResourceRegistration> resources;
    private final IResourceManager resourceManager;

    public ResourceRegistry(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.resources = new LinkedList<ResourceRegistration>();
    }

    public void add(String resourceName, ResourceLoader resourceLoader) {
        this.resources.add(new ResourceRegistration(resourceName, resourceLoader));
    }

    public void registerResources() {
        ResourceRegistration[] resourceRegistrationArray = this.getResourceRegistrations();
        int n = resourceRegistrationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceRegistration resourceRegistration = resourceRegistrationArray[n2];
            this.registerResource(resourceRegistration);
            ++n2;
        }
        this.clear();
    }

    public ResourceRegistration[] getResourceRegistrations() {
        return this.resources.toArray(new ResourceRegistration[this.resources.size()]);
    }

    public void clear() {
        this.resources.clear();
    }

    private void registerResource(ResourceRegistration resourceRegistration) {
        InputStream inputStream = resourceRegistration.openResource();
        try {
            this.resourceManager.register(resourceRegistration.getResourceName(), inputStream);
        }
        finally {
            StreamUtil.close(inputStream);
        }
    }

    public static class ResourceRegistration {
        private final String resourceName;
        private final ResourceLoader resourceLoader;

        ResourceRegistration(String resourceName, ResourceLoader resourceLoader) {
            this.resourceName = resourceName;
            this.resourceLoader = resourceLoader;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public ResourceLoader getResourceLoader() {
            return this.resourceLoader;
        }

        InputStream openResource() {
            InputStream result;
            try {
                result = this.resourceLoader.getResourceAsStream(this.resourceName);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to load resource: " + this.resourceName, ioe);
            }
            if (result == null) {
                String msg = "Resource loader returned null for resource: " + this.resourceName;
                throw new IllegalStateException(msg);
            }
            return result;
        }
    }
}

