/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

public final class UITestUtil {
    static boolean enabled;

    static {
        String property = System.getProperty("org.eclipse.rap.rwt.enableUITests");
        enabled = Boolean.valueOf(property);
    }

    public static void checkId(String id) {
        if (UITestUtil.isEnabled() && !UITestUtil.isValidId(id)) {
            String msg = "The widget id contains illegal characters: " + id;
            throw new IllegalArgumentException(msg);
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    static boolean isValidId(String id) {
        boolean result = id != null && id.length() > 0 && Character.isLetter(id.charAt(0));
        int i = 1;
        while (result && i < id.length()) {
            char ch = id.charAt(i);
            result &= Character.isLetter(ch) || UITestUtil.isNumber(ch) || ch == '-' || ch == '.' || ch == '_' || ch == ':';
            ++i;
        }
        return result;
    }

    private static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private UITestUtil() {
    }
}

