/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.ui;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.widgets.DialogUtil;
import org.eclipse.rtp.configurator.rest.IEventService;
import org.eclipse.rtp.configurator.rest.RestTemplate;
import org.eclipse.rtp.configurator.ui.UiHelper;
import org.eclipse.rtp.configurator.ui.internal.event.ConfigurationEvent;
import org.eclipse.rtp.configurator.ui.internal.event.EventingServiceUtil;
import org.eclipse.rtp.core.model.Source;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ConfiguratorUiHeader {
    private Label configurationUriLabel;
    private Composite header;
    private Image logo;

    public void createHeader(Display display, Shell shell) {
        this.header = UiHelper.createGridComposite((Composite)shell, 4, false);
        this.logo = new Image((Device)display, this.getClass().getResourceAsStream("/images/rtp-icon.png"));
        Label label = new Label(this.header, 0x1000000);
        label.setImage(this.logo);
        this.configurationUriLabel = new Label(this.header, 0);
        this.configurationUriLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label headerLabel = UiHelper.createLabel(this.header, 1, "EclipseRT Configurator");
        headerLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createConfigurationButton(display, this.header);
    }

    private void createConfigurationButton(Display display, Composite header) {
        Button rtpInstanceManagementButton = new Button(header, 0);
        rtpInstanceManagementButton.setText("manage");
        this.addConfiguratinListener(display, rtpInstanceManagementButton);
    }

    private void addConfiguratinListener(Display display, Button rtpInstanceManagementButton) {
        rtpInstanceManagementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfiguratorUiHeader.this.showInputDialog();
            }
        });
    }

    private void showInputDialog() {
        InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), "RTP Instance Configuration", "Enter instance URI", "", null){

            protected void okPressed() {
                super.okPressed();
                if (ConfiguratorUiHeader.this.isValidLocation(this.getValue())) {
                    ConfiguratorUiHeader.this.configurationUriLabel.setText(this.getValue());
                    ConfiguratorUiHeader.this.fireConfigurationChagned(this.getValue());
                } else {
                    ConfiguratorUiHeader.this.showWarningDialog();
                }
            }
        };
        inputDialog.setBlockOnOpen(false);
        inputDialog.open();
    }

    private boolean isValidLocation(String configurationURI) {
        boolean result = false;
        try {
            RestTemplate restTemplate = new RestTemplate(configurationURI);
            restTemplate.getForEntitiesAsList("/rt/list", Source.class);
            result = true;
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    private void showWarningDialog() {
        MessageBox infoDialog = new MessageBox(Display.getDefault().getActiveShell(), 65576);
        infoDialog.setText("Invalide Location");
        infoDialog.setMessage("No instance found.");
        DialogUtil.open((Dialog)infoDialog, null);
    }

    private void fireConfigurationChagned(String value) {
        ConfigurationEvent configurationEvent = new ConfigurationEvent(value, RWT.getSessionStore().getId());
        IEventService eventService = EventingServiceUtil.getEventService();
        eventService.fireConfigurationEvent(configurationEvent);
    }

    public void dispose() {
        if (this.logo != null) {
            this.logo.dispose();
        }
    }
}

