/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.rap.rwt.internal.application.RWTFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

class FileImageDescriptor
extends ImageDescriptor {
    private Class location;
    private String name;

    FileImageDescriptor(Class clazz, String filename) {
        this.location = clazz;
        this.name = filename;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileImageDescriptor)) {
            return false;
        }
        FileImageDescriptor other = (FileImageDescriptor)o;
        if (this.location != null ? !this.location.equals(other.location) : other.location != null) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public ImageData getImageData() {
        ImageData result;
        block13: {
            InputStream in = this.getStream();
            result = null;
            if (in != null) {
                try {
                    try {
                        result = new ImageData(in);
                    }
                    catch (SWTException e) {
                        if (e.code != 40) {
                            throw e;
                        }
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public Image createImage(boolean returnMissingImageOnError, Device device) {
        Image result = null;
        if (this.location != null) {
            String path = String.valueOf(this.location.getPackage().getName().replace('.', '/')) + "/" + this.name;
            InputStream inputStream = this.getStream();
            if (inputStream != null) {
                try {
                    result = RWTFactory.getImageFactory().createImage(device, path, inputStream);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", e.getMessage(), (Throwable)e));
                    }
                }
            }
            if (returnMissingImageOnError) {
                try {
                    result = new Image(device, DEFAULT_IMAGE_DATA);
                }
                catch (SWTException sWTException) {
                    result = null;
                }
            }
        }
        return result;
    }

    private InputStream getStream() {
        InputStream is = null;
        if (this.location != null) {
            is = this.location.getResourceAsStream(this.name);
        } else {
            try {
                is = new FileInputStream(this.name);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        if (is == null) {
            return null;
        }
        return new BufferedInputStream(is);
    }

    public int hashCode() {
        int code = this.name.hashCode();
        if (this.location != null) {
            code += this.location.hashCode();
        }
        return code;
    }

    public String toString() {
        return "FileImageDescriptor(location=" + this.location + ", name=" + this.name + ")";
    }
}

