/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.AdapterFactory;
import org.eclipse.rap.rwt.internal.AdapterFactoryRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterManager {
    private static final NullAdapterFactory NULL_ADAPTER_FACTORY = new NullAdapterFactory();
    private final Object lock = new Object();
    private final AdapterFactoryRegistry registry = new AdapterFactoryRegistry();
    private final Map<Integer, AdapterFactory> bufferedAdapterFactories = new HashMap<Integer, AdapterFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Object adaptable, Class adapter) {
        AdapterFactory adapterFactory;
        Object object = this.lock;
        synchronized (object) {
            adapterFactory = this.findBufferedAdapterFactory(adaptable, adapter);
            if (adapterFactory == null) {
                adapterFactory = this.determineAdapterFactory(adaptable, adapter);
                this.bufferAdapterFactory(adaptable, adapter, adapterFactory);
            }
        }
        return adapterFactory.getAdapter(adaptable, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAdapters(Class adaptableClass, AdapterFactory adapterFactory) {
        this.registry.register(adaptableClass, adapterFactory);
        Object object = this.lock;
        synchronized (object) {
            this.bufferedAdapterFactories.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAdapters() {
        this.registry.deregisterAdapters();
        Object object = this.lock;
        synchronized (object) {
            this.bufferedAdapterFactories.clear();
        }
    }

    private AdapterFactory findBufferedAdapterFactory(Object adaptable, Class adapter) {
        Integer hash = AdapterManager.calculateHash(adaptable, adapter);
        return this.bufferedAdapterFactories.get(hash);
    }

    private AdapterFactory determineAdapterFactory(Object adaptable, Class<?> adapter) {
        AdapterFactory result = NULL_ADAPTER_FACTORY;
        boolean found = false;
        Class[] adaptableClasses = this.registry.getAdaptableClasses();
        int i = 0;
        while (!found && i < adaptableClasses.length) {
            if (adaptableClasses[i].isAssignableFrom(adaptable.getClass())) {
                AdapterFactory[] factories = this.registry.getAdapterFactories(adaptableClasses[i]);
                int j = 0;
                while (!found && j < factories.length) {
                    Class[] adapters = factories[j].getAdapterList();
                    int k = 0;
                    while (!found && k < adapters.length) {
                        if (adapter.isAssignableFrom(adapters[k])) {
                            result = factories[j];
                            found = true;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private void bufferAdapterFactory(Object adaptable, Class adapter, AdapterFactory adapterFactory) {
        Integer hash = AdapterManager.calculateHash(adaptable, adapter);
        this.bufferedAdapterFactories.put(hash, adapterFactory);
    }

    private static Integer calculateHash(Object adaptable, Class adapterClass) {
        Class<?> adaptableClass = adaptable.getClass();
        int hash = 23273 + adaptableClass.hashCode() * 37 + adapterClass.hashCode();
        return new Integer(hash);
    }

    private static class NullAdapterFactory
    implements AdapterFactory {
        private static final Class[] EMPTY = new Class[0];

        private NullAdapterFactory() {
        }

        public Object getAdapter(Object adaptable, Class adapter) {
            return null;
        }

        public Class[] getAdapterList() {
            return EMPTY;
        }
    }
}

