/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.application;

import java.io.File;
import java.io.Serializable;
import javax.servlet.ServletContext;
import org.eclipse.rap.rwt.internal.application.ApplicationContext;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.ISessionStore;

public class ApplicationContextUtil {
    private static final ThreadLocal<ApplicationContext> CONTEXT_HOLDER = new ThreadLocal();
    private static final String ATTR_APPLICATION_CONTEXT = String.valueOf(ApplicationContext.class.getName()) + "#INSTANCE";

    public static void set(ServletContext servletContext, ApplicationContext applicationContext) {
        servletContext.setAttribute(ATTR_APPLICATION_CONTEXT, (Object)applicationContext);
    }

    public static ApplicationContext get(ServletContext servletContext) {
        return (ApplicationContext)servletContext.getAttribute(ATTR_APPLICATION_CONTEXT);
    }

    public static void remove(ServletContext servletContext) {
        servletContext.removeAttribute(ATTR_APPLICATION_CONTEXT);
    }

    public static void set(ISessionStore sessionStore, ApplicationContext applicationContext) {
        TransientValue transientValue = new TransientValue(applicationContext);
        sessionStore.setAttribute(ATTR_APPLICATION_CONTEXT, transientValue);
    }

    public static ApplicationContext get(ISessionStore sessionStore) {
        ApplicationContext result = null;
        TransientValue value = (TransientValue)sessionStore.getAttribute(ATTR_APPLICATION_CONTEXT);
        if (value != null) {
            result = (ApplicationContext)value.getValue();
        }
        return result;
    }

    public static void remove(ISessionStore sessionStore) {
        sessionStore.removeAttribute(ATTR_APPLICATION_CONTEXT);
    }

    public static ApplicationContext getInstance() {
        ApplicationContext result = CONTEXT_HOLDER.get();
        if (result == null) {
            ServiceContext context = ContextProvider.getContext();
            result = context.getApplicationContext();
        }
        ApplicationContextUtil.checkApplicationContextExists(result);
        return result;
    }

    public static void runWith(ApplicationContext applicationContext, Runnable runnable) {
        ParamCheck.notNull(applicationContext, "applicationContext");
        ParamCheck.notNull(runnable, "runnable");
        ApplicationContextUtil.checkNestedCall();
        CONTEXT_HOLDER.set(applicationContext);
        try {
            runnable.run();
        }
        finally {
            CONTEXT_HOLDER.set(null);
        }
    }

    public static void delete(File toDelete) {
        if (toDelete.exists()) {
            ApplicationContextUtil.doDelete(toDelete);
        }
    }

    static boolean hasContext() {
        return CONTEXT_HOLDER.get() != null;
    }

    private static void checkNestedCall() {
        if (CONTEXT_HOLDER.get() != null) {
            throw new IllegalStateException("Nested call of runWithInstance detected.");
        }
    }

    private static void checkApplicationContextExists(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalStateException("No ApplicationContext registered.");
        }
    }

    private static void doDelete(File toDelete) {
        if (toDelete.isDirectory()) {
            ApplicationContextUtil.deleteChildren(toDelete);
        }
        ApplicationContextUtil.deleteFile(toDelete);
    }

    private static void deleteChildren(File toDelete) {
        File[] children = toDelete.listFiles();
        int i = 0;
        while (i < children.length) {
            ApplicationContextUtil.delete(children[i]);
            ++i;
        }
    }

    private static void deleteFile(File toDelete) {
        boolean deleted = toDelete.delete();
        if (!deleted) {
            throw new IllegalStateException("Could not delete: " + toDelete.getPath());
        }
    }

    private static class TransientValue
    implements Serializable {
        private final transient Object value;

        TransientValue(Object value) {
            this.value = value;
        }

        Object getValue() {
            return this.value;
        }
    }
}

