/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.events;

import java.util.EventListener;
import java.util.EventObject;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.internal.events.IEventAdapter;

public abstract class Event
extends EventObject {
    private static final long serialVersionUID = 1L;
    private final Object source;
    private final int id;

    public Event(Object source, int id) {
        super(source);
        this.source = source;
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    protected static IEventAdapter getEventAdapter(Adaptable adaptable) {
        return adaptable.getAdapter(IEventAdapter.class);
    }

    public void processEvent() {
        IEventAdapter eventAdapter = Event.getEventAdapter(this.getEventSource());
        if (eventAdapter.hasListener(this.getListenerType())) {
            EventListener[] listener = eventAdapter.getListener(this.getListenerType());
            int i = 0;
            while (i < listener.length) {
                this.dispatchToObserver(listener[i]);
                ++i;
            }
        }
    }

    private Adaptable getEventSource() {
        return (Adaptable)this.source;
    }

    protected abstract void dispatchToObserver(Object var1);

    protected abstract Class getListenerType();

    protected static boolean hasListener(Adaptable adaptable, Class listenerType) {
        return Event.getEventAdapter(adaptable).hasListener(listenerType);
    }

    protected static Object[] getListener(Adaptable adaptable, Class listenerType) {
        return Event.getEventAdapter(adaptable).getListener(listenerType);
    }

    protected static void addListener(Adaptable adaptable, Class listenerType, EventListener listener) {
        Event.getEventAdapter(adaptable).addListener(listenerType, listener);
    }

    protected static void removeListener(Adaptable adaptable, Class listenerType, EventListener listener) {
        Event.getEventAdapter(adaptable).removeListener(listenerType, listener);
    }
}

