/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.lifecycle.DefaultEntryPointFactory;
import org.eclipse.rap.rwt.lifecycle.IEntryPoint;
import org.eclipse.rap.rwt.lifecycle.IEntryPointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryPointManager {
    private final Map<String, EntryPointRegistration> entryPointsByPath = new HashMap<String, EntryPointRegistration>();
    private final Map<String, IEntryPointFactory> entryPointsByName = new HashMap<String, IEntryPointFactory>();

    public void registerByPath(String path, Class<? extends IEntryPoint> type, Map<String, String> properties) {
        ParamCheck.notNull(path, "path");
        this.checkValidPath(path);
        this.doRegisterByPath(path, new DefaultEntryPointFactory(type), properties);
    }

    public void registerByPath(String path, IEntryPointFactory entryPointFactory, Map<String, String> properties) {
        ParamCheck.notNull(path, "path");
        ParamCheck.notNull(entryPointFactory, "entryPointFactory");
        this.checkValidPath(path);
        this.doRegisterByPath(path, entryPointFactory, properties);
    }

    public void registerByName(String name, Class<? extends IEntryPoint> type) {
        ParamCheck.notNull(name, "name");
        this.doRegisterByName(name, new DefaultEntryPointFactory(type));
    }

    public void registerByName(String name, IEntryPointFactory entryPointFactory) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(entryPointFactory, "entryPointFactory");
        this.doRegisterByName(name, entryPointFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAll() {
        Map<String, Object> map = this.entryPointsByPath;
        synchronized (map) {
            this.entryPointsByPath.clear();
        }
        map = this.entryPointsByName;
        synchronized (map) {
            this.entryPointsByName.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPointRegistration getRegistrationByPath(String path) {
        Map<String, EntryPointRegistration> map = this.entryPointsByPath;
        synchronized (map) {
            return this.entryPointsByPath.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntryPointFactory getFactoryByName(String name) {
        IEntryPointFactory result;
        Map<String, IEntryPointFactory> map = this.entryPointsByName;
        synchronized (map) {
            result = this.entryPointsByName.get(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getServletPaths() {
        ArrayList<String> result;
        Map<String, EntryPointRegistration> map = this.entryPointsByPath;
        synchronized (map) {
            result = new ArrayList<String>(this.entryPointsByPath.keySet());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegisterByPath(String key, IEntryPointFactory factory, Map<String, String> properties) {
        Map<String, EntryPointRegistration> map = this.entryPointsByPath;
        synchronized (map) {
            this.checkPathAvailable(key);
            this.entryPointsByPath.put(key, new EntryPointRegistration(factory, properties));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegisterByName(String key, IEntryPointFactory entryPointFactory) {
        Map<String, IEntryPointFactory> map = this.entryPointsByName;
        synchronized (map) {
            this.checkNameAvailable(key);
            this.entryPointsByName.put(key, entryPointFactory);
        }
    }

    private void checkValidPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path must start with '/': " + path);
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Path must not end with '/': " + path);
        }
        if (path.length() > 0 && path.substring(1).contains("/")) {
            throw new IllegalArgumentException("Nested paths not yet supported: " + path);
        }
    }

    private void checkPathAvailable(String key) {
        if (this.entryPointsByPath.containsKey(key)) {
            String message = "Entry point already registered for path " + key;
            throw new IllegalArgumentException(message);
        }
    }

    private void checkNameAvailable(String key) {
        if (this.entryPointsByName.containsKey(key)) {
            String message = "Entry point already registered for name: " + key;
            throw new IllegalArgumentException(message);
        }
    }
}

