/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.SingletonManager;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.IServiceStore;
import org.eclipse.rap.rwt.service.ISessionStore;

public class ContextProvider {
    private static final ThreadLocal<ServiceContext> CONTEXT_HOLDER = new ThreadLocal();
    private static final Map<Thread, ServiceContext> CONTEXT_HOLDER_FOR_BG_THREADS = new WeakHashMap<Thread, ServiceContext>();

    public static void setContext(ServiceContext context) {
        ParamCheck.notNull(context, "context");
        if (ContextProvider.getContextInternal() != null) {
            String msg = "Current thread has already a context instance buffered.";
            throw new IllegalStateException(msg);
        }
        CONTEXT_HOLDER.set(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContext(ServiceContext context, Thread thread) {
        ParamCheck.notNull(context, "context");
        ParamCheck.notNull(thread, "thread");
        Map<Thread, ServiceContext> map = CONTEXT_HOLDER_FOR_BG_THREADS;
        synchronized (map) {
            if (CONTEXT_HOLDER_FOR_BG_THREADS.containsKey(thread)) {
                String msg = "The given thread has already a context instance mapped.";
                throw new IllegalStateException(msg);
            }
            CONTEXT_HOLDER_FOR_BG_THREADS.put(thread, context);
        }
    }

    public static ServiceContext getContext() {
        ServiceContext result = ContextProvider.getContextInternal();
        if (result == null) {
            String msg = "No context available outside of the request service lifecycle.";
            throw new IllegalStateException(msg);
        }
        return result;
    }

    public static HttpServletRequest getRequest() {
        return ContextProvider.getContext().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ContextProvider.getContext().getResponse();
    }

    public static ISessionStore getSessionStore() {
        SessionStoreImpl result = (SessionStoreImpl)ContextProvider.getContext().getSessionStore();
        if (result == null) {
            HttpSession httpSession = ContextProvider.getRequest().getSession(true);
            result = SessionStoreImpl.getInstanceFromSession(httpSession);
            if (result == null) {
                result = new SessionStoreImpl(httpSession);
                SessionStoreImpl.attachInstanceToSession(httpSession, result);
                SingletonManager.install(result);
            }
            result.attachHttpSession(httpSession);
            ContextProvider.getContext().setSessionStore(result);
        }
        return result;
    }

    public static IServiceStore getServiceStore() {
        return ContextProvider.getContext().getServiceStore();
    }

    public static ProtocolMessageWriter getProtocolWriter() {
        return ContextProvider.getContext().getProtocolWriter();
    }

    public static void disposeContext() {
        ServiceContext context = CONTEXT_HOLDER.get();
        if (context != null && !context.isDisposed()) {
            context.dispose();
        }
        ContextProvider.releaseContextHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean releaseContextHolder() {
        boolean result = false;
        ServiceContext object = CONTEXT_HOLDER.get();
        if (object != null) {
            CONTEXT_HOLDER.set(null);
        } else {
            Map<Thread, ServiceContext> map = CONTEXT_HOLDER_FOR_BG_THREADS;
            synchronized (map) {
                ServiceContext toRemove = CONTEXT_HOLDER_FOR_BG_THREADS.get(Thread.currentThread());
                if (toRemove != null) {
                    CONTEXT_HOLDER_FOR_BG_THREADS.remove(Thread.currentThread());
                }
            }
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeContext(Thread thread) {
        ParamCheck.notNull(thread, "thread");
        Map<Thread, ServiceContext> map = CONTEXT_HOLDER_FOR_BG_THREADS;
        synchronized (map) {
            ServiceContext toRemove = CONTEXT_HOLDER_FOR_BG_THREADS.get(thread);
            if (toRemove != null) {
                CONTEXT_HOLDER_FOR_BG_THREADS.remove(thread);
                toRemove.dispose();
            }
        }
    }

    public static boolean hasContext() {
        return ContextProvider.getContextInternal() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceContext getContextInternal() {
        ServiceContext result = CONTEXT_HOLDER.get();
        if (result == null) {
            Map<Thread, ServiceContext> map = CONTEXT_HOLDER_FOR_BG_THREADS;
            synchronized (map) {
                Thread currentThread = Thread.currentThread();
                result = CONTEXT_HOLDER_FOR_BG_THREADS.get(currentThread);
            }
        }
        return result;
    }
}

