/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ccombokit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Widget;

public final class CComboLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Combo";
    private static final String[] ALLOWED_STYLES = new String[]{"FLAT", "BORDER"};
    static final String PROP_ITEMS = "items";
    static final String PROP_TEXT = "text";
    static final String PROP_SELECTION_INDEX = "selectionIndex";
    static final String PROP_SELECTION = "selection";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_LIST_VISIBLE = "listVisible";
    static final String PROP_EDITABLE = "editable";
    static final String PROP_VISIBLE_ITEM_COUNT = "visibleItemCount";
    static final String PROP_ITEM_HEIGHT = "itemHeight";
    static final String PROP_SELECTION_LISTENER = "selection";
    static final String PROP_MODIFY_LISTENER = "modify";
    static final String PROP_VERIFY_LISTENER = "verify";
    private static final String[] DEFAUT_ITEMS = new String[0];
    private static final Integer DEFAULT_SELECTION_INDEX = new Integer(-1);
    private static final Point DEFAULT_SELECTION = new Point(0, 0);
    private static final int DEFAULT_VISIBLE_ITEM_COUNT = 5;

    public void preserveValues(Widget widget) {
        CCombo ccombo = (CCombo)widget;
        ControlLCAUtil.preserveValues(ccombo);
        WidgetLCAUtil.preserveCustomVariant(ccombo);
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_ITEMS, ccombo.getItems());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_SELECTION_INDEX, ccombo.getSelectionIndex());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, "selection", ccombo.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_TEXT_LIMIT, CComboLCA.getTextLimit(ccombo));
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_VISIBLE_ITEM_COUNT, ccombo.getVisibleItemCount());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_ITEM_HEIGHT, ccombo.getItemHeight());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_TEXT, ccombo.getText());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_LIST_VISIBLE, ccombo.getListVisible());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_EDITABLE, (Object)ccombo.getEditable());
        WidgetLCAUtil.preserveListener(ccombo, "selection", SelectionEvent.hasListener(ccombo));
        WidgetLCAUtil.preserveListener(ccombo, PROP_MODIFY_LISTENER, ModifyEvent.hasListener(ccombo));
        WidgetLCAUtil.preserveListener(ccombo, PROP_VERIFY_LISTENER, VerifyEvent.hasListener(ccombo));
    }

    public void readData(Widget widget) {
        String listVisible;
        CCombo ccombo = (CCombo)widget;
        String value = WidgetLCAUtil.readPropertyValue(ccombo, "selectedItem");
        if (value != null) {
            ccombo.select(NumberFormatUtil.parseInt(value));
        }
        if ((listVisible = WidgetLCAUtil.readPropertyValue(ccombo, PROP_LIST_VISIBLE)) != null) {
            ccombo.setListVisible(Boolean.valueOf(listVisible));
        }
        CComboLCA.readTextAndSelection(ccombo);
        ControlLCAUtil.processSelection(ccombo, null, true);
        ControlLCAUtil.processMouseEvents(ccombo);
        ControlLCAUtil.processKeyEvents(ccombo);
        ControlLCAUtil.processMenuDetect(ccombo);
        WidgetLCAUtil.processHelp(ccombo);
    }

    public void renderInitialization(Widget widget) throws IOException {
        CCombo ccombo = (CCombo)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(ccombo);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(ccombo.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(ccombo, ALLOWED_STYLES));
        clientObject.set("ccombo", true);
    }

    public void renderChanges(Widget widget) throws IOException {
        CCombo ccombo = (CCombo)widget;
        ControlLCAUtil.renderChanges(ccombo);
        WidgetLCAUtil.renderCustomVariant(ccombo);
        CComboLCA.renderItemHeight(ccombo);
        CComboLCA.renderVisibleItemCount(ccombo);
        CComboLCA.renderItems(ccombo);
        CComboLCA.renderListVisible(ccombo);
        CComboLCA.renderSelectionIndex(ccombo);
        CComboLCA.renderEditable(ccombo);
        CComboLCA.renderText(ccombo);
        CComboLCA.renderSelection(ccombo);
        CComboLCA.renderTextLimit(ccombo);
        CComboLCA.renderListenSelection(ccombo);
        CComboLCA.renderListenModify(ccombo);
        CComboLCA.renderListenVerify(ccombo);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    private static void readTextAndSelection(final CCombo ccombo) {
        final Point selection = CComboLCA.readSelection(ccombo);
        final String txt = WidgetLCAUtil.readPropertyValue(ccombo, PROP_TEXT);
        if (txt != null) {
            if (VerifyEvent.hasListener(ccombo)) {
                ProcessActionRunner.add(new Runnable(){

                    public void run() {
                        ccombo.setText(txt);
                        IWidgetAdapter adapter = WidgetUtil.getAdapter(ccombo);
                        adapter.preserve(CComboLCA.PROP_TEXT, txt);
                        if (selection != null) {
                            ccombo.setSelection(selection);
                            adapter.preserve("selection", selection);
                        }
                    }
                });
            } else {
                ccombo.setText(txt);
                if (selection != null) {
                    ccombo.setSelection(selection);
                }
            }
        } else if (selection != null) {
            ccombo.setSelection(selection);
        }
    }

    private static Point readSelection(CCombo ccombo) {
        Point result = null;
        String selStart = WidgetLCAUtil.readPropertyValue(ccombo, "selectionStart");
        String selLength = WidgetLCAUtil.readPropertyValue(ccombo, "selectionLength");
        if (selStart != null || selLength != null) {
            result = new Point(0, 0);
            if (selStart != null) {
                result.x = NumberFormatUtil.parseInt(selStart);
            }
            if (selLength != null) {
                result.y = result.x + NumberFormatUtil.parseInt(selLength);
            }
        }
        return result;
    }

    private static void renderItemHeight(CCombo ccombo) {
        Integer newValue = new Integer(ccombo.getItemHeight());
        if (WidgetLCAUtil.hasChanged(ccombo, PROP_ITEM_HEIGHT, newValue)) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(ccombo);
            clientObject.set(PROP_ITEM_HEIGHT, newValue);
        }
    }

    private static void renderVisibleItemCount(CCombo ccombo) {
        int defValue = 5;
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_VISIBLE_ITEM_COUNT, ccombo.getVisibleItemCount(), defValue);
    }

    private static void renderItems(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_ITEMS, ccombo.getItems(), DEFAUT_ITEMS);
    }

    private static void renderListVisible(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_LIST_VISIBLE, ccombo.getListVisible(), false);
    }

    private static void renderSelectionIndex(CCombo ccombo) {
        boolean textChanged;
        Integer newValue = new Integer(ccombo.getSelectionIndex());
        boolean selectionChanged = WidgetLCAUtil.hasChanged(ccombo, PROP_SELECTION_INDEX, newValue, DEFAULT_SELECTION_INDEX);
        boolean bl = textChanged = !ccombo.getEditable() && WidgetLCAUtil.hasChanged(ccombo, PROP_TEXT, ccombo.getText(), "");
        if (selectionChanged || textChanged) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(ccombo);
            clientObject.set(PROP_SELECTION_INDEX, newValue);
        }
    }

    private static void renderEditable(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_EDITABLE, ccombo.getEditable(), true);
    }

    private static void renderText(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_TEXT, ccombo.getText(), "");
    }

    private static void renderSelection(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, "selection", ccombo.getSelection(), DEFAULT_SELECTION);
    }

    private static void renderTextLimit(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_TEXT_LIMIT, CComboLCA.getTextLimit(ccombo), null);
    }

    private static void renderListenSelection(CCombo ccombo) {
        WidgetLCAUtil.renderListener(ccombo, "selection", SelectionEvent.hasListener(ccombo), false);
    }

    private static void renderListenModify(CCombo ccombo) {
        WidgetLCAUtil.renderListener(ccombo, PROP_MODIFY_LISTENER, ModifyEvent.hasListener(ccombo), false);
    }

    private static void renderListenVerify(CCombo ccombo) {
        WidgetLCAUtil.renderListener(ccombo, PROP_VERIFY_LISTENER, VerifyEvent.hasListener(ccombo), false);
    }

    private static Integer getTextLimit(CCombo ccombo) {
        Integer result = ccombo.getTextLimit();
        if (result == Integer.MAX_VALUE) {
            result = null;
        }
        return result;
    }
}

