/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.dnd.IDNDAdapter;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class DNDSupport {
    private static final String PACKAGE_PREFIX = "org.eclipse.swt.dnd";
    private static final String EVENT_DRAG_START = "org.eclipse.swt.dnd.dragStart";
    private static final String EVENT_DRAG_START_X = "org.eclipse.swt.dnd.dragStart.x";
    private static final String EVENT_DRAG_START_Y = "org.eclipse.swt.dnd.dragStart.y";
    private static final String EVENT_DRAG_START_TIME = "org.eclipse.swt.dnd.dragStart.time";
    private static final String EVENT_DRAG_ENTER = "org.eclipse.swt.dnd.dragEnter";
    private static final String EVENT_DRAG_ENTER_OPERATION = "org.eclipse.swt.dnd.dragEnter.operation";
    private static final String EVENT_DRAG_ENTER_X = "org.eclipse.swt.dnd.dragEnter.x";
    private static final String EVENT_DRAG_ENTER_Y = "org.eclipse.swt.dnd.dragEnter.y";
    private static final String EVENT_DRAG_ENTER_ITEM = "org.eclipse.swt.dnd.dragEnter.item";
    private static final String EVENT_DRAG_ENTER_TIME = "org.eclipse.swt.dnd.dragEnter.time";
    private static final String EVENT_DRAG_ENTER_SOURCE = "org.eclipse.swt.dnd.dragEnter.source";
    private static final String EVENT_DRAG_ENTER_FEEDBACK = "org.eclipse.swt.dnd.dragEnter.feedback";
    private static final String EVENT_DRAG_OPERATION_CHANGED = "org.eclipse.swt.dnd.dragOperationChanged";
    private static final String EVENT_DRAG_OPERATION_CHANGED_OPERATION = "org.eclipse.swt.dnd.dragOperationChanged.operation";
    private static final String EVENT_DRAG_OPERATION_CHANGED_FEEDBACK = "org.eclipse.swt.dnd.dragOperationChanged.feedback";
    private static final String EVENT_DRAG_OPERATION_CHANGED_X = "org.eclipse.swt.dnd.dragOperationChanged.x";
    private static final String EVENT_DRAG_OPERATION_CHANGED_Y = "org.eclipse.swt.dnd.dragOperationChanged.y";
    private static final String EVENT_DRAG_OPERATION_CHANGED_ITEM = "org.eclipse.swt.dnd.dragOperationChanged.item";
    private static final String EVENT_DRAG_OPERATION_CHANGED_SOURCE = "org.eclipse.swt.dnd.dragOperationChanged.source";
    private static final String EVENT_DRAG_OPERATION_CHANGED_TIME = "org.eclipse.swt.dnd.dragOperationChanged.time";
    private static final String EVENT_DRAG_OPERATION_CHANGED_DATATYPE = "org.eclipse.swt.dnd.dragOperationChanged.dataType";
    private static final String EVENT_DRAG_OVER = "org.eclipse.swt.dnd.dragOver";
    private static final String EVENT_DRAG_OVER_OPERATION = "org.eclipse.swt.dnd.dragOver.operation";
    private static final String EVENT_DRAG_OVER_FEEDBACK = "org.eclipse.swt.dnd.dragOver.feedback";
    private static final String EVENT_DRAG_OVER_X = "org.eclipse.swt.dnd.dragOver.x";
    private static final String EVENT_DRAG_OVER_Y = "org.eclipse.swt.dnd.dragOver.y";
    private static final String EVENT_DRAG_OVER_ITEM = "org.eclipse.swt.dnd.dragOver.item";
    private static final String EVENT_DRAG_OVER_SOURCE = "org.eclipse.swt.dnd.dragOver.source";
    private static final String EVENT_DRAG_OVER_TIME = "org.eclipse.swt.dnd.dragOver.time";
    private static final String EVENT_DRAG_OVER_DATATYPE = "org.eclipse.swt.dnd.dragOver.dataType";
    private static final String EVENT_DRAG_LEAVE = "org.eclipse.swt.dnd.dragLeave";
    private static final String EVENT_DRAG_LEAVE_OPERATION = "org.eclipse.swt.dnd.dragLeave.operation";
    private static final String EVENT_DRAG_LEAVE_X = "org.eclipse.swt.dnd.dragLeave.x";
    private static final String EVENT_DRAG_LEAVE_Y = "org.eclipse.swt.dnd.dragLeave.y";
    private static final String EVENT_DRAG_LEAVE_TIME = "org.eclipse.swt.dnd.dragLeave.time";
    private static final String EVENT_DROP_ACCEPT = "org.eclipse.swt.dnd.dropAccept";
    private static final String EVENT_DROP_ACCEPT_OPERATION = "org.eclipse.swt.dnd.dropAccept.operation";
    private static final String EVENT_DROP_ACCEPT_X = "org.eclipse.swt.dnd.dropAccept.x";
    private static final String EVENT_DROP_ACCEPT_Y = "org.eclipse.swt.dnd.dropAccept.y";
    private static final String EVENT_DROP_ACCEPT_ITEM = "org.eclipse.swt.dnd.dropAccept.item";
    private static final String EVENT_DROP_ACCEPT_SOURCE = "org.eclipse.swt.dnd.dropAccept.source";
    private static final String EVENT_DROP_ACCEPT_TIME = "org.eclipse.swt.dnd.dropAccept.time";
    private static final String EVENT_DROP_ACCEPT_DATATYPE = "org.eclipse.swt.dnd.dropAccept.dataType";
    private static final String EVENT_DRAG_FINISHED = "org.eclipse.swt.dnd.dragFinished";
    private static final String EVENT_DRAG_FINISHED_X = "org.eclipse.swt.dnd.dragFinished.x";
    private static final String EVENT_DRAG_FINISHED_Y = "org.eclipse.swt.dnd.dragFinished.y";
    private static final String EVENT_DRAG_FINISHED_TIME = "org.eclipse.swt.dnd.dragFinished.time";

    private DNDSupport() {
    }

    public static void processEvents() {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                DNDSupport.processDragStart();
                if (DNDSupport.isLeaveBeforeEnter()) {
                    DNDSupport.processDragLeave();
                    DNDSupport.processDragEnter();
                    DNDSupport.processDragOperationChanged();
                    DNDSupport.processDragOver();
                } else {
                    DNDSupport.processDragEnter();
                    DNDSupport.processDragOperationChanged();
                    DNDSupport.processDragOver();
                    DNDSupport.processDragLeave();
                }
                DNDSupport.processDragFinished();
            }
        });
    }

    private static void processDragStart() {
        Control control = DNDSupport.readControlParam(EVENT_DRAG_START);
        if (control != null) {
            DragSource dragSource = DNDSupport.getDragSource(control);
            Point point = DNDSupport.readXYParams(EVENT_DRAG_START_X, EVENT_DRAG_START_Y);
            Point mappedPoint = control.getDisplay().map(null, control, point);
            DragDetectEvent dragDetectEvent = DNDSupport.createDragDetectEvent(control, mappedPoint);
            dragDetectEvent.processEvent();
            DragSourceEvent dragStartEvent = DNDSupport.createDragStartEvent(dragSource, mappedPoint, dragDetectEvent.time);
            dragStartEvent.processEvent();
            if (!dragStartEvent.doit) {
                DNDSupport.getDNDAdapter(dragSource).cancel();
            }
        }
    }

    private static void processDragEnter() {
        Control control = DNDSupport.readControlParam(EVENT_DRAG_ENTER);
        if (control != null) {
            DropTarget dropTarget = DNDSupport.getDropTarget(control);
            Control sourceControl = DNDSupport.readControlParam(EVENT_DRAG_ENTER_SOURCE);
            DragSource dragSource = DNDSupport.getDragSource(sourceControl);
            Point point = DNDSupport.readXYParams(EVENT_DRAG_ENTER_X, EVENT_DRAG_ENTER_Y);
            DropTargetEvent event = new DropTargetEvent(dropTarget, 2002);
            int operation = DNDSupport.readOperationParam(EVENT_DRAG_ENTER_OPERATION);
            int feedback = DNDSupport.readIntParam(EVENT_DRAG_ENTER_FEEDBACK);
            Item item = DNDSupport.readItemParam(EVENT_DRAG_ENTER_ITEM);
            TransferData[] validDataTypes = DNDSupport.determineDataTypes(dragSource, dropTarget);
            TransferData dataType = validDataTypes[0];
            event.detail = operation;
            event.operations = DNDSupport.getOperations(dragSource, dropTarget);
            event.feedback = feedback;
            event.currentDataType = dataType;
            event.dataTypes = validDataTypes;
            event.item = item;
            event.x = point.x;
            event.y = point.y;
            event.time = DNDSupport.readIntParam(EVENT_DRAG_ENTER_TIME);
            event.processEvent();
            if (event.detail != operation) {
                DNDSupport.changeOperation(dragSource, dropTarget, event.detail);
            }
            DNDSupport.changeDataType(dragSource, dropTarget, event.currentDataType);
            if (event.feedback != feedback) {
                DNDSupport.getDNDAdapter(dragSource).setFeedbackChanged(control, event.feedback);
            }
        }
    }

    private static void processDragOver() {
        Control control = DNDSupport.readControlParam(EVENT_DRAG_OVER);
        if (control != null) {
            DropTarget dropTarget = DNDSupport.getDropTarget(control);
            Control sourceControl = DNDSupport.readControlParam(EVENT_DRAG_OVER_SOURCE);
            DragSource dragSource = DNDSupport.getDragSource(sourceControl);
            IDNDAdapter dndAdapter = DNDSupport.getDNDAdapter(dragSource);
            int operation = DNDSupport.readOperationParam(dndAdapter, EVENT_DRAG_OVER_OPERATION);
            int feedback = DNDSupport.readFeedbackParam(dndAdapter, EVENT_DRAG_OVER_FEEDBACK);
            TransferData dataType = DNDSupport.readTransferDataParam(dndAdapter, EVENT_DRAG_OVER_DATATYPE);
            Point point = DNDSupport.readXYParams(EVENT_DRAG_OVER_X, EVENT_DRAG_OVER_Y);
            Item item = DNDSupport.readItemParam(EVENT_DRAG_OVER_ITEM);
            DropTargetEvent event = new DropTargetEvent(dropTarget, 2004);
            event.detail = operation;
            event.feedback = feedback;
            event.operations = DNDSupport.getOperations(dragSource, dropTarget);
            event.currentDataType = dataType;
            event.dataTypes = DNDSupport.determineDataTypes(dragSource, dropTarget);
            event.item = item;
            event.x = point.x;
            event.y = point.y;
            event.time = DNDSupport.readIntParam(EVENT_DRAG_OVER_TIME);
            event.processEvent();
            if (event.detail != operation) {
                DNDSupport.changeOperation(dragSource, dropTarget, event.detail);
            }
            if (event.currentDataType != dataType) {
                DNDSupport.changeDataType(dragSource, dropTarget, event.currentDataType);
            }
            if (event.feedback != feedback) {
                DNDSupport.getDNDAdapter(dragSource).setFeedbackChanged(control, event.feedback);
            }
        }
    }

    private static void processDragOperationChanged() {
        Control control = DNDSupport.readControlParam(EVENT_DRAG_OPERATION_CHANGED);
        if (control != null) {
            DropTarget dropTarget = DNDSupport.getDropTarget(control);
            Control sourceControl = DNDSupport.readControlParam(EVENT_DRAG_OPERATION_CHANGED_SOURCE);
            DragSource dragSource = DNDSupport.getDragSource(sourceControl);
            IDNDAdapter dndAdapter = DNDSupport.getDNDAdapter(dragSource);
            int operation = DNDSupport.readOperationParam(dndAdapter, EVENT_DRAG_OPERATION_CHANGED_OPERATION);
            int feedback = DNDSupport.readFeedbackParam(dndAdapter, EVENT_DRAG_OPERATION_CHANGED_FEEDBACK);
            TransferData dataType = DNDSupport.readTransferDataParam(dndAdapter, EVENT_DRAG_OPERATION_CHANGED_DATATYPE);
            Point point = DNDSupport.readXYParams(EVENT_DRAG_OPERATION_CHANGED_X, EVENT_DRAG_OPERATION_CHANGED_Y);
            Item item = DNDSupport.readItemParam(EVENT_DRAG_OPERATION_CHANGED_ITEM);
            DropTargetEvent event = new DropTargetEvent(dropTarget, 2005);
            event.detail = operation;
            event.feedback = feedback;
            event.currentDataType = dataType;
            event.dataTypes = DNDSupport.determineDataTypes(dragSource, dropTarget);
            event.operations = DNDSupport.getOperations(dragSource, dropTarget);
            event.item = item;
            event.x = point.x;
            event.y = point.y;
            event.time = DNDSupport.readIntParam(EVENT_DRAG_OPERATION_CHANGED_TIME);
            event.processEvent();
            if (event.detail != operation) {
                DNDSupport.changeOperation(dragSource, dropTarget, event.detail);
            }
            if (event.currentDataType != dataType) {
                DNDSupport.changeDataType(dragSource, dropTarget, event.currentDataType);
            }
            if (event.feedback != feedback) {
                DNDSupport.getDNDAdapter(dragSource).setFeedbackChanged(control, event.feedback);
            }
        }
    }

    private static void processDragLeave() {
        Control control = DNDSupport.readControlParam(EVENT_DRAG_LEAVE);
        if (control != null) {
            DropTarget dropTarget = DNDSupport.getDropTarget(control);
            Point point = DNDSupport.readXYParams(EVENT_DRAG_LEAVE_X, EVENT_DRAG_LEAVE_Y);
            int operation = DNDSupport.readOperationParam(EVENT_DRAG_LEAVE_OPERATION);
            int time = DNDSupport.readIntParam(EVENT_DRAG_LEAVE_TIME);
            DNDSupport.fireDragLeave(operation, dropTarget, point, time);
        }
    }

    private static void processDragFinished() {
        int operation = 0;
        Control dropTargetControl = DNDSupport.readControlParam(EVENT_DROP_ACCEPT);
        if (dropTargetControl != null) {
            DropTarget dropTarget = DNDSupport.getDropTarget(dropTargetControl);
            Control sourceControl = DNDSupport.readControlParam(EVENT_DROP_ACCEPT_SOURCE);
            DragSource dragSource = DNDSupport.getDragSource(sourceControl);
            IDNDAdapter dndAdapter = DNDSupport.getDNDAdapter(dragSource);
            operation = DNDSupport.readOperationParam(dndAdapter, EVENT_DROP_ACCEPT_OPERATION);
            TransferData dataType = DNDSupport.readTransferDataParam(dndAdapter, EVENT_DROP_ACCEPT_DATATYPE);
            Point point = DNDSupport.readXYParams(EVENT_DROP_ACCEPT_X, EVENT_DROP_ACCEPT_Y);
            Item item = DNDSupport.readItemParam(EVENT_DROP_ACCEPT_ITEM);
            int time = DNDSupport.readIntParam(EVENT_DROP_ACCEPT_TIME);
            DNDSupport.fireDragLeave(operation, dropTarget, point, time);
            DropTargetEvent event = DNDSupport.createDropAcceptEvent(dropTarget, operation, point, dataType, item);
            event.operations = DNDSupport.getOperations(dragSource, dropTarget);
            event.processEvent();
            operation = DNDSupport.checkOperation(dragSource, dropTarget, event.detail);
            TransferData[] validDataTypes = DNDSupport.determineDataTypes(dragSource, dropTarget);
            dataType = DNDSupport.checkDataType(event.currentDataType, validDataTypes);
            if (operation != 0 && dataType != null) {
                DragSourceEvent setDataEvent = DNDSupport.createDragSetDataEvent(dragSource, dataType, point);
                setDataEvent.processEvent();
                Object data = DNDSupport.transferData(dropTarget, dataType, setDataEvent);
                DropTargetEvent dropEvent = new DropTargetEvent(dropTarget, 2006);
                dropEvent.detail = operation;
                dropEvent.operations = DNDSupport.getOperations(dragSource, dropTarget);
                dropEvent.currentDataType = dataType;
                dropEvent.dataTypes = validDataTypes;
                dropEvent.item = item;
                dropEvent.x = point.x;
                dropEvent.y = point.y;
                dropEvent.data = data;
                dropEvent.processEvent();
                operation = DNDSupport.checkOperation(dragSource, dropTarget, dropEvent.detail);
            }
        }
        DNDSupport.fireDragFinished(operation);
    }

    private static DragDetectEvent createDragDetectEvent(Control control, Point point) {
        DragDetectEvent result = new DragDetectEvent(control);
        result.x = point.x;
        result.y = point.y;
        result.button = 1;
        result.time = DNDSupport.readIntParam(EVENT_DRAG_START_TIME);
        return result;
    }

    private static DragSourceEvent createDragStartEvent(DragSource dragSource, Point point, int time) {
        DragSourceEvent result = new DragSourceEvent(dragSource, 2008);
        result.detail = 0;
        result.x = point.x;
        result.y = point.y;
        result.doit = true;
        result.time = time;
        return result;
    }

    private static DragSourceEvent createDragSetDataEvent(DragSource dragSource, TransferData dataType, Point point) {
        DragSourceEvent result = new DragSourceEvent(dragSource, 2001);
        result.detail = 0;
        result.dataType = dataType;
        result.x = point.x;
        result.y = point.y;
        result.data = null;
        result.doit = true;
        return result;
    }

    private static DropTargetEvent createDropAcceptEvent(DropTarget dropTarget, int operation, Point point, TransferData dataType, Item item) {
        DropTargetEvent result = new DropTargetEvent(dropTarget, 2007);
        result.detail = operation;
        result.x = point.x;
        result.y = point.y;
        result.item = item;
        result.currentDataType = dataType;
        return result;
    }

    private static void fireDragLeave(int operation, DropTarget dropTarget, Point point, int time) {
        DropTargetEvent event = new DropTargetEvent(dropTarget, 2003);
        event.detail = operation;
        event.x = point.x;
        event.y = point.y;
        event.time = time;
        event.processEvent();
    }

    private static void fireDragFinished(int operation) {
        Control dragSourceControl = DNDSupport.readControlParam(EVENT_DRAG_FINISHED);
        if (dragSourceControl != null) {
            DragSource dragSource = DNDSupport.getDragSource(dragSourceControl);
            IDNDAdapter dndAdapter = DNDSupport.getDNDAdapter(dragSource);
            dndAdapter.cancelDetailChanged();
            dndAdapter.cancelFeedbackChanged();
            dndAdapter.cancelDataTypeChanged();
            Point point = DNDSupport.readXYParams(EVENT_DRAG_FINISHED_X, EVENT_DRAG_FINISHED_Y);
            DragSourceEvent event = new DragSourceEvent(dragSource, 2000);
            event.x = point.x;
            event.y = point.y;
            event.detail = operation;
            event.doit = true;
            event.time = DNDSupport.readIntParam(EVENT_DRAG_FINISHED_TIME);
            event.processEvent();
        }
    }

    private static IDNDAdapter getDNDAdapter(DragSource dragSource) {
        return dragSource.getAdapter(IDNDAdapter.class);
    }

    private static DropTarget getDropTarget(Control control) {
        return (DropTarget)control.getData("DropTarget");
    }

    private static DragSource getDragSource(Control control) {
        return (DragSource)control.getData("DragSource");
    }

    private static Object transferData(DropTarget dropTarget, TransferData dataType, DragSourceEvent setDataEvent) {
        Object data = null;
        if (setDataEvent.doit) {
            Transfer transfer = DNDSupport.findTransferByType(dataType, dropTarget);
            transfer.javaToNative(setDataEvent.data, dataType);
            data = transfer.nativeToJava(dataType);
        }
        return data;
    }

    static TransferData[] determineDataTypes(DragSource dragSource, DropTarget dropTarget) {
        ArrayList<TransferData> supportedTypes = new ArrayList<TransferData>();
        Transfer[] dragSourceTransfers = dragSource.getTransfer();
        Transfer[] dropTargetTransfers = dropTarget.getTransfer();
        int i = 0;
        while (i < dragSourceTransfers.length) {
            TransferData[] dataTypes = dragSourceTransfers[i].getSupportedTypes();
            int j = 0;
            while (j < dropTargetTransfers.length) {
                int k = 0;
                while (k < dataTypes.length) {
                    if (dropTargetTransfers[j].isSupportedType(dataTypes[k])) {
                        supportedTypes.add(dataTypes[k]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        TransferData[] result = new TransferData[supportedTypes.size()];
        int i2 = 0;
        while (i2 < supportedTypes.size()) {
            result[i2] = (TransferData)supportedTypes.get(i2);
            ++i2;
        }
        return result;
    }

    private static Transfer findTransferByType(TransferData type, DropTarget dropTarget) {
        Transfer result = null;
        Transfer[] supported = dropTarget.getTransfer();
        int i = 0;
        while (result == null && i < supported.length) {
            if (supported[i].isSupportedType(type)) {
                result = supported[i];
            }
            ++i;
        }
        return result;
    }

    private static Widget findWidgetById(String id) {
        Widget result = null;
        Display display = LifeCycleUtil.getSessionDisplay();
        Shell[] shells = DNDSupport.getDisplayAdapter(display).getShells();
        int i = 0;
        while (result == null && i < shells.length) {
            Widget widget = WidgetUtil.find(shells[i], id);
            if (widget != null) {
                result = widget;
            }
            ++i;
        }
        return result;
    }

    private static IDisplayAdapter getDisplayAdapter(Display display) {
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return adapter;
    }

    private static String readStringParam(String paramName) {
        HttpServletRequest request = ContextProvider.getRequest();
        return request.getParameter(paramName);
    }

    private static int readIntParam(String paramName) {
        String value = DNDSupport.readStringParam(paramName);
        return NumberFormatUtil.parseInt(value);
    }

    private static Control readControlParam(String paramName) {
        Control result = null;
        String value = DNDSupport.readStringParam(paramName);
        if (value != null) {
            result = (Control)DNDSupport.findWidgetById(value);
        }
        return result;
    }

    private static Item readItemParam(String paramName) {
        Item result = null;
        String value = DNDSupport.readStringParam(paramName);
        if (value != null) {
            result = (Item)DNDSupport.findWidgetById(value);
        }
        return result;
    }

    private static TransferData readDataTypeParam(String paramName) {
        TransferData result = null;
        String value = DNDSupport.readStringParam(paramName);
        String string = value = "null".equals(value) ? null : value;
        if (value != null) {
            result = new TransferData();
            result.type = NumberFormatUtil.parseInt(value);
        }
        return result;
    }

    private static Point readXYParams(String xParamName, String yParamName) {
        int x = DNDSupport.readIntParam(xParamName);
        int y = DNDSupport.readIntParam(yParamName);
        return new Point(x, y);
    }

    private static int readOperationParam(IDNDAdapter dndAdapter, String paramName) {
        int result = dndAdapter.hasDetailChanged() ? dndAdapter.getDetailChangedValue() : DNDSupport.readOperationParam(paramName);
        return result;
    }

    private static int readFeedbackParam(IDNDAdapter dndAdapter, String paramName) {
        int result = dndAdapter.hasFeedbackChanged() ? dndAdapter.getFeedbackChangedValue() : DNDSupport.readIntParam(paramName);
        return result;
    }

    private static TransferData readTransferDataParam(IDNDAdapter adapter, String paramName) {
        TransferData result = adapter.hasDataTypeChanged() ? adapter.getDataTypeChangedValue() : DNDSupport.readDataTypeParam(paramName);
        return result;
    }

    private static int readOperationParam(String paramName) {
        int result = 0;
        String value = DNDSupport.readStringParam(paramName);
        if ("copy".equals(value)) {
            result = 1;
        } else if ("move".equals(value)) {
            result = 2;
        } else if ("link".equals(value)) {
            result = 4;
        }
        return result;
    }

    private static boolean isLeaveBeforeEnter() {
        boolean result = false;
        String enter = DNDSupport.readStringParam(EVENT_DRAG_ENTER_TIME);
        String leave = DNDSupport.readStringParam(EVENT_DRAG_LEAVE_TIME);
        if (enter != null && leave != null) {
            result = NumberFormatUtil.parseInt(leave) <= NumberFormatUtil.parseInt(enter);
        }
        return result;
    }

    private static void changeOperation(DragSource dragSource, DropTarget dropTarget, int detail) {
        int checkedOperation = DNDSupport.checkOperation(dragSource, dropTarget, detail);
        IDNDAdapter dndAdapter = DNDSupport.getDNDAdapter(dragSource);
        dndAdapter.setDetailChanged(dropTarget.getControl(), checkedOperation);
    }

    private static void changeDataType(DragSource dragSource, DropTarget dropTarget, TransferData dataType) {
        TransferData[] validDataTypes = DNDSupport.determineDataTypes(dragSource, dropTarget);
        TransferData value = DNDSupport.checkDataType(dataType, validDataTypes);
        if (value == null) {
            value = validDataTypes[0];
        }
        Control control = dropTarget.getControl();
        DNDSupport.getDNDAdapter(dragSource).setDataTypeChanged(control, value);
    }

    private static int getOperations(DragSource dragSource, DropTarget dropTarget) {
        return dragSource.getStyle() & dropTarget.getStyle();
    }

    private static int checkOperation(DragSource dragSource, DropTarget dropTarget, int operation) {
        int result = 0;
        int allowedOperations = DNDSupport.getOperations(dragSource, dropTarget);
        if ((allowedOperations & operation) != 0) {
            result = operation;
        }
        return result;
    }

    private static TransferData checkDataType(TransferData dataType, TransferData[] validTypes) {
        boolean isValidType = false;
        int i = 0;
        while (i < validTypes.length) {
            if (!isValidType) {
                isValidType = TransferData.sameType(dataType, validTypes[i]);
            }
            ++i;
        }
        return isValidType ? dataType : null;
    }
}

