/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menukit;

import java.util.HashMap;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

final class MenuLCAUtil {
    private static final String TYPE = "rwt.widgets.Menu";
    private static final String[] ALLOWED_STYLES = new String[]{"BAR", "DROP_DOWN", "POP_UP", "NO_RADIO_GROUP"};
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_MENU_LISTENER = "menu";
    private static final String METHOD_UNHIDE_ITEMS = "unhideItems";

    MenuLCAUtil() {
    }

    static void preserveValues(Menu menu) {
        WidgetLCAUtil.preserveCustomVariant(menu);
        WidgetLCAUtil.preserveProperty((Widget)menu, PROP_ENABLED, menu.getEnabled());
        WidgetLCAUtil.preserveListener(menu, PROP_MENU_LISTENER, MenuLCAUtil.hasMenuListener(menu));
        WidgetLCAUtil.preserveHelpListener(menu);
    }

    static void renderInitialization(Menu menu) {
        IClientObject clientObject = ClientObjectFactory.getClientObject(menu);
        clientObject.create(TYPE);
        clientObject.set("style", WidgetLCAUtil.getStyles(menu, ALLOWED_STYLES));
    }

    static void renderChanges(Menu menu) {
        WidgetLCAUtil.renderCustomVariant(menu);
        WidgetLCAUtil.renderProperty((Widget)menu, PROP_ENABLED, menu.getEnabled(), true);
        WidgetLCAUtil.renderListener(menu, PROP_MENU_LISTENER, MenuLCAUtil.hasMenuListener(menu), false);
        WidgetLCAUtil.renderListenHelp(menu);
    }

    public static void readMenuEvent(Menu menu) {
        MenuEvent event;
        if (WidgetLCAUtil.wasEventSent(menu, "org.eclipse.swt.events.menuShown")) {
            event = new MenuEvent(menu, 22);
            event.processEvent();
        }
        if (WidgetLCAUtil.wasEventSent(menu, "org.eclipse.swt.events.menuHidden")) {
            event = new MenuEvent(menu, 23);
            event.processEvent();
        }
    }

    static void renderUnhideItems(Menu menu) {
        if (WidgetLCAUtil.wasEventSent(menu, "org.eclipse.swt.events.menuShown")) {
            Boolean reveal = menu.getItemCount() > 0;
            IClientObject clientObject = ClientObjectFactory.getClientObject(menu);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("reveal", reveal);
            clientObject.call(METHOD_UNHIDE_ITEMS, args);
        }
    }

    private static boolean hasMenuListener(Menu menu) {
        boolean result = MenuEvent.hasListener(menu);
        if (!result) {
            MenuItem[] items = menu.getItems();
            int i = 0;
            while (i < items.length && !result) {
                result = ArmEvent.hasListener(items[i]);
                ++i;
            }
        }
        return result;
    }
}

