/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.shellkit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.ActivateEvent;
import org.eclipse.swt.internal.widgets.EventUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class ShellLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Shell";
    private static final String[] ALLOWED_STYLES = new String[]{"CLOSE", "MIN", "MAX", "NO_TRIM", "RESIZE", "TITLE", "ON_TOP", "TOOL", "SHEET", "APPLICATION_MODAL", "MODELESS", "PRIMARY_MODAL", "SYSTEM_MODAL", "BORDER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_ALPHA = "alpha";
    static final String PROP_ACTIVE_CONTROL = "activeControl";
    static final String PROP_ACTIVE_SHELL = "activeShell";
    static final String PROP_MODE = "mode";
    static final String PROP_FULLSCREEN = "fullScreen";
    static final String PROP_MINIMUM_SIZE = "minimumSize";
    static final String PROP_SHELL_LISTENER = "shell";
    private static final String PROP_DEFAULT_BUTTON = "defaultButton";

    public void preserveValues(Widget widget) {
        Shell shell = (Shell)widget;
        ControlLCAUtil.preserveValues(shell);
        WidgetLCAUtil.preserveCustomVariant(shell);
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_ACTIVE_CONTROL, ShellLCA.getActiveControl(shell));
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_ACTIVE_SHELL, shell.getDisplay().getActiveShell());
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_TEXT, shell.getText());
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_IMAGE, shell.getImage());
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_ALPHA, new Integer(shell.getAlpha()));
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_MODE, ShellLCA.getMode(shell));
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_FULLSCREEN, (Object)shell.getFullScreen());
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_MINIMUM_SIZE, shell.getMinimumSize());
        WidgetLCAUtil.preserveProperty((Widget)shell, PROP_DEFAULT_BUTTON, shell.getDefaultButton());
        WidgetLCAUtil.preserveListener(shell, PROP_SHELL_LISTENER, ShellEvent.hasListener(shell));
    }

    public void readData(Widget widget) {
        Shell shell = (Shell)widget;
        ShellLCA.preserveMenuBounds(shell);
        ShellLCA.readMode(shell);
        ShellLCA.readBounds(shell);
        if (WidgetLCAUtil.wasEventSent(shell, "org.eclipse.swt.widgets.Shell_close")) {
            shell.close();
        }
        ShellLCA.processActiveShell(shell);
        ShellLCA.processActivate(shell);
        ControlLCAUtil.processMouseEvents(shell);
        ControlLCAUtil.processKeyEvents(shell);
        ControlLCAUtil.processMenuDetect(shell);
        WidgetLCAUtil.processHelp(shell);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Shell shell = (Shell)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(shell);
        clientObject.create(TYPE);
        clientObject.set("style", WidgetLCAUtil.getStyles(shell, ALLOWED_STYLES));
        Composite parent = shell.getParent();
        if (parent instanceof Shell) {
            clientObject.set("parentShell", WidgetUtil.getId(parent));
        }
    }

    public void renderChanges(Widget widget) throws IOException {
        Shell shell = (Shell)widget;
        WidgetLCAUtil.renderCustomVariant(shell);
        ShellLCA.renderImage(shell);
        ShellLCA.renderText(shell);
        this.renderAlpha(shell);
        ShellLCA.renderActiveShell(shell);
        ShellLCA.renderMode(shell);
        ShellLCA.renderMinimumSize(shell);
        ShellLCA.renderDefaultButton(shell);
        ShellLCA.renderActiveControl(shell);
        ControlLCAUtil.renderChanges(shell);
        ShellLCA.renderListenShell(shell);
    }

    public void renderDispose(Widget widget) throws IOException {
        IClientObject clientObject = ClientObjectFactory.getClientObject(widget);
        clientObject.destroy();
    }

    private static void renderText(Shell shell) {
        WidgetLCAUtil.renderProperty((Widget)shell, PROP_TEXT, shell.getText(), "");
    }

    private void renderAlpha(Shell shell) {
        WidgetLCAUtil.renderProperty((Widget)shell, PROP_ALPHA, new Integer(shell.getAlpha()), new Integer(255));
    }

    private static void renderMinimumSize(Shell shell) {
        Point newValue = shell.getMinimumSize();
        if (WidgetLCAUtil.hasChanged(shell, PROP_MINIMUM_SIZE, newValue)) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(shell);
            clientObject.set(PROP_MINIMUM_SIZE, new int[]{newValue.x, newValue.y});
        }
    }

    private static void renderDefaultButton(Shell shell) {
        Button defaultButton = shell.getDefaultButton();
        if (WidgetLCAUtil.hasChanged(shell, PROP_DEFAULT_BUTTON, defaultButton, null)) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(shell);
            String defaultButtonId = null;
            if (defaultButton != null) {
                defaultButtonId = WidgetUtil.getId(defaultButton);
            }
            clientObject.set(PROP_DEFAULT_BUTTON, defaultButtonId);
        }
    }

    private static void renderActiveShell(Shell shell) {
        Shell activeShell = shell.getDisplay().getActiveShell();
        boolean hasChanged = WidgetLCAUtil.hasChanged(shell, PROP_ACTIVE_SHELL, activeShell, null);
        if (shell == activeShell && hasChanged) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(shell);
            clientObject.set("active", true);
        }
    }

    private static void processActiveShell(Shell shell) {
        if (WidgetLCAUtil.wasEventSent(shell, "org.eclipse.swt.events.shellActivated")) {
            ActivateEvent event;
            Shell lastActiveShell = shell.getDisplay().getActiveShell();
            ShellLCA.setActiveShell(shell);
            if (lastActiveShell != null) {
                event = new ActivateEvent(lastActiveShell, 27);
                event.processEvent();
            }
            event = new ActivateEvent(shell, 26);
            event.processEvent();
        }
    }

    private static void setActiveShell(Shell shell) {
        IDisplayAdapter adapter;
        IDisplayAdapter displayAdapter = adapter = shell.getDisplay().getAdapter(IDisplayAdapter.class);
        displayAdapter.setActiveShell(shell);
    }

    private static void renderActiveControl(Shell shell) {
        String prop = PROP_ACTIVE_CONTROL;
        Control activeControl = ShellLCA.getActiveControl(shell);
        if (WidgetLCAUtil.hasChanged(shell, prop, activeControl, null)) {
            String activeControlId = null;
            if (activeControl != null) {
                activeControlId = WidgetUtil.getId(activeControl);
            }
            IClientObject clientObject = ClientObjectFactory.getClientObject(shell);
            clientObject.set(PROP_ACTIVE_CONTROL, activeControlId);
        }
    }

    private static void processActivate(Shell shell) {
        HttpServletRequest request = ContextProvider.getRequest();
        String widgetId = request.getParameter("org.eclipse.swt.events.controlActivated");
        if (widgetId != null) {
            Widget widget = WidgetUtil.find(shell, widgetId);
            if (widget != null) {
                ShellLCA.setActiveControl(shell, widget);
            }
        } else {
            String activeControlId = WidgetLCAUtil.readPropertyValue(shell, PROP_ACTIVE_CONTROL);
            Widget widget = WidgetUtil.find(shell, activeControlId);
            if (widget != null) {
                ShellLCA.setActiveControl(shell, widget);
            }
        }
    }

    private static Control getActiveControl(Shell shell) {
        IShellAdapter adapter;
        IShellAdapter shellAdapter = adapter = shell.getAdapter(IShellAdapter.class);
        Control activeControl = shellAdapter.getActiveControl();
        return activeControl;
    }

    private static void setActiveControl(Shell shell, Widget widget) {
        if (EventUtil.isAccessible(widget)) {
            IShellAdapter adapter;
            IShellAdapter shellAdapter = adapter = shell.getAdapter(IShellAdapter.class);
            shellAdapter.setActiveControl((Control)widget);
        }
    }

    private static void renderImage(Shell shell) {
        if ((shell.getStyle() & 0x20) != 0) {
            Image[] defaultImages;
            Image image = shell.getImage();
            if (image == null && (defaultImages = shell.getImages()).length > 0) {
                image = defaultImages[0];
            }
            WidgetLCAUtil.renderProperty((Widget)shell, PROP_IMAGE, image, null);
        }
    }

    private static void readBounds(Shell shell) {
        IShellAdapter adapter;
        Rectangle bounds = WidgetLCAUtil.readBounds(shell, shell.getBounds());
        IShellAdapter shellAdapter = adapter = shell.getAdapter(IShellAdapter.class);
        shellAdapter.setBounds(bounds);
    }

    private static void readMode(Shell shell) {
        String value = WidgetLCAUtil.readPropertyValue(shell, PROP_MODE);
        if (value != null) {
            if ("maximized".equals(value)) {
                shell.setMaximized(true);
            } else if ("minimized".equals(value)) {
                shell.setMinimized(true);
            } else {
                shell.setMinimized(false);
                shell.setMaximized(false);
            }
        }
    }

    private static void renderMode(Shell shell) {
        Object defValue = null;
        String newValue = ShellLCA.getMode(shell);
        if (WidgetLCAUtil.hasChanged(shell, PROP_MODE, newValue, defValue)) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(shell);
            clientObject.set(PROP_MODE, (Object)newValue);
        }
    }

    private static void renderListenShell(Shell shell) {
        boolean newValue = ShellEvent.hasListener(shell);
        WidgetLCAUtil.renderListener(shell, PROP_SHELL_LISTENER, newValue, false);
    }

    private static String getMode(Shell shell) {
        String result = null;
        if (shell.getMinimized()) {
            result = "minimized";
        } else if (shell.getFullScreen()) {
            result = "fullscreen";
        } else if (shell.getMaximized()) {
            result = "maximized";
        }
        return result;
    }

    private static void preserveMenuBounds(Shell shell) {
        Menu menuBar = shell.getMenuBar();
        if (menuBar != null) {
            IShellAdapter shellAdapter = shell.getAdapter(IShellAdapter.class);
            Rectangle menuBounds = shellAdapter.getMenuBounds();
            IWidgetAdapter widgetAdapter = WidgetUtil.getAdapter(menuBar);
            widgetAdapter.preserve("bounds", menuBounds);
        }
    }
}

