/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.textkit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.textkit.AbstractTextDelegateLCA;
import org.eclipse.swt.internal.widgets.textkit.TextLCAUtil;
import org.eclipse.swt.widgets.Text;

final class SingleTextLCA
extends AbstractTextDelegateLCA {
    SingleTextLCA() {
    }

    void preserveValues(Text text) {
        TextLCAUtil.preserveValues(text);
    }

    void readData(Text text) {
        TextLCAUtil.readTextAndSelection(text);
        SingleTextLCA.processSelection(text);
        ControlLCAUtil.processMouseEvents(text);
        ControlLCAUtil.processKeyEvents(text);
        ControlLCAUtil.processMenuDetect(text);
        WidgetLCAUtil.processHelp(text);
    }

    void renderInitialization(Text text) throws IOException {
        TextLCAUtil.renderInitialization(text);
    }

    void renderChanges(Text text) throws IOException {
        TextLCAUtil.renderChanges(text);
    }

    private static void processSelection(Text text) {
        if (WidgetLCAUtil.wasEventSent(text, "org.eclipse.swt.events.widgetSelected")) {
            SingleTextLCA.createSelectionEvent(text, 13).processEvent();
        }
        if (WidgetLCAUtil.wasEventSent(text, "org.eclipse.swt.events.widgetDefaultSelected")) {
            SingleTextLCA.createSelectionEvent(text, 14).processEvent();
        }
    }

    private static SelectionEvent createSelectionEvent(Text text, int type) {
        SelectionEvent result = new SelectionEvent(text, null, type);
        result.detail = SingleTextLCA.getWidgetSelectedDetail();
        result.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
        return result;
    }

    private static int getWidgetSelectedDetail() {
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter("org.eclipse.swt.events.widgetSelected.detail");
        int result = 0;
        if ("search".equals(value)) {
            result = 512;
        } else if ("cancel".equals(value)) {
            result = 256;
        }
        return result;
    }
}

