/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.theme.JsonArray;
import org.eclipse.rap.rwt.internal.theme.JsonObject;
import org.eclipse.rap.rwt.internal.theme.JsonValue;
import org.eclipse.rap.rwt.internal.theme.QxAnimation;
import org.eclipse.rap.rwt.internal.theme.QxBoolean;
import org.eclipse.rap.rwt.internal.theme.QxBorder;
import org.eclipse.rap.rwt.internal.theme.QxBoxDimensions;
import org.eclipse.rap.rwt.internal.theme.QxColor;
import org.eclipse.rap.rwt.internal.theme.QxCursor;
import org.eclipse.rap.rwt.internal.theme.QxDimension;
import org.eclipse.rap.rwt.internal.theme.QxFloat;
import org.eclipse.rap.rwt.internal.theme.QxFont;
import org.eclipse.rap.rwt.internal.theme.QxIdentifier;
import org.eclipse.rap.rwt.internal.theme.QxImage;
import org.eclipse.rap.rwt.internal.theme.QxShadow;
import org.eclipse.rap.rwt.internal.theme.QxType;

public final class ThemePropertyAdapterRegistry {
    private static final Object LOCK = new Object();
    private static final String ATTR_NAME = String.valueOf(ThemePropertyAdapterRegistry.class.getName()) + "#instance";
    private final Map<Class<? extends QxType>, ThemePropertyAdapter> map = new HashMap<Class<? extends QxType>, ThemePropertyAdapter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThemePropertyAdapterRegistry getInstance() {
        ThemePropertyAdapterRegistry result;
        Object object = LOCK;
        synchronized (object) {
            result = (ThemePropertyAdapterRegistry)RWT.getApplicationStore().getAttribute(ATTR_NAME);
            if (result == null) {
                result = new ThemePropertyAdapterRegistry();
                RWT.getApplicationStore().setAttribute(ATTR_NAME, result);
            }
        }
        return result;
    }

    private ThemePropertyAdapterRegistry() {
        this.map.put(QxAnimation.class, new AnimationPropertyAdapter());
        this.map.put(QxBoolean.class, new DirectPropertyAdapter());
        this.map.put(QxBorder.class, new BorderPropertyAdapter());
        this.map.put(QxBoxDimensions.class, new BoxDimensionsPropertyAdapter());
        this.map.put(QxColor.class, new ColorPropertyAdapter());
        this.map.put(QxCursor.class, new CursorPropertyAdapter());
        this.map.put(QxDimension.class, new DimensionPropertyAdapter());
        this.map.put(QxFloat.class, new DirectPropertyAdapter());
        this.map.put(QxFont.class, new FontPropertyAdapter());
        this.map.put(QxIdentifier.class, new DirectPropertyAdapter());
        this.map.put(QxImage.class, new ImagePropertyAdapter());
        this.map.put(QxShadow.class, new ShadowPropertyAdapter());
    }

    public ThemePropertyAdapter getPropertyAdapter(Class key) {
        return this.map.get(key);
    }

    public static class AnimationPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "animations";
        }

        public JsonValue getValue(QxType value) {
            QxAnimation animation = (QxAnimation)value;
            JsonObject result = new JsonObject();
            int j = 0;
            while (j < animation.animations.length) {
                QxAnimation.Animation currentAnimation = animation.animations[j];
                JsonArray currentAnimationArray = new JsonArray();
                currentAnimationArray.append(currentAnimation.duration);
                String timingFunction = QxAnimation.toCamelCaseString(currentAnimation.timingFunction);
                currentAnimationArray.append(timingFunction);
                result.append(currentAnimation.name, currentAnimationArray);
                ++j;
            }
            return result;
        }
    }

    public static class BorderPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "borders";
        }

        public JsonValue getValue(QxType value) {
            QxBorder border = (QxBorder)value;
            JsonObject result = new JsonObject();
            result.append("width", border.width);
            result.append("style", border.style);
            result.append("color", border.color);
            return result;
        }
    }

    public static class BoxDimensionsPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "boxdims";
        }

        public JsonValue getValue(QxType value) {
            QxBoxDimensions boxdim = (QxBoxDimensions)value;
            JsonArray result = new JsonArray();
            result.append(boxdim.top);
            result.append(boxdim.right);
            result.append(boxdim.bottom);
            result.append(boxdim.left);
            return result;
        }
    }

    public static class ColorPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "colors";
        }

        public JsonValue getValue(QxType value) {
            QxColor color = (QxColor)value;
            JsonValue result = color.isTransparent() ? JsonValue.valueOf("undefined") : JsonValue.valueOf(QxColor.toHtmlString(color.red, color.green, color.blue));
            return result;
        }
    }

    public static class CursorPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "cursors";
        }

        public JsonValue getValue(QxType value) {
            QxCursor cursor = (QxCursor)value;
            JsonValue result = cursor.isCustomCursor() ? JsonValue.NULL : JsonValue.valueOf(cursor.value);
            return result;
        }
    }

    public static class DimensionPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "dimensions";
        }

        public JsonValue getValue(QxType value) {
            return JsonValue.valueOf(((QxDimension)value).value);
        }
    }

    public static class DirectPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return value.toDefaultString();
        }

        public String getSlot(QxType value) {
            return null;
        }

        public JsonValue getValue(QxType value) {
            return null;
        }
    }

    public static class FontPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "fonts";
        }

        public JsonValue getValue(QxType value) {
            QxFont font = (QxFont)value;
            JsonObject result = new JsonObject();
            result.append("family", JsonArray.valueOf(font.family));
            result.append("size", font.size);
            result.append("bold", font.bold);
            result.append("italic", font.italic);
            return result;
        }
    }

    public static class ImagePropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            QxImage image = (QxImage)value;
            String result = image.isGradient() ? "gradients" : "images";
            return result;
        }

        public JsonValue getValue(QxType value) {
            QxImage image = (QxImage)value;
            JsonValue result = null;
            if (image.isGradient()) {
                JsonObject gradientObject = null;
                gradientObject = new JsonObject();
                JsonArray percents = JsonArray.valueOf(image.gradientPercents);
                gradientObject.append("percents", percents);
                JsonArray colors = JsonArray.valueOf(image.gradientColors);
                gradientObject.append("colors", colors);
                gradientObject.append("vertical", image.vertical);
                result = gradientObject;
            } else if (!image.none) {
                JsonArray imageArray = new JsonArray();
                imageArray.append(image.width);
                imageArray.append(image.height);
                result = imageArray;
            }
            return result;
        }
    }

    public static class ShadowPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "shadows";
        }

        public JsonValue getValue(QxType value) {
            JsonValue result;
            QxShadow shadow = (QxShadow)value;
            if (shadow.equals(QxShadow.NONE)) {
                result = JsonValue.NULL;
            } else {
                JsonArray array = new JsonArray();
                array.append(shadow.inset);
                array.append(shadow.offsetX);
                array.append(shadow.offsetY);
                array.append(shadow.blur);
                array.append(shadow.spread);
                array.append(shadow.color);
                array.append(shadow.opacity);
                result = array;
            }
            return result;
        }
    }

    public static interface ThemePropertyAdapter {
        public String getSlot(QxType var1);

        public String getKey(QxType var1);

        public JsonValue getValue(QxType var1);
    }
}

