/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.buttonkit;

import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;

final class ButtonLCAUtil {
    private static final String TYPE = "rwt.widgets.Button";
    private static final String[] ALLOWED_STYLES = new String[]{"ARROW", "CHECK", "PUSH", "RADIO", "TOGGLE", "FLAT", "WRAP", "BORDER"};
    static final String PROP_TEXT = "text";
    static final String PROP_IMAGE = "image";
    static final String PROP_SELECTION = "selection";
    static final String PROP_GRAYED = "grayed";
    static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_SELECTION_LISTENERS = "selection";
    private static final String PARAM_SELECTION = "selection";
    private static final String DEFAULT_ALIGNMENT = "center";

    private ButtonLCAUtil() {
    }

    static void preserveValues(Button button) {
        ControlLCAUtil.preserveValues(button);
        WidgetLCAUtil.preserveCustomVariant(button);
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_TEXT, button.getText());
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_IMAGE, button.getImage());
        WidgetLCAUtil.preserveProperty((Widget)button, "selection", (Object)button.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_GRAYED, (Object)button.getGrayed());
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_ALIGNMENT, ButtonLCAUtil.getAlignment(button));
        WidgetLCAUtil.preserveListener(button, "selection", SelectionEvent.hasListener(button));
    }

    static void renderInitialization(Button button) {
        IClientObject clientObject = ClientObjectFactory.getClientObject(button);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(button.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(button, ALLOWED_STYLES));
    }

    static void renderChanges(Button button) {
        ControlLCAUtil.renderChanges(button);
        WidgetLCAUtil.renderCustomVariant(button);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_TEXT, button.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)button, PROP_IMAGE, button.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_ALIGNMENT, ButtonLCAUtil.getAlignment(button), DEFAULT_ALIGNMENT);
        WidgetLCAUtil.renderProperty((Widget)button, "selection", button.getSelection(), false);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_GRAYED, button.getGrayed(), false);
        WidgetLCAUtil.renderListener(button, "selection", SelectionEvent.hasListener(button), false);
    }

    static boolean readSelection(Button button) {
        String value = WidgetLCAUtil.readPropertyValue(button, "selection");
        if (value != null) {
            button.setSelection(Boolean.valueOf(value));
        }
        return value != null;
    }

    private static String getAlignment(Button button) {
        int alignment = button.getAlignment();
        String result = (alignment & 0x4000) != 0 ? "left" : ((alignment & 0x1000000) != 0 ? DEFAULT_ALIGNMENT : ((alignment & 0x20000) != 0 ? "right" : ((alignment & 0x80) != 0 ? "up" : ((alignment & 0x400) != 0 ? "down" : "left"))));
        return result;
    }
}

