/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.linkkit;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ILinkAdapter;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class LinkLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Link";
    private static final String[] ALLOWED_STYLES = new String[]{"BORDER"};
    static final String PROP_TEXT = "text";
    static final String PROP_SELECTION_LISTENER = "selection";

    public void preserveValues(Widget widget) {
        Link link = (Link)widget;
        ControlLCAUtil.preserveValues(link);
        WidgetLCAUtil.preserveCustomVariant(link);
        WidgetLCAUtil.preserveProperty((Widget)link, PROP_TEXT, link.getText());
        WidgetLCAUtil.preserveListener(link, PROP_SELECTION_LISTENER, SelectionEvent.hasListener(link));
    }

    public void readData(Widget widget) {
        Link link = (Link)widget;
        LinkLCA.processSelectionEvent(link);
        ControlLCAUtil.processMouseEvents(link);
        ControlLCAUtil.processKeyEvents(link);
        ControlLCAUtil.processMenuDetect(link);
        WidgetLCAUtil.processHelp(link);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Link link = (Link)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(link);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(link.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(link, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        Link link = (Link)widget;
        ControlLCAUtil.renderChanges(link);
        WidgetLCAUtil.renderCustomVariant(link);
        LinkLCA.renderText(link);
        WidgetLCAUtil.renderListener(link, PROP_SELECTION_LISTENER, SelectionEvent.hasListener(link), false);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    private static void renderText(Link link) {
        String newValue = link.getText();
        if (WidgetLCAUtil.hasChanged(link, PROP_TEXT, newValue, "")) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(link);
            clientObject.set(PROP_TEXT, LinkLCA.getTextObject(link));
        }
    }

    private static Object getTextObject(Link link) {
        ILinkAdapter adapter = link.getAdapter(ILinkAdapter.class);
        String displayText = adapter.getDisplayText();
        Point[] offsets = adapter.getOffsets();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int length = displayText.length();
        int pos = 0;
        int i = 0;
        while (i < offsets.length) {
            int start = offsets[i].x;
            int end = offsets[i].y + 1;
            if (pos < start) {
                Object[] objectArray = new Object[2];
                objectArray[0] = displayText.substring(pos, start);
                result.add(objectArray);
            }
            if (start < end) {
                result.add(new Object[]{displayText.substring(start, end), new Integer(i)});
            }
            pos = end;
            ++i;
        }
        if (pos < length) {
            Object[] objectArray = new Object[2];
            objectArray[0] = displayText.substring(pos, length);
            result.add(objectArray);
        }
        return result.toArray();
    }

    private static void processSelectionEvent(Link link) {
        ILinkAdapter adapter;
        String[] ids;
        HttpServletRequest request;
        String indexStr;
        int index;
        String eventId = "org.eclipse.swt.events.widgetSelected";
        if (WidgetLCAUtil.wasEventSent(link, eventId) && (index = NumberFormatUtil.parseInt(indexStr = (request = ContextProvider.getRequest()).getParameter("org.eclipse.swt.events.widgetSelected.index"))) < (ids = (adapter = link.getAdapter(ILinkAdapter.class)).getIds()).length) {
            SelectionEvent event = new SelectionEvent(link, null, 13);
            event.text = ids[index];
            event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            event.processEvent();
        }
    }
}

