/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tabitemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class TabItemLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.TabItem";
    private static final String PROP_CONTROL = "control";

    public void preserveValues(Widget widget) {
        TabItem item = (TabItem)widget;
        WidgetLCAUtil.preserveCustomVariant(item);
        WidgetLCAUtil.preserveToolTipText(item, item.getToolTipText());
        ItemLCAUtil.preserve(item);
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_CONTROL, item.getControl());
    }

    public void readData(Widget widget) {
        final TabItem item = (TabItem)widget;
        if (WidgetLCAUtil.wasEventSent(item, "org.eclipse.swt.events.widgetSelected.item")) {
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    TabFolder folder = item.getParent();
                    folder.setSelection(item);
                    ControlLCAUtil.processSelection(folder, item, false);
                }
            });
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        TabItem tabItem = (TabItem)widget;
        TabFolder parent = tabItem.getParent();
        IClientObject clientObject = ClientObjectFactory.getClientObject(tabItem);
        clientObject.create(TYPE);
        clientObject.set("id", WidgetUtil.getId(tabItem));
        clientObject.set("parent", WidgetUtil.getId(parent));
        clientObject.set("index", parent.indexOf(tabItem));
    }

    public void renderChanges(Widget widget) throws IOException {
        TabItem tabItem = (TabItem)widget;
        WidgetLCAUtil.renderCustomVariant(tabItem);
        WidgetLCAUtil.renderToolTip(tabItem, tabItem.getToolTipText());
        ItemLCAUtil.renderChanges(tabItem);
        WidgetLCAUtil.renderProperty((Widget)tabItem, PROP_CONTROL, tabItem.getControl(), null);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }
}

