/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.internal.application.RWTFactory;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.protocol.IClientObjectAdapter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServletLog;
import org.eclipse.rap.rwt.internal.theme.QxColor;
import org.eclipse.rap.rwt.internal.theme.QxImage;
import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.rap.rwt.internal.theme.SimpleSelector;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.internal.uicallback.UICallBackManager;
import org.eclipse.rap.rwt.internal.util.SerializableLock;
import org.eclipse.rap.rwt.lifecycle.ILifeCycleAdapter;
import org.eclipse.rap.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.UICallBack;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.service.ISessionStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TimerExecScheduler;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Display
extends Device
implements Adaptable {
    private static final IDisplayAdapter.IFilterEntry[] EMPTY_FILTERS = new IDisplayAdapter.IFilterEntry[0];
    private static final String AVAILABLE_WIDTH = "w1.bounds.width";
    private static final String AVAILABLE_HEIGHT = "w1.bounds.height";
    private static final String ATTR_INVALIDATE_FOCUS = String.valueOf(DisplayAdapter.class.getName()) + "#invalidateFocus";
    private static final String APP_NAME = String.valueOf(Display.class.getName()) + "#appName";
    private static final String APP_VERSION = String.valueOf(Display.class.getName()) + "#appVersion";
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    private static final int DOUBLE_CLICK_TIME = 500;
    private static final int GROW_SIZE = 1024;
    private final List<Shell> shells;
    private transient Thread thread;
    private final ISessionStore sessionStore;
    private final Rectangle bounds;
    private final Point cursorLocation;
    private Shell activeShell;
    private List<FilterEntry> filters;
    private Collection<Control> redrawControls;
    private Control focusControl;
    private transient Monitor monitor;
    private transient IDisplayAdapter displayAdapter;
    private WidgetAdapter widgetAdapter;
    private Set<Listener> closeListeners;
    private Set<Listener> disposeListeners;
    private Runnable[] disposeList;
    private Composite[] layoutDeferred;
    private int layoutDeferredCount;
    private Widget[] skinList;
    private int skinCount;
    private Set<Listener> skinListeners;
    private boolean beep;
    private Object data;
    private String[] keys;
    private Object[] values;
    private Synchronizer synchronizer;
    private TimerExecScheduler scheduler;

    public static Display getCurrent() {
        Display result = LifeCycleUtil.getSessionDisplay();
        if (result != null && (result.isDisposed() || result.getThread() != Thread.currentThread())) {
            result = null;
        }
        return result;
    }

    public static Display getDefault() {
        Display display = LifeCycleUtil.getSessionDisplay();
        if ((display == null || display.isDisposed()) && Display.isUIThread()) {
            display = new Display();
        }
        return display;
    }

    private static boolean isUIThread() {
        boolean result = false;
        if (ContextProvider.hasContext()) {
            IUIThreadHolder uiThreadHolder = LifeCycleUtil.getUIThread(ContextProvider.getSessionStore());
            Thread uiThread = uiThreadHolder == null ? null : uiThreadHolder.getThread();
            result = uiThread == Thread.currentThread();
        }
        return result;
    }

    public Display() {
        if (Display.getCurrent() != null) {
            SWT.error(20, null, " [multiple displays]");
        }
        LifeCycleUtil.setSessionDisplay(this);
        this.attachThread();
        this.sessionStore = ContextProvider.getSessionStore();
        this.shells = new ArrayList<Shell>();
        this.monitor = new Monitor(this);
        this.cursorLocation = new Point(0, 0);
        this.bounds = this.readInitialBounds();
        this.synchronizer = new Synchronizer(this);
        this.register();
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public Control getFocusControl() {
        this.checkDevice();
        return this.focusControl;
    }

    private void setFocusControl(Control focusControl) {
        if (this.focusControl != focusControl) {
            FocusEvent event;
            Shell shell;
            Control currentFocusControl;
            if (this.focusControl != null && !this.focusControl.isInDispose()) {
                currentFocusControl = this.focusControl;
                shell = currentFocusControl.getShell();
                event = new FocusEvent(currentFocusControl, 16);
                event.processEvent();
                shell.updateDefaultButton(currentFocusControl, false);
            }
            this.focusControl = focusControl;
            if (this.focusControl != null) {
                currentFocusControl = this.focusControl;
                shell = currentFocusControl.getShell();
                event = new FocusEvent(currentFocusControl, 15);
                event.processEvent();
                shell.updateDefaultButton(currentFocusControl, true);
            }
        }
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            SWT.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        this.checkDevice();
        Rectangle rectangle = this.map(from, to, x, y, 0, 0);
        return new Point(rectangle.x, rectangle.y);
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        this.checkDevice();
        int newX = x;
        int newY = y;
        if (from != null) {
            Point fromOrigin = Display.getAbsoluteOrigin(from);
            newX += fromOrigin.x;
            newY += fromOrigin.y;
        }
        if (to != null) {
            Point toOrigin = Display.getAbsoluteOrigin(to);
            newX -= toOrigin.x;
            newY -= toOrigin.y;
        }
        return new Rectangle(newX, newY, width, height);
    }

    private static Point getAbsoluteOrigin(Control control) {
        Control currentControl = control;
        Point absolute = new Point(0, 0);
        while (currentControl != null) {
            Point origin = Display.getOrigin(currentControl);
            absolute.x += origin.x;
            absolute.y += origin.y;
            currentControl = currentControl instanceof Shell ? null : currentControl.getParent();
        }
        return new Point(absolute.x, absolute.y);
    }

    private static Point getOrigin(Control control) {
        Point result = control.getLocation();
        if (control instanceof Composite) {
            int borderWidth = control.getBorderWidth();
            result.x += borderWidth;
            result.y += borderWidth;
        }
        return result;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (eventType == 21) {
            if (this.closeListeners == null) {
                this.closeListeners = new HashSet<Listener>();
            }
            this.closeListeners.add(listener);
        } else if (eventType == 12) {
            if (this.disposeListeners == null) {
                this.disposeListeners = new HashSet<Listener>();
            }
            this.disposeListeners.add(listener);
        } else if (eventType == 45) {
            if (this.skinListeners == null) {
                this.skinListeners = new HashSet<Listener>();
            }
            this.skinListeners.add(listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (eventType == 21 && this.closeListeners != null) {
            this.closeListeners.remove(listener);
            if (this.closeListeners.size() == 0) {
                this.closeListeners = null;
            }
        } else if (eventType == 12 && this.disposeListeners != null) {
            this.disposeListeners.remove(listener);
            if (this.disposeListeners.size() == 0) {
                this.disposeListeners = null;
            }
        } else if (eventType == 45 && this.skinListeners != null) {
            this.skinListeners.remove(listener);
            if (this.skinListeners.size() == 0) {
                this.skinListeners = null;
            }
        }
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        event.display = this;
        event.type = 21;
        this.notifyFilters(event);
        if (this.closeListeners != null) {
            Listener[] listeners = new Listener[this.closeListeners.size()];
            this.closeListeners.toArray(listeners);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleEvent(event);
                ++i;
            }
        }
        if (event.doit) {
            this.dispose();
        }
    }

    @Override
    protected void release() {
        this.sendDisposeEvent();
        this.disposeShells();
        this.runDisposeExecs();
        this.synchronizer.releaseSynchronizer();
        if (this.scheduler != null) {
            this.scheduler.dispose();
        }
    }

    @Override
    protected void destroy() {
        this.deregister();
    }

    private void sendDisposeEvent() {
        Event event = new Event();
        event.display = this;
        event.type = 12;
        this.notifyFilters(event);
        if (this.disposeListeners != null) {
            Listener[] listeners = new Listener[this.disposeListeners.size()];
            this.disposeListeners.toArray(listeners);
            int i = 0;
            while (i < listeners.length) {
                try {
                    listeners[i].handleEvent(event);
                }
                catch (Throwable thr) {
                    String msg = "Exception while executing dispose-listener.";
                    ServletLog.log(msg, thr);
                }
                ++i;
            }
        }
    }

    private void disposeShells() {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            try {
                shell.dispose();
            }
            catch (Throwable thr) {
                ServletLog.log("Exception while disposing shell: " + shell, thr);
            }
            ++i;
        }
    }

    private void runDisposeExecs() {
        if (this.disposeList != null) {
            int i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    try {
                        this.disposeList[i].run();
                    }
                    catch (Throwable thr) {
                        String msg = "Exception while executing dispose-runnable.";
                        ServletLog.log(msg, thr);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IDisplayAdapter.class) {
            if (this.displayAdapter == null) {
                this.displayAdapter = new DisplayAdapter();
            }
            result = this.displayAdapter;
        } else if (adapter == IClientObjectAdapter.class || adapter == IWidgetAdapter.class) {
            if (this.widgetAdapter == null) {
                this.widgetAdapter = new WidgetAdapter("w1");
            }
            result = this.widgetAdapter;
        } else {
            result = adapter == ILifeCycleAdapter.class ? RWTFactory.getLifeCycleAdapterFactory().getAdapter(this) : RWTFactory.getAdapterManager().getAdapter(this, adapter);
        }
        return (T)result;
    }

    public Shell[] getShells() {
        this.checkDevice();
        Shell[] result = new Shell[this.shells.size()];
        this.shells.toArray(result);
        return result;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    final void setActiveShell(Shell activeShell) {
        this.checkDevice();
        if (this.activeShell != activeShell) {
            ShellEvent shellEvent;
            Shell lastActiveShell = this.activeShell;
            if (this.activeShell != null) {
                this.activeShell.saveFocus();
            }
            if (activeShell != null) {
                this.shells.remove(activeShell);
                this.shells.add(activeShell);
            }
            if (lastActiveShell != null && (lastActiveShell.state & 0x1000) == 0) {
                shellEvent = new ShellEvent(lastActiveShell, 27);
                shellEvent.processEvent();
            }
            this.activeShell = activeShell;
            if (activeShell != null) {
                shellEvent = new ShellEvent(activeShell, 26);
                shellEvent.processEvent();
            }
            if (this.activeShell != null) {
                this.activeShell.restoreFocus();
            }
        }
    }

    final void addShell(Shell shell) {
        this.shells.add(shell);
    }

    final void removeShell(Shell shell) {
        this.shells.remove(shell);
        if (shell == this.activeShell) {
            int counter = 0;
            Shell lastVisibleShell = null;
            while (lastVisibleShell == null && counter < this.shells.size()) {
                Shell currentShell = this.shells.get(this.shells.size() - ++counter);
                if (!currentShell.isVisible()) continue;
                lastVisibleShell = currentShell;
            }
            this.setActiveShell(lastVisibleShell);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        SerializableLock serializableLock = this.deviceLock;
        synchronized (serializableLock) {
            if (this.isDisposed()) {
                this.error(45);
            }
            return this.thread;
        }
    }

    private void attachThread() {
        this.thread = Thread.currentThread();
    }

    private void detachThread() {
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            WeakReference<Display>[] displays = Display.getDisplays();
            Display result = null;
            int i = 0;
            while (result == null && i < displays.length) {
                Display display;
                WeakReference<Display> current = displays[i];
                if (current != null && (display = (Display)current.get()) != null && !display.isDisposed() && display.thread == thread) {
                    result = display;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        Synchronizer oldSynchronizer;
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        SerializableLock serializableLock = this.deviceLock;
        synchronized (serializableLock) {
            oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
        }
        if (oldSynchronizer != null) {
            oldSynchronizer.runAsyncMessages(true);
        }
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        SerializableLock serializableLock = this.deviceLock;
        synchronized (serializableLock) {
            if (this.isDisposed()) {
                this.error(45);
            }
            return this.synchronizer.syncThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        SerializableLock serializableLock = this.deviceLock;
        synchronized (serializableLock) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Synchronizer synchronizer;
        SerializableLock serializableLock = this.deviceLock;
        synchronized (serializableLock) {
            if (this.isDisposed()) {
                this.error(45);
            }
            synchronizer = this.synchronizer;
        }
        synchronizer.syncExec(runnable);
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.scheduler == null) {
            this.scheduler = new TimerExecScheduler(this, UICallBackManager.getInstance());
        }
        if (milliseconds < 0) {
            this.scheduler.cancel(runnable);
        } else {
            this.scheduler.schedule(milliseconds, runnable);
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        return this.runPendingMessages();
    }

    private boolean runPendingMessages() {
        boolean result = false;
        if (PhaseId.PREPARE_UI_ROOT.equals(CurrentPhase.get()) || PhaseId.PROCESS_ACTION.equals(CurrentPhase.get())) {
            result = ProcessActionRunner.executeNext();
            if (!result) {
                result = TypedEvent.executeNext();
            }
            if (!result) {
                result = this.synchronizer.runAsyncMessages(false);
            }
            if (!result) {
                result = this.executeNextRedraw();
            }
        }
        return result;
    }

    public boolean sleep() {
        this.checkDevice();
        LifeCycle lifeCycle = (LifeCycle)RWTFactory.getLifeCycleFactory().getLifeCycle();
        lifeCycle.sleep();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        SerializableLock serializableLock = this.deviceLock;
        synchronized (serializableLock) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread != Thread.currentThread()) {
                UICallBack.runNonUIThreadWithFakeContext(this, new Runnable(){

                    public void run() {
                        Display.this.synchronizer.asyncExec(new WakeRunnable());
                    }
                });
            }
        }
    }

    protected void wakeThread() {
        UICallBack.runNonUIThreadWithFakeContext(this, new Runnable(){

            public void run() {
                UICallBackManager.getInstance().wakeClient();
            }
        });
    }

    Object getDeviceLock() {
        return this.deviceLock;
    }

    void redrawControl(Control control, boolean redraw) {
        if (redraw) {
            if (this.redrawControls == null) {
                this.redrawControls = new LinkedList<Control>();
            }
            if (!this.redrawControls.contains(control)) {
                this.redrawControls.add(control);
            }
        } else if (this.redrawControls != null) {
            this.redrawControls.remove(control);
        }
    }

    boolean needsRedraw(Control control) {
        return this.redrawControls != null && this.redrawControls.contains(control);
    }

    private boolean executeNextRedraw() {
        Iterator<Control> iterator;
        boolean result = false;
        if (this.redrawControls != null && (iterator = this.redrawControls.iterator()).hasNext()) {
            Control control = iterator.next();
            WidgetUtil.getLCA(control).doRedrawFake(control);
            this.redrawControls.remove(control);
            result = true;
        }
        return result;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        return null;
    }

    public Menu getMenuBar() {
        this.checkDevice();
        return null;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        return null;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        return null;
    }

    @Override
    public Color getSystemColor(int id) {
        this.checkDevice();
        Color result = null;
        QxType value = null;
        switch (id) {
            case 17: {
                value = ThemeUtil.getCssValue("Display", "rwt-darkshadow-color", SimpleSelector.DEFAULT);
                break;
            }
            case 18: {
                value = ThemeUtil.getCssValue("Display", "rwt-shadow-color", SimpleSelector.DEFAULT);
                break;
            }
            case 19: {
                value = ThemeUtil.getCssValue("Display", "rwt-lightshadow-color", SimpleSelector.DEFAULT);
                break;
            }
            case 20: {
                value = ThemeUtil.getCssValue("Display", "rwt-highlight-color", SimpleSelector.DEFAULT);
                break;
            }
            case 23: {
                value = ThemeUtil.getCssValue("Display", "rwt-thinborder-color", SimpleSelector.DEFAULT);
                break;
            }
            case 22: {
                value = ThemeUtil.getCssValue("NONE", "background-color", SimpleSelector.DEFAULT);
                break;
            }
            case 21: {
                value = ThemeUtil.getCssValue("NONE", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 24: {
                value = ThemeUtil.getCssValue("List", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 25: {
                value = ThemeUtil.getCssValue("List", "background-color", SimpleSelector.DEFAULT);
                break;
            }
            case 26: {
                value = ThemeUtil.getCssValue("List-Item", "background-color", SimpleSelector.SELECTED);
                break;
            }
            case 27: {
                value = ThemeUtil.getCssValue("List-Item", "color", SimpleSelector.SELECTED);
                break;
            }
            case 28: {
                value = ThemeUtil.getCssValue("Widget-ToolTip", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 29: {
                value = ThemeUtil.getCssValue("Display", "rwt-infobackground-color", SimpleSelector.DEFAULT);
                break;
            }
            case 30: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "color", SimpleSelector.DEFAULT);
                break;
            }
            case 33: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "color", SimpleSelector.INACTIVE);
                break;
            }
            case 31: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-color", SimpleSelector.DEFAULT);
                break;
            }
            case 34: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-color", SimpleSelector.INACTIVE);
                break;
            }
            case 32: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-gradient-color", SimpleSelector.DEFAULT);
                break;
            }
            case 35: {
                value = ThemeUtil.getCssValue("Shell-Titlebar", "background-gradient-color", SimpleSelector.INACTIVE);
                break;
            }
            default: {
                result = super.getSystemColor(id);
            }
        }
        if (value != null && (result = QxColor.createColor((QxColor)value)) == null) {
            throw new IllegalArgumentException("Transparent system color");
        }
        return result;
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        Image result = null;
        switch (id) {
            case 1: {
                result = Display.createSystemImage("rwt-error-image");
                break;
            }
            case 2: {
                result = Display.createSystemImage("rwt-information-image");
                break;
            }
            case 4: {
                result = Display.createSystemImage("rwt-question-image");
                break;
            }
            case 8: {
                result = Display.createSystemImage("rwt-warning-image");
                break;
            }
            case 16: {
                result = Display.createSystemImage("rwt-working-image");
            }
        }
        return result;
    }

    private static Image createSystemImage(String cssProperty) {
        Image result = null;
        QxType cssValue = ThemeUtil.getCssValue("Display", cssProperty, SimpleSelector.DEFAULT);
        if (cssValue != null) {
            try {
                result = QxImage.createSwtImage((QxImage)cssValue);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not read system image", ioe);
            }
        }
        return result;
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        return RWTFactory.getResourceFactory().getCursor(id);
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return 500;
    }

    public Control getCursorControl() {
        this.checkDevice();
        ControlFinder finder = new ControlFinder(this, this.getCursorLocation());
        return finder.getControl();
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public Point getCursorLocation() {
        this.checkDevice();
        return new Point(this.cursorLocation.x, this.cursorLocation.y);
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filters == null) {
            this.filters = new ArrayList<FilterEntry>();
        }
        this.filters.add(new FilterEntry(eventType, listener));
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        IDisplayAdapter.IFilterEntry[] entries = this.getFilterEntries();
        boolean found = false;
        int i = 0;
        while (!found && i < entries.length) {
            boolean bl = found = entries[i].getListener() == listener && entries[i].getType() == eventType;
            if (found) {
                this.filters.remove(entries[i]);
            }
            ++i;
        }
        if (this.filters != null && this.filters.isEmpty()) {
            this.filters = null;
        }
    }

    void addLayoutDeferred(Composite comp) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] temp = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, temp, 0, this.layoutDeferred.length);
            this.layoutDeferred = temp;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = comp;
    }

    boolean runDeferredLayouts() {
        boolean result = false;
        if (this.layoutDeferredCount != 0) {
            Composite[] temp = this.layoutDeferred;
            int count = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int i = 0;
            while (i < count) {
                Composite comp = temp[i];
                if (!comp.isDisposed()) {
                    comp.setLayoutDeferred(false);
                }
                ++i;
            }
            result = true;
        }
        return result;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinList == null) {
            this.skinList = new Widget[1024];
        }
        if (this.skinCount >= this.skinList.length) {
            Widget[] newSkinWidgets = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, newSkinWidgets, 0, this.skinList.length);
            this.skinList = newSkinWidgets;
        }
        this.skinList[this.skinCount++] = widget;
    }

    boolean runSkin() {
        boolean result = false;
        if (this.skinCount > 0) {
            Widget[] oldSkinWidgets = this.skinList;
            int count = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            int i = 0;
            while (i < count) {
                Widget widget = oldSkinWidgets[i];
                if (widget != null && !widget.isDisposed()) {
                    widget.state &= 0xFFDFFFFF;
                    oldSkinWidgets[i] = null;
                    this.sendSkinEvent(widget);
                }
                ++i;
            }
            result = true;
        }
        return result;
    }

    private void sendSkinEvent(Widget widget) {
        Event event = new Event();
        event.widget = widget;
        event.display = this;
        event.type = 45;
        this.notifyFilters(event);
        if (this.skinListeners != null) {
            Listener[] listeners = new Listener[this.skinListeners.size()];
            this.skinListeners.toArray(listeners);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleEvent(event);
                ++i;
            }
        }
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        if (this.monitor == null) {
            this.monitor = new Monitor(this);
        }
        return new Monitor[]{this.monitor};
    }

    public Monitor getPrimaryMonitor() {
        return this.getMonitors()[0];
    }

    public static String getAppName() {
        ISessionStore session = ContextProvider.getSessionStore();
        return (String)session.getAttribute(APP_NAME);
    }

    public static String getAppVersion() {
        ISessionStore session = ContextProvider.getSessionStore();
        return (String)session.getAttribute(APP_VERSION);
    }

    public static void setAppName(String name) {
        ISessionStore session = ContextProvider.getSessionStore();
        session.setAttribute(APP_NAME, name);
    }

    public static void setAppVersion(String version) {
        ISessionStore session = ContextProvider.getSessionStore();
        session.setAttribute(APP_VERSION, version);
    }

    public void update() {
        this.checkDevice();
    }

    public void beep() {
        this.checkDevice();
        this.beep = true;
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            boolean registered = false;
            WeakReference<Display>[] displays = Display.getDisplays();
            int i = 0;
            while (!registered && i < displays.length) {
                if (this.canDisplayRefBeReplaced(displays[i])) {
                    displays[i] = new WeakReference<Display>(this);
                    registered = true;
                }
                ++i;
            }
            if (!registered) {
                WeakReference[] newDisplays = new WeakReference[displays.length + 4];
                System.arraycopy(displays, 0, newDisplays, 0, displays.length);
                newDisplays[displays.length] = new WeakReference<Display>(this);
                Display.setDisplays(newDisplays);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean canDisplayRefBeReplaced(WeakReference displayRef) {
        boolean result = false;
        if (displayRef == null) {
            result = true;
        } else {
            Display display = (Display)displayRef.get();
            if (display == null || display.thread == this.thread) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregister() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            WeakReference<Display>[] displays = Display.getDisplays();
            int i = 0;
            while (i < displays.length) {
                WeakReference<Display> current = displays[i];
                if (current != null && this == current.get()) {
                    displays[i] = null;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static WeakReference<Display>[] getDisplays() {
        return RWTFactory.getDisplaysHolder().getDisplays();
    }

    private static void setDisplays(WeakReference<Display>[] displays) {
        RWTFactory.getDisplaysHolder().setDisplays(displays);
    }

    static boolean isValidClass(Class clazz) {
        return true;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    @Override
    protected void checkDevice() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    void error(int code) {
        SWT.error(code);
    }

    private Rectangle readInitialBounds() {
        HttpServletRequest request = ContextProvider.getRequest();
        String widthVal = request.getParameter(AVAILABLE_WIDTH);
        int width = 1024;
        if (widthVal != null) {
            width = Integer.parseInt(widthVal);
        }
        String heightVal = request.getParameter(AVAILABLE_HEIGHT);
        int height = 768;
        if (heightVal != null) {
            height = Integer.parseInt(heightVal);
        }
        return new Rectangle(0, 0, width, height);
    }

    private void notifyFilters(Event event) {
        IDisplayAdapter.IFilterEntry[] filterEntries = this.getFilterEntries();
        int i = 0;
        while (i < filterEntries.length) {
            if (filterEntries[i].getType() == event.type) {
                try {
                    filterEntries[i].getListener().handleEvent(event);
                }
                catch (Throwable thr) {
                    String msg = "Exception while executing filter.";
                    ServletLog.log(msg, thr);
                }
            }
            ++i;
        }
    }

    private IDisplayAdapter.IFilterEntry[] getFilterEntries() {
        IDisplayAdapter.IFilterEntry[] result = EMPTY_FILTERS;
        if (this.filters != null) {
            result = new IDisplayAdapter.IFilterEntry[this.filters.size()];
            this.filters.toArray(result);
        }
        return result;
    }

    private static final class ControlFinder {
        private final Display display;
        private final Point location;
        private final Set<Control> foundComponentInParent;
        private Control control;

        ControlFinder(Display display, Point location) {
            this.display = display;
            this.location = new Point(location.x, location.y);
            this.foundComponentInParent = new HashSet<Control>();
            this.find();
        }

        Control getControl() {
            return this.control;
        }

        private void find() {
            Shell[] shells = this.display.getShells();
            int i = 0;
            while (this.control == null && i < shells.length) {
                WidgetTreeVisitor.accept(shells[i], new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                    public boolean doVisit(Widget widget) {
                        boolean result = true;
                        if (widget instanceof Control) {
                            result = ControlFinder.this.visitControl((Control)widget);
                        }
                        return result;
                    }
                });
                ++i;
            }
        }

        private boolean visitControl(Control control) {
            Rectangle bounds = this.getAbsoluteBounds(control);
            boolean result = false;
            if (control.isVisible() && bounds.contains(this.location) && (result = this.foundComponentInParent.add(control.getParent()))) {
                this.control = control;
            }
            return result;
        }

        private Rectangle getAbsoluteBounds(Control control) {
            Rectangle bounds = control.getBounds();
            Point origin = Display.getAbsoluteOrigin(control);
            return new Rectangle(origin.x, origin.y, bounds.width, bounds.height);
        }
    }

    private final class DisplayAdapter
    implements IDisplayAdapter {
        private DisplayAdapter() {
        }

        public void setBounds(Rectangle bounds) {
            ((Display)Display.this).bounds.x = bounds.x;
            ((Display)Display.this).bounds.y = bounds.y;
            ((Display)Display.this).bounds.width = bounds.width;
            ((Display)Display.this).bounds.height = bounds.height;
        }

        public void setCursorLocation(int x, int y) {
            ((Display)Display.this).cursorLocation.x = x;
            ((Display)Display.this).cursorLocation.y = y;
        }

        public void setActiveShell(Shell activeShell) {
            Display.this.setActiveShell(activeShell);
        }

        public void setFocusControl(Control focusControl) {
            Display.this.setFocusControl(focusControl);
        }

        public void invalidateFocus() {
            ContextProvider.getServiceStore().setAttribute(ATTR_INVALIDATE_FOCUS, Boolean.TRUE);
        }

        public boolean isFocusInvalidated() {
            Object value = ContextProvider.getServiceStore().getAttribute(ATTR_INVALIDATE_FOCUS);
            return value != null;
        }

        public Shell[] getShells() {
            Shell[] result = new Shell[Display.this.shells.size()];
            Display.this.shells.toArray(result);
            return result;
        }

        public ISessionStore getSessionStore() {
            return Display.this.sessionStore;
        }

        public IDisplayAdapter.IFilterEntry[] getFilters() {
            return Display.this.getFilterEntries();
        }

        public void attachThread() {
            Display.this.attachThread();
        }

        public void detachThread() {
            Display.this.detachThread();
        }

        public boolean isValidThread() {
            return Display.this.isValidThread();
        }

        public boolean isBeepCalled() {
            return Display.this.beep;
        }

        public void resetBeep() {
            Display.this.beep = false;
        }
    }

    private static class FilterEntry
    implements IDisplayAdapter.IFilterEntry,
    SerializableCompatibility {
        private final int eventType;
        private final Listener listener;

        FilterEntry(int eventType, Listener listener) {
            this.eventType = eventType;
            this.listener = listener;
        }

        public int getType() {
            return this.eventType;
        }

        public Listener getListener() {
            return this.listener;
        }
    }

    private static class WakeRunnable
    implements Runnable,
    SerializableCompatibility {
        private WakeRunnable() {
        }

        public void run() {
        }
    }
}

