/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IColumnAdapter;
import org.eclipse.swt.internal.widgets.tablekit.TableThemeAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumn
extends Item {
    private static final int SORT_INDICATOR_WIDTH = 10;
    private static final int SPACING = 2;
    private final Table parent;
    private final IColumnAdapter columnAdapter;
    private int width;
    private String toolTipText;
    private boolean resizable;
    private boolean moveable;
    private boolean packed;

    public TableColumn(Table parent, int style) {
        this(parent, TableColumn.checkStyle(style), TableColumn.checkNull(parent).getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        this.resizable = true;
        this.columnAdapter = new ColumnAdapter();
        this.parent.createColumn(this, index);
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) != 0) {
            this.style &= 0xFEFDBFFF;
            this.style |= alignment & 0x1024000;
        }
    }

    public int getAlignment() {
        this.checkWidget();
        int result = 16384;
        if ((this.style & 0x1000000) != 0) {
            result = 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            result = 131072;
        }
        return result;
    }

    public void setWidth(int width) {
        this.checkWidget();
        if (width >= 0) {
            this.width = width;
            this.parent.updateScrollBars();
            ControlEvent event = new ControlEvent(this, 11);
            event.processEvent();
            this.processNextColumnsMoveEvent();
            this.packed = false;
        }
    }

    public void pack() {
        this.checkWidget();
        int width = this.getPreferredWidth();
        if (width != this.getWidth()) {
            this.setWidth(width);
        }
        this.packed = true;
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        ControlEvent.addListener(this, listener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        ControlEvent.removeListener(this, listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        IColumnAdapter result = null;
        result = adapter == IColumnAdapter.class ? this.columnAdapter : super.getAdapter(adapter);
        return (T)result;
    }

    final int getPreferredWidth() {
        int width = 0;
        if (this.parent.getHeaderVisible()) {
            Font font = this.parent.getFont();
            width = this.text.indexOf(10) != -1 ? Graphics.textExtent((Font)font, (String)this.text, (int)0).x : Graphics.stringExtent((Font)font, (String)this.text).x;
            Image image = this.getImage();
            if (image != null) {
                width += image.getBounds().width + 2;
            }
            if (this.parent.getSortColumn() == this && this.parent.getSortDirection() != 0) {
                width += 12;
            }
            TableThemeAdapter adapter = (TableThemeAdapter)this.parent.getAdapter(IThemeAdapter.class);
            width += adapter.getHeaderPadding((Control)this.parent).width;
        }
        if (this.parent.getItemCount() > 0 && this.parent.getCachedItems().length == 0) {
            this.parent.checkData(this.parent.getItem(0), 0);
        }
        int columnIndex = this.parent.indexOf(this);
        int itemsPreferredWidth = this.parent.getItemsPreferredWidth(columnIndex);
        width = Math.max(width, itemsPreferredWidth);
        return width;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        this.parent.destroyColumn(this);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    final int getLeft() {
        int result = 0;
        TableColumn[] columns = this.parent.getColumns();
        int[] columnOrder = this.parent.getColumnOrder();
        int orderedIndex = -1;
        int i = 0;
        while (orderedIndex == -1 && i < columnOrder.length) {
            if (columnOrder[i] == this.parent.indexOf(this)) {
                orderedIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < orderedIndex) {
            result += columns[columnOrder[i]].getWidth();
            ++i;
        }
        return result;
    }

    private static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    private static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    private void processNextColumnsMoveEvent() {
        int[] columnsOrder = this.parent.getColumnOrder();
        boolean found = false;
        int i = 0;
        while (i < columnsOrder.length) {
            TableColumn column = this.parent.getColumn(columnsOrder[i]);
            if (column == this) {
                found = true;
            } else if (found) {
                ControlEvent event = new ControlEvent(column, 10);
                event.processEvent();
            }
            ++i;
        }
    }

    private final class ColumnAdapter
    implements IColumnAdapter,
    SerializableCompatibility {
        private ColumnAdapter() {
        }

        public boolean isPacked() {
            return TableColumn.this.packed;
        }
    }
}

