/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient;

import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.ConnectionManagerHelper;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.ISSLSocketFactoryModifier;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.filetransfer.httpclient";
    private static Activator plugin;
    private BundleContext context = null;
    private ServiceTracker logServiceTracker = null;
    private ServiceTracker sslSocketFactoryTracker;
    private ISSLSocketFactoryModifier sslSocketFactoryModifier;
    private ConnectionManagerHelper cmHelper;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        try {
            Class<?> socketFactoryModifierClass = Class.forName("org.eclipse.ecf.internal.provider.filetransfer.httpclient.ssl.SSLSocketFactoryModifier");
            this.sslSocketFactoryModifier = (ISSLSocketFactoryModifier)socketFactoryModifierClass.newInstance();
        }
        catch (ClassNotFoundException socketFactoryModifierClass) {
        }
        catch (Throwable t) {
            this.log((IStatus)new Status(4, PLUGIN_ID, "Unexpected Error in Activator.start", t));
        }
    }

    public ConnectionManagerHelper getConnectionManagerHelper() {
        if (this.cmHelper == null) {
            this.cmHelper = new ConnectionManagerHelper();
        }
        return this.cmHelper;
    }

    public ISSLSocketFactoryModifier getSSLSocketFactoryModifier() {
        return this.sslSocketFactoryModifier;
    }

    public void stop(BundleContext ctxt) throws Exception {
        if (this.sslSocketFactoryModifier != null) {
            this.sslSocketFactoryModifier.dispose();
            this.sslSocketFactoryModifier = null;
        }
        if (this.sslSocketFactoryTracker != null) {
            this.sslSocketFactoryTracker.close();
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
        }
        if (this.cmHelper != null) {
            this.cmHelper.shutdown();
        }
        this.context = null;
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.sslSocketFactoryTracker == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("javax.net.ssl.SSLSocketFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.sslSocketFactoryTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.sslSocketFactoryTracker.open();
        }
        return (SSLSocketFactory)this.sslSocketFactoryTracker.getService();
    }

    public static void logNoProxyWarning(Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(2, PLUGIN_ID, 4, "Warning: Platform proxy API not available", e));
        }
    }
}

