/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.IBrowserHistory;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.events.BrowserHistoryEvent;
import org.eclipse.rap.rwt.events.BrowserHistoryListener;
import org.eclipse.rap.rwt.internal.application.RWTFactory;
import org.eclipse.rap.rwt.internal.events.EventAdapter;
import org.eclipse.rap.rwt.internal.events.IEventAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.lifecycle.PhaseEvent;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.lifecycle.PhaseListener;
import org.eclipse.rap.rwt.lifecycle.PhaseListenerUtil;
import org.eclipse.rap.rwt.service.ISessionStore;
import org.eclipse.rap.rwt.service.SessionStoreEvent;
import org.eclipse.rap.rwt.service.SessionStoreListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowserHistory
implements IBrowserHistory,
PhaseListener,
Adaptable,
SessionStoreListener {
    private static final String TYPE = "rwt.BrowserHistory";
    private static final String BROWSER_HISTORY_ID = "bh";
    private static final String PROP_NAVIGATION_LISTENER = "navigation";
    private static final String PROP_ENTRIES = "entries";
    private static final String METHOD_ADD = "add";
    private static final String ATTR_HAS_NAVIGATION_LISTENER = String.valueOf(BrowserHistory.class.getName()) + ".hasNavigationListener";
    private static final String EVENT_HISTORY_NAVIGATED = "historyNavigated";
    private static final String EVENT_HISTORY_NAVIGATED_ENTRY_ID = "entryId";
    private final Display display = Display.getCurrent();
    private final List<HistoryEntry> entriesToAdd = new ArrayList<HistoryEntry>();
    private IEventAdapter eventAdapter;
    private boolean created;

    public BrowserHistory() {
        RWTFactory.getLifeCycleFactory().getLifeCycle().addPhaseListener(this);
        RWT.getSessionStore().addSessionStoreListener(this);
    }

    @Override
    public void createEntry(String id, String text) {
        if (id == null) {
            SWT.error(4);
        }
        if (id.length() == 0) {
            SWT.error(5);
        }
        this.entriesToAdd.add(new HistoryEntry(id, text));
    }

    @Override
    public void addBrowserHistoryListener(BrowserHistoryListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        BrowserHistoryEvent.addListener(this, listener);
    }

    @Override
    public void removeBrowserHistoryListener(BrowserHistoryListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        BrowserHistoryEvent.removeListener(this, listener);
    }

    @Override
    public void afterPhase(PhaseEvent event) {
        Display sessionDisplay = LifeCycleUtil.getSessionDisplay();
        if (this.display == sessionDisplay) {
            if (PhaseListenerUtil.isPrepareUIRoot(event) && BrowserHistory.isStartup()) {
                this.processNavigationEvent();
            } else if (PhaseListenerUtil.isReadData(event)) {
                this.preserveNavigationListener();
            } else if (PhaseListenerUtil.isRender(event)) {
                this.renderCreate();
                this.renderNavigationListener();
                this.renderAdd();
            }
        }
    }

    @Override
    public void beforePhase(PhaseEvent event) {
        Display sessionDisplay = LifeCycleUtil.getSessionDisplay();
        if (this.display == sessionDisplay && PhaseListenerUtil.isProcessAction(event) && !BrowserHistory.isStartup()) {
            this.processNavigationEvent();
        }
    }

    @Override
    public PhaseId getPhaseId() {
        return PhaseId.ANY;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        IEventAdapter result = null;
        if (adapter == IEventAdapter.class) {
            if (this.eventAdapter == null) {
                this.eventAdapter = new EventAdapter();
            }
            result = this.eventAdapter;
        }
        return (T)result;
    }

    @Override
    public void beforeDestroy(SessionStoreEvent event) {
        RWTFactory.getLifeCycleFactory().getLifeCycle().removePhaseListener(this);
    }

    private static boolean isStartup() {
        return "true".equals(ProtocolUtil.readHeadPropertyValue("rwt_initialize"));
    }

    private void processNavigationEvent() {
        if (ProtocolUtil.wasEventSent(BROWSER_HISTORY_ID, EVENT_HISTORY_NAVIGATED)) {
            String entryId = ProtocolUtil.readEventPropertyValueAsString(BROWSER_HISTORY_ID, EVENT_HISTORY_NAVIGATED, EVENT_HISTORY_NAVIGATED_ENTRY_ID);
            BrowserHistoryEvent evt = new BrowserHistoryEvent((Object)this, entryId);
            evt.processEvent();
        }
    }

    private void preserveNavigationListener() {
        boolean hasListener = BrowserHistoryEvent.hasListener(this);
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        sessionStore.setAttribute(ATTR_HAS_NAVIGATION_LISTENER, hasListener);
    }

    private static boolean getPreservedNavigationListener() {
        boolean result = false;
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        Boolean preserved = (Boolean)sessionStore.getAttribute(ATTR_HAS_NAVIGATION_LISTENER);
        if (preserved != null) {
            result = preserved;
        }
        return result;
    }

    private void renderCreate() {
        if (!this.created) {
            ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
            protocolWriter.appendCreate(BROWSER_HISTORY_ID, TYPE);
            this.created = true;
        }
    }

    private void renderNavigationListener() {
        boolean actual = BrowserHistoryEvent.hasListener(this);
        boolean preserved = BrowserHistory.getPreservedNavigationListener();
        if (preserved != actual) {
            ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
            protocolWriter.appendListen(BROWSER_HISTORY_ID, PROP_NAVIGATION_LISTENER, actual);
        }
    }

    private void renderAdd() {
        if (!this.entriesToAdd.isEmpty()) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(PROP_ENTRIES, this.getEntriesAsArray());
            ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
            protocolWriter.appendCall(BROWSER_HISTORY_ID, METHOD_ADD, properties);
            this.entriesToAdd.clear();
        }
    }

    private Object[] getEntriesAsArray() {
        HistoryEntry[] entries = this.entriesToAdd.toArray(new HistoryEntry[0]);
        Object[][] result = new Object[entries.length][2];
        int i = 0;
        while (i < result.length) {
            result[i][0] = entries[i].id;
            result[i][1] = entries[i].text;
            ++i;
        }
        return result;
    }

    private final class HistoryEntry {
        public final String id;
        public final String text;

        public HistoryEntry(String id, String text) {
            this.id = id;
            this.text = text;
        }
    }
}

