/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.combokit;

import java.io.IOException;
import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Widget;

public class ComboLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Combo";
    private static final String[] ALLOWED_STYLES = new String[]{"DROP_DOWN", "SIMPLE", "BORDER"};
    private static final int LIST_ITEM_PADDING = 3;
    static final String PROP_ITEMS = "items";
    static final String PROP_TEXT = "text";
    static final String PROP_SELECTION_INDEX = "selectionIndex";
    static final String PROP_SELECTION = "selection";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_LIST_VISIBLE = "listVisible";
    static final String PROP_EDITABLE = "editable";
    static final String PROP_VISIBLE_ITEM_COUNT = "visibleItemCount";
    static final String PROP_ITEM_HEIGHT = "itemHeight";
    static final String PROP_SELECTION_LISTENER = "selection";
    static final String PROP_MODIFY_LISTENER = "modify";
    static final String PROP_VERIFY_LISTENER = "verify";
    private static final String[] DEFAUT_ITEMS = new String[0];
    private static final Integer DEFAULT_SELECTION_INDEX = -1;
    private static final Point DEFAULT_SELECTION = new Point(0, 0);
    private static final int DEFAULT_VISIBLE_ITEM_COUNT = 5;

    public void preserveValues(Widget widget) {
        Combo combo = (Combo)widget;
        ControlLCAUtil.preserveValues(combo);
        WidgetLCAUtil.preserveCustomVariant(combo);
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_ITEMS, combo.getItems());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_SELECTION_INDEX, (Object)combo.getSelectionIndex());
        WidgetLCAUtil.preserveProperty((Widget)combo, "selection", combo.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_TEXT_LIMIT, ComboLCA.getTextLimit(combo));
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_VISIBLE_ITEM_COUNT, combo.getVisibleItemCount());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_ITEM_HEIGHT, ComboLCA.getItemHeight(combo));
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_TEXT, combo.getText());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_LIST_VISIBLE, combo.getListVisible());
        WidgetLCAUtil.preserveProperty((Widget)combo, PROP_EDITABLE, (Object)ComboLCA.isEditable(combo));
        WidgetLCAUtil.preserveListener(combo, "selection", SelectionEvent.hasListener(combo));
        WidgetLCAUtil.preserveListener(combo, PROP_MODIFY_LISTENER, ModifyEvent.hasListener(combo));
        WidgetLCAUtil.preserveListener(combo, PROP_VERIFY_LISTENER, VerifyEvent.hasListener(combo));
    }

    public void readData(Widget widget) {
        String listVisible;
        Combo combo = (Combo)widget;
        String value = WidgetLCAUtil.readPropertyValue(widget, PROP_SELECTION_INDEX);
        if (value != null) {
            combo.select(NumberFormatUtil.parseInt(value));
        }
        if ((listVisible = WidgetLCAUtil.readPropertyValue(combo, PROP_LIST_VISIBLE)) != null) {
            combo.setListVisible(Boolean.valueOf(listVisible));
        }
        ComboLCA.readTextAndSelection(combo);
        ControlLCAUtil.processSelection(combo, null, true);
        ControlLCAUtil.processEvents(combo);
        ControlLCAUtil.processKeyEvents(combo);
        ControlLCAUtil.processMenuDetect(combo);
        WidgetLCAUtil.processHelp(combo);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Combo combo = (Combo)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(combo);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(combo.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(combo, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        Combo combo = (Combo)widget;
        ControlLCAUtil.renderChanges(combo);
        WidgetLCAUtil.renderCustomVariant(combo);
        ComboLCA.renderItemHeight(combo);
        ComboLCA.renderVisibleItemCount(combo);
        ComboLCA.renderItems(combo);
        ComboLCA.renderListVisible(combo);
        ComboLCA.renderSelectionIndex(combo);
        ComboLCA.renderEditable(combo);
        ComboLCA.renderText(combo);
        ComboLCA.renderSelection(combo);
        ComboLCA.renderTextLimit(combo);
        ComboLCA.renderListenSelection(combo);
        ComboLCA.renderListenModify(combo);
        ComboLCA.renderListenVerify(combo);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    private static void readTextAndSelection(final Combo combo) {
        final Point selection = ComboLCA.readSelection(combo);
        final String value = WidgetLCAUtil.readPropertyValue(combo, PROP_TEXT);
        if (value != null) {
            if (VerifyEvent.hasListener(combo)) {
                ProcessActionRunner.add(new Runnable(){

                    public void run() {
                        combo.setText(value);
                        IWidgetAdapter adapter = WidgetUtil.getAdapter(combo);
                        adapter.preserve(ComboLCA.PROP_TEXT, value);
                        if (selection != null) {
                            combo.setSelection(selection);
                            adapter.preserve("selection", selection);
                        }
                    }
                });
            } else {
                combo.setText(value);
                if (selection != null) {
                    combo.setSelection(selection);
                }
            }
        } else if (selection != null) {
            combo.setSelection(selection);
        }
    }

    private static Point readSelection(Combo combo) {
        Point result = null;
        String selStart = WidgetLCAUtil.readPropertyValue(combo, "selectionStart");
        String selLength = WidgetLCAUtil.readPropertyValue(combo, "selectionLength");
        if (selStart != null || selLength != null) {
            result = new Point(0, 0);
            if (selStart != null) {
                result.x = NumberFormatUtil.parseInt(selStart);
            }
            if (selLength != null) {
                result.y = result.x + NumberFormatUtil.parseInt(selLength);
            }
        }
        return result;
    }

    private static void renderItemHeight(Combo combo) {
        Integer newValue = new Integer(ComboLCA.getItemHeight(combo));
        if (WidgetLCAUtil.hasChanged(combo, PROP_ITEM_HEIGHT, newValue)) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(combo);
            clientObject.set(PROP_ITEM_HEIGHT, newValue);
        }
    }

    private static void renderVisibleItemCount(Combo combo) {
        int defValue = 5;
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_VISIBLE_ITEM_COUNT, combo.getVisibleItemCount(), defValue);
    }

    private static void renderItems(Combo combo) {
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_ITEMS, combo.getItems(), DEFAUT_ITEMS);
    }

    private static void renderListVisible(Combo combo) {
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_LIST_VISIBLE, combo.getListVisible(), false);
    }

    private static void renderSelectionIndex(Combo combo) {
        boolean textChanged;
        Integer newValue = new Integer(combo.getSelectionIndex());
        boolean selectionChanged = WidgetLCAUtil.hasChanged(combo, PROP_SELECTION_INDEX, newValue, DEFAULT_SELECTION_INDEX);
        boolean bl = textChanged = !ComboLCA.isEditable(combo) && WidgetLCAUtil.hasChanged(combo, PROP_TEXT, combo.getText(), "");
        if (selectionChanged || textChanged) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(combo);
            clientObject.set(PROP_SELECTION_INDEX, newValue);
        }
    }

    private static void renderEditable(Combo combo) {
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_EDITABLE, (Object)ComboLCA.isEditable(combo), Boolean.TRUE);
    }

    private static void renderText(Combo combo) {
        if (ComboLCA.isEditable(combo)) {
            WidgetLCAUtil.renderProperty((Widget)combo, PROP_TEXT, combo.getText(), "");
        }
    }

    private static void renderSelection(Combo combo) {
        WidgetLCAUtil.renderProperty((Widget)combo, "selection", combo.getSelection(), DEFAULT_SELECTION);
    }

    private static void renderTextLimit(Combo combo) {
        WidgetLCAUtil.renderProperty((Widget)combo, PROP_TEXT_LIMIT, ComboLCA.getTextLimit(combo), null);
    }

    private static void renderListenSelection(Combo combo) {
        WidgetLCAUtil.renderListener(combo, "selection", SelectionEvent.hasListener(combo), false);
    }

    private static void renderListenModify(Combo combo) {
        WidgetLCAUtil.renderListener(combo, PROP_MODIFY_LISTENER, ModifyEvent.hasListener(combo), false);
    }

    private static void renderListenVerify(Combo combo) {
        WidgetLCAUtil.renderListener(combo, PROP_VERIFY_LISTENER, VerifyEvent.hasListener(combo), false);
    }

    private static boolean isEditable(Combo combo) {
        return (combo.getStyle() & 8) == 0;
    }

    private static int getItemHeight(Combo combo) {
        int charHeight = Graphics.getCharHeight(combo.getFont());
        int padding = 6;
        return charHeight + padding;
    }

    private static Integer getTextLimit(Combo combo) {
        Integer result = combo.getTextLimit();
        if (result == Integer.MAX_VALUE) {
            result = null;
        }
        return result;
    }
}

