/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.datetimekit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.internal.widgets.datetimekit.AbstractDateTimeLCADelegate;
import org.eclipse.swt.internal.widgets.datetimekit.DateTimeLCAUtil;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

final class DateTimeDateLCA
extends AbstractDateTimeLCADelegate {
    private static final String PROP_YEAR = "year";
    private static final String PROP_MONTH = "month";
    private static final String PROP_DAY = "day";

    DateTimeDateLCA() {
    }

    void preserveValues(DateTime dateTime) {
        DateTimeLCAUtil.preserveValues(dateTime);
        WidgetLCAUtil.preserveProperty((Widget)dateTime, PROP_YEAR, dateTime.getYear());
        WidgetLCAUtil.preserveProperty((Widget)dateTime, PROP_MONTH, dateTime.getMonth());
        WidgetLCAUtil.preserveProperty((Widget)dateTime, PROP_DAY, dateTime.getDay());
        DateTimeLCAUtil.preserveSubWidgetsBounds(dateTime, DateTimeDateLCA.getSubWidgetsBounds(dateTime));
    }

    void readData(DateTime dateTime) {
        String year = WidgetLCAUtil.readPropertyValue(dateTime, PROP_YEAR);
        String month = WidgetLCAUtil.readPropertyValue(dateTime, PROP_MONTH);
        String day = WidgetLCAUtil.readPropertyValue(dateTime, PROP_DAY);
        if (day != null && month != null && year != null) {
            dateTime.setDate(NumberFormatUtil.parseInt(year), NumberFormatUtil.parseInt(month), NumberFormatUtil.parseInt(day));
        }
        ControlLCAUtil.processSelection(dateTime, null, true);
        ControlLCAUtil.processEvents(dateTime);
        ControlLCAUtil.processKeyEvents(dateTime);
        ControlLCAUtil.processMenuDetect(dateTime);
        WidgetLCAUtil.processHelp(dateTime);
    }

    void renderInitialization(DateTime dateTime) throws IOException {
        DateTimeLCAUtil.renderInitialization(dateTime);
        DateTimeLCAUtil.renderCellSize(dateTime);
        DateTimeLCAUtil.renderMonthNames(dateTime);
        DateTimeLCAUtil.renderWeekdayNames(dateTime);
        DateTimeLCAUtil.renderWeekdayShortNames(dateTime);
        DateTimeLCAUtil.renderDateSeparator(dateTime);
        DateTimeLCAUtil.renderDatePattern(dateTime);
    }

    void renderChanges(DateTime dateTime) throws IOException {
        DateTimeLCAUtil.renderChanges(dateTime);
        WidgetLCAUtil.renderProperty((Widget)dateTime, PROP_YEAR, dateTime.getYear(), -1);
        WidgetLCAUtil.renderProperty((Widget)dateTime, PROP_MONTH, dateTime.getMonth(), -1);
        WidgetLCAUtil.renderProperty((Widget)dateTime, PROP_DAY, dateTime.getDay(), -1);
        DateTimeLCAUtil.renderSubWidgetsBounds(dateTime, DateTimeDateLCA.getSubWidgetsBounds(dateTime));
    }

    private static DateTimeLCAUtil.SubWidgetBounds[] getSubWidgetsBounds(DateTime dateTime) {
        return new DateTimeLCAUtil.SubWidgetBounds[]{DateTimeLCAUtil.getSubWidgetBounds(dateTime, 0), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 4), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 2), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 5), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 1), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 6), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 3), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 7), DateTimeLCAUtil.getSubWidgetBounds(dateTime, 13)};
    }
}

