/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.expanditemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IExpandBarAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public final class ExpandItemLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ExpandItem";
    public static final String EVENT_ITEM_EXPANDED = "expandItemExpanded";
    public static final String EVENT_ITEM_COLLAPSED = "expandItemCollapsed";
    public static final String PROP_EXPANDED = "expanded";
    public static final String PROP_HEADER_HEIGHT = "headerHeight";
    public static final int DEFAULT_HEADER_HEIGHT = 24;

    public void preserveValues(Widget widget) {
        ExpandItem item = (ExpandItem)widget;
        WidgetLCAUtil.preserveCustomVariant(item);
        WidgetLCAUtil.preserveBounds(item, ExpandItemLCA.getBounds(item));
        ItemLCAUtil.preserve(item);
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_EXPANDED, item.getExpanded());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_HEADER_HEIGHT, item.getHeaderHeight());
    }

    public void readData(Widget widget) {
        final ExpandItem item = (ExpandItem)widget;
        if (WidgetLCAUtil.wasEventSent(item, EVENT_ITEM_EXPANDED)) {
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    item.setExpanded(true);
                    ExpandItemLCA.createEvent(item, 17).processEvent();
                }
            });
        }
        if (WidgetLCAUtil.wasEventSent(item, EVENT_ITEM_COLLAPSED)) {
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    item.setExpanded(false);
                    ExpandItemLCA.createEvent(item, 18).processEvent();
                }
            });
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        ExpandItem item = (ExpandItem)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(item);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(item.getParent()));
    }

    public void renderChanges(Widget widget) throws IOException {
        ExpandItem item = (ExpandItem)widget;
        WidgetLCAUtil.renderCustomVariant(widget);
        WidgetLCAUtil.renderBounds(item, ExpandItemLCA.getBounds(item));
        ItemLCAUtil.renderChanges(item);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_EXPANDED, item.getExpanded(), false);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_HEADER_HEIGHT, item.getHeaderHeight(), 24);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    private static ExpandEvent createEvent(ExpandItem item, int id) {
        return new ExpandEvent(item.getParent(), item, id);
    }

    private static Rectangle getBounds(ExpandItem item) {
        return ExpandItemLCA.getExpandBarAdapter(item).getBounds(item);
    }

    private static IExpandBarAdapter getExpandBarAdapter(ExpandItem item) {
        return item.getParent().getAdapter(IExpandBarAdapter.class);
    }
}

