/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treekit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class TreeLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Grid";
    private static final String[] ALLOWED_STYLES = new String[]{"SINGLE", "MULTI", "CHECK", "FULL_SELECTION", "VIRTUAL", "NO_SCROLL", "NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_ITEM_COUNT = "itemCount";
    private static final String PROP_ITEM_HEIGHT = "itemHeight";
    private static final String PROP_ITEM_METRICS = "itemMetrics";
    private static final String PROP_COLUMN_COUNT = "columnCount";
    private static final String PROP_FIXED_COLUMNS = "fixedColumns";
    private static final String PROP_TREE_COLUMN = "treeColumn";
    private static final String PROP_HEADER_HEIGHT = "headerHeight";
    private static final String PROP_HEADER_VISIBLE = "headerVisible";
    private static final String PROP_LINES_VISIBLE = "linesVisible";
    private static final String PROP_TOP_ITEM_INDEX = "topItemIndex";
    private static final String PROP_FOCUS_ITEM = "focusItem";
    private static final String PROP_SCROLL_LEFT = "scrollLeft";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SORT_DIRECTION = "sortDirection";
    private static final String PROP_SORT_COLUMN = "sortColumn";
    private static final String PROP_SCROLLBARS_VISIBLE = "scrollBarsVisible";
    private static final String PROP_SCROLLBARS_SELECTION_LISTENER = "scrollBarsSelection";
    private static final String PROP_SELECTION_LISTENER = "selection";
    private static final String PROP_ENABLE_CELL_TOOLTIP = "enableCellToolTip";
    private static final String PROP_CELL_TOOLTIP_TEXT = "cellToolTipText";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final String EVENT_SCROLLBAR_SELECTED = "scrollBarSelected";
    private static final int ZERO = 0;
    private static final String[] DEFAULT_SELECTION = new String[0];
    private static final boolean[] DEFAULT_SCROLLBARS_VISIBLE = new boolean[2];
    private static final String DEFAULT_SORT_DIRECTION = "none";

    public void preserveValues(Widget widget) {
        Tree tree = (Tree)widget;
        ControlLCAUtil.preserveValues((Control)widget);
        WidgetLCAUtil.preserveCustomVariant(tree);
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_ITEM_COUNT, tree.getItemCount());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_ITEM_HEIGHT, tree.getItemHeight());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_ITEM_METRICS, TreeLCA.getItemMetrics(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_COLUMN_COUNT, tree.getColumnCount());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_FIXED_COLUMNS, this.getFixedColumns(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_TREE_COLUMN, TreeLCA.getTreeColumn(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_HEADER_HEIGHT, tree.getHeaderHeight());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_HEADER_VISIBLE, tree.getHeaderVisible());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_LINES_VISIBLE, tree.getLinesVisible());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_TOP_ITEM_INDEX, TreeLCA.getTopItemIndex(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_FOCUS_ITEM, TreeLCA.getFocusItem(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_SCROLL_LEFT, TreeLCA.getScrollLeft(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, "selection", TreeLCA.getSelection(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_SORT_DIRECTION, TreeLCA.getSortDirection(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_SORT_COLUMN, tree.getSortColumn());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_SCROLLBARS_VISIBLE, TreeLCA.getScrollBarsVisible(tree));
        WidgetLCAUtil.preserveListener(tree, PROP_SCROLLBARS_SELECTION_LISTENER, TreeLCA.hasScrollBarsSelectionListener(tree));
        WidgetLCAUtil.preserveListener(tree, "selection", SelectionEvent.hasListener(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_ENABLE_CELL_TOOLTIP, CellToolTipUtil.isEnabledFor(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_CELL_TOOLTIP_TEXT, null);
    }

    public void readData(Widget widget) {
        Tree tree = (Tree)widget;
        TreeLCA.readSelection(tree);
        TreeLCA.readScrollLeft(tree);
        TreeLCA.readTopItemIndex(tree);
        TreeLCA.processWidgetSelectedEvent(tree);
        TreeLCA.processWidgetDefaultSelectedEvent(tree);
        TreeLCA.readCellToolTipTextRequested(tree);
        ControlLCAUtil.processEvents(tree);
        ControlLCAUtil.processKeyEvents(tree);
        ControlLCAUtil.processMenuDetect(tree);
        WidgetLCAUtil.processHelp(tree);
        TreeLCA.processScrollBarSelectionEvent(tree);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Tree tree = (Tree)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(tree);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(tree.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(tree, ALLOWED_STYLES));
        clientObject.set("appearance", "tree");
        ITreeAdapter adapter = TreeLCA.getTreeAdapter(tree);
        if ((tree.getStyle() & 0x20) != 0) {
            int[] checkMetrics = new int[]{adapter.getCheckLeft(), adapter.getCheckWidth()};
            clientObject.set("checkBoxMetrics", checkMetrics);
        }
        if (this.getFixedColumns(tree) >= 0) {
            clientObject.set("splitContainer", true);
        }
        if ((tree.getStyle() & 0x10000) == 0) {
            Rectangle textMargin = TreeLCA.getTreeAdapter(tree).getTextMargin();
            int[] selectionPadding = new int[]{textMargin.x, textMargin.width - textMargin.x};
            clientObject.set("selectionPadding", selectionPadding);
        }
        clientObject.set("indentionWidth", adapter.getIndentionWidth());
        clientObject.set(PROP_MARKUP_ENABLED, TreeLCA.isMarkupEnabled(tree));
    }

    public void renderChanges(Widget widget) throws IOException {
        Tree tree = (Tree)widget;
        ControlLCAUtil.renderChanges(tree);
        WidgetLCAUtil.renderCustomVariant(tree);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_ITEM_COUNT, tree.getItemCount(), 0);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_ITEM_HEIGHT, tree.getItemHeight(), 0);
        TreeLCA.renderItemMetrics(tree);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_COLUMN_COUNT, tree.getColumnCount(), 0);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_FIXED_COLUMNS, this.getFixedColumns(tree), -1);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_TREE_COLUMN, TreeLCA.getTreeColumn(tree), 0);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_HEADER_HEIGHT, tree.getHeaderHeight(), 0);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_HEADER_VISIBLE, tree.getHeaderVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_LINES_VISIBLE, tree.getLinesVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_TOP_ITEM_INDEX, TreeLCA.getTopItemIndex(tree), 0);
        if (tree.getSelectionCount() > 0) {
            WidgetLCAUtil.renderProperty((Widget)tree, PROP_FOCUS_ITEM, TreeLCA.getFocusItem(tree), null);
        }
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_SCROLL_LEFT, TreeLCA.getScrollLeft(tree), 0);
        WidgetLCAUtil.renderProperty((Widget)tree, "selection", TreeLCA.getSelection(tree), DEFAULT_SELECTION);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_SORT_DIRECTION, TreeLCA.getSortDirection(tree), DEFAULT_SORT_DIRECTION);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_SORT_COLUMN, tree.getSortColumn(), null);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_SCROLLBARS_VISIBLE, TreeLCA.getScrollBarsVisible(tree), DEFAULT_SCROLLBARS_VISIBLE);
        WidgetLCAUtil.renderListener(tree, PROP_SCROLLBARS_SELECTION_LISTENER, TreeLCA.hasScrollBarsSelectionListener(tree), false);
        WidgetLCAUtil.renderListener(tree, "selection", SelectionEvent.hasListener(tree), false);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_ENABLE_CELL_TOOLTIP, CellToolTipUtil.isEnabledFor(tree), false);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_CELL_TOOLTIP_TEXT, TreeLCA.getCellToolTipText(tree), null);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    public void doRedrawFake(Control control) {
        Tree tree = (Tree)control;
        tree.getAdapter(ITreeAdapter.class).checkData();
    }

    private static void processWidgetSelectedEvent(Tree tree) {
        String eventName = "widgetSelected";
        if (WidgetLCAUtil.wasEventSent(tree, eventName)) {
            String value = WidgetLCAUtil.readEventPropertyValue(tree, eventName, "item");
            TreeItem treeItem = TreeLCA.getItem(tree, value);
            value = WidgetLCAUtil.readEventPropertyValue(tree, eventName, "detail");
            int detail = "check".equals(value) ? 32 : 0;
            int stateMask = EventLCAUtil.readStateMask(tree, eventName);
            SelectionEvent event = new SelectionEvent(tree, treeItem, 13, new Rectangle(0, 0, 0, 0), stateMask, null, true, detail);
            event.processEvent();
        }
    }

    private static void processWidgetDefaultSelectedEvent(Tree tree) {
        String eventName = "widgetDefaultSelected";
        if (WidgetLCAUtil.wasEventSent(tree, eventName)) {
            String value = WidgetLCAUtil.readEventPropertyValue(tree, eventName, "item");
            TreeItem treeItem = TreeLCA.getItem(tree, value);
            int eventType = 14;
            SelectionEvent event = new SelectionEvent(tree, treeItem, eventType);
            event.stateMask = EventLCAUtil.readStateMask(tree, eventName);
            event.processEvent();
        }
    }

    private static void readSelection(Tree tree) {
        String[] values = ProtocolUtil.readPropertyValueAsStringArray(WidgetUtil.getId(tree), "selection");
        if (values != null) {
            TreeItem[] selectedItems = new TreeItem[values.length];
            boolean validItemFound = false;
            int i = 0;
            while (i < values.length) {
                selectedItems[i] = TreeLCA.getItem(tree, values[i]);
                if (selectedItems[i] != null) {
                    validItemFound = true;
                }
                ++i;
            }
            if (!validItemFound) {
                selectedItems = new TreeItem[]{};
            }
            tree.setSelection(selectedItems);
        }
    }

    private static void readScrollLeft(Tree tree) {
        String left = WidgetLCAUtil.readPropertyValue(tree, PROP_SCROLL_LEFT);
        if (left != null) {
            int leftOffset = TreeLCA.parsePosition(left);
            ITreeAdapter treeAdapter = TreeLCA.getTreeAdapter(tree);
            treeAdapter.setScrollLeft(leftOffset);
            TreeLCA.processScrollBarSelection(tree.getHorizontalBar(), leftOffset);
        }
    }

    private static void readTopItemIndex(Tree tree) {
        String topItemIndex = WidgetLCAUtil.readPropertyValue(tree, PROP_TOP_ITEM_INDEX);
        if (topItemIndex != null) {
            ITreeAdapter treeAdapter = TreeLCA.getTreeAdapter(tree);
            int newIndex = TreeLCA.parsePosition(topItemIndex);
            int topOffset = newIndex * tree.getItemHeight();
            treeAdapter.setTopItemIndex(newIndex);
            TreeLCA.processScrollBarSelection(tree.getVerticalBar(), topOffset);
        }
    }

    private static int parsePosition(String position) {
        int result = 0;
        try {
            result = Integer.valueOf(position);
        }
        catch (NumberFormatException numberFormatException) {}
        return result;
    }

    private static void readCellToolTipTextRequested(Tree tree) {
        ICellToolTipProvider provider;
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter(tree);
        adapter.setCellToolTipText(null);
        String eventName = "cellToolTipTextRequested";
        if (WidgetLCAUtil.wasEventSent(tree, eventName) && (provider = adapter.getCellToolTipProvider()) != null) {
            String cell = WidgetLCAUtil.readEventPropertyValue(tree, eventName, "cell");
            String[] details = cell.split(",");
            String itemId = details[0];
            int columnIndex = NumberFormatUtil.parseInt(details[1]);
            TreeItem item = TreeLCA.getItem(tree, itemId);
            if (item != null && (columnIndex == 0 || columnIndex < tree.getColumnCount())) {
                provider.getToolTipText(item, columnIndex);
            }
        }
    }

    private static String getCellToolTipText(Tree tree) {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter(tree);
        return adapter.getCellToolTipText();
    }

    private static boolean isMarkupEnabled(Tree tree) {
        return Boolean.TRUE.equals(tree.getData("org.eclipse.rap.rwt.markupEnabled"));
    }

    private static String[] getSelection(Tree tree) {
        TreeItem[] selection = tree.getSelection();
        String[] result = new String[selection.length];
        int i = 0;
        while (i < result.length) {
            result[i] = WidgetUtil.getId(selection[i]);
            ++i;
        }
        return result;
    }

    private int getFixedColumns(Tree tree) {
        return TreeLCA.getTreeAdapter(tree).getFixedColumns();
    }

    private static int getScrollLeft(Tree tree) {
        return TreeLCA.getTreeAdapter(tree).getScrollLeft();
    }

    private static int getTopItemIndex(Tree tree) {
        return TreeLCA.getTreeAdapter(tree).getTopItemIndex();
    }

    private static TreeItem getFocusItem(Tree tree) {
        TreeItem result = null;
        TreeItem[] selection = tree.getSelection();
        if (selection.length > 0) {
            result = selection[0];
        }
        return result;
    }

    private static int getTreeColumn(Tree tree) {
        int[] values = tree.getColumnOrder();
        return values.length > 0 ? values[0] : 0;
    }

    private static String getSortDirection(Tree tree) {
        String result = DEFAULT_SORT_DIRECTION;
        if (tree.getSortDirection() == 128) {
            result = "up";
        } else if (tree.getSortDirection() == 1024) {
            result = "down";
        }
        return result;
    }

    private static boolean[] getScrollBarsVisible(Tree tree) {
        return new boolean[]{TreeLCA.hasHScrollBar(tree), TreeLCA.hasVScrollBar(tree)};
    }

    private static boolean hasHScrollBar(Tree tree) {
        return TreeLCA.getTreeAdapter(tree).hasHScrollBar();
    }

    private static boolean hasVScrollBar(Tree tree) {
        return TreeLCA.getTreeAdapter(tree).hasVScrollBar();
    }

    private static boolean hasScrollBarsSelectionListener(Tree tree) {
        ScrollBar verticalBar;
        boolean result = false;
        ScrollBar horizontalBar = tree.getHorizontalBar();
        if (horizontalBar != null) {
            boolean bl = result = result || SelectionEvent.hasListener(horizontalBar);
        }
        if ((verticalBar = tree.getVerticalBar()) != null) {
            result = result || SelectionEvent.hasListener(verticalBar);
        }
        return result;
    }

    private static void processScrollBarSelection(ScrollBar scrollBar, int selection) {
        if (scrollBar != null) {
            scrollBar.setSelection(selection);
        }
    }

    private static void processScrollBarSelectionEvent(Tree tree) {
        if (WidgetLCAUtil.wasEventSent(tree, EVENT_SCROLLBAR_SELECTED)) {
            ScrollBar vScroll;
            String horizontal = WidgetLCAUtil.readEventPropertyValue(tree, EVENT_SCROLLBAR_SELECTED, "horizontal");
            String vertical = WidgetLCAUtil.readEventPropertyValue(tree, EVENT_SCROLLBAR_SELECTED, "vertical");
            ScrollBar hScroll = tree.getHorizontalBar();
            if (hScroll != null && "true".equals(horizontal)) {
                SelectionEvent evt = new SelectionEvent(hScroll, null, 13);
                evt.processEvent();
            }
            if ((vScroll = tree.getVerticalBar()) != null && "true".equals(vertical)) {
                SelectionEvent evt = new SelectionEvent(vScroll, null, 13);
                evt.processEvent();
            }
        }
    }

    private static TreeItem getItem(Tree tree, String itemId) {
        TreeItem item = null;
        String[] idParts = itemId.split("#");
        if (idParts.length == 2) {
            Widget parent = WidgetUtil.find(tree, idParts[0]);
            if (parent != null) {
                int itemIndex = Integer.parseInt(idParts[1]);
                item = WidgetUtil.getId(tree).equals(idParts[0]) ? tree.getItem(itemIndex) : ((TreeItem)parent).getItem(itemIndex);
            }
        } else {
            item = (TreeItem)WidgetUtil.find(tree, itemId);
        }
        return item;
    }

    private static ITreeAdapter getTreeAdapter(Tree tree) {
        ITreeAdapter adapter = tree.getAdapter(ITreeAdapter.class);
        return adapter;
    }

    private static void renderItemMetrics(Tree tree) {
        ItemMetrics[] itemMetrics = TreeLCA.getItemMetrics(tree);
        if (WidgetLCAUtil.hasChanged(tree, PROP_ITEM_METRICS, itemMetrics)) {
            int[][] metrics = new int[itemMetrics.length][7];
            int i = 0;
            while (i < itemMetrics.length) {
                metrics[i] = new int[]{i, itemMetrics[i].left, itemMetrics[i].width, itemMetrics[i].imageLeft, itemMetrics[i].imageWidth, itemMetrics[i].textLeft, itemMetrics[i].textWidth};
                ++i;
            }
            IClientObject clientObject = ClientObjectFactory.getClientObject(tree);
            clientObject.set(PROP_ITEM_METRICS, metrics);
        }
    }

    static ItemMetrics[] getItemMetrics(Tree tree) {
        int columnCount = Math.max(1, tree.getColumnCount());
        ItemMetrics[] result = new ItemMetrics[columnCount];
        int i = 0;
        while (i < columnCount) {
            result[i] = new ItemMetrics();
            ++i;
        }
        ITreeAdapter adapter = TreeLCA.getTreeAdapter(tree);
        int i2 = 0;
        while (i2 < columnCount) {
            result[i2].left = adapter.getCellLeft(i2);
            result[i2].width = adapter.getCellWidth(i2);
            result[i2].imageLeft = result[i2].left + adapter.getImageOffset(i2);
            result[i2].imageWidth = adapter.getItemImageSize((int)i2).x;
            result[i2].textLeft = result[i2].left + adapter.getTextOffset(i2);
            result[i2].textWidth = adapter.getTextMaxWidth(i2);
            ++i2;
        }
        return result;
    }

    static final class ItemMetrics {
        int left;
        int width;
        int imageLeft;
        int imageWidth;
        int textLeft;
        int textWidth;

        ItemMetrics() {
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof ItemMetrics) {
                ItemMetrics other = (ItemMetrics)obj;
                result = other.left == this.left && other.width == this.width && other.imageLeft == this.imageLeft && other.imageWidth == this.imageWidth && other.textLeft == this.textLeft && other.textWidth == this.textWidth;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            String msg = "ItemMetrics#hashCode() not implemented";
            throw new UnsupportedOperationException(msg);
        }
    }
}

