/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.StartupPageConfigurer;
import org.eclipse.rap.rwt.internal.service.StartupPageTemplateHolder;
import org.eclipse.rap.rwt.internal.theme.QxImage;
import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.rap.rwt.internal.theme.SimpleSelector;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;

public class StartupPage {
    private final StartupPageConfigurer configurer;

    public StartupPage(ResourceRegistry resourceRegistry) {
        this.configurer = new StartupPageConfigurer(resourceRegistry);
    }

    public void addJsLibrary(String location) {
        this.configurer.addJsLibrary(location);
    }

    void send() throws IOException {
        HttpServletResponse response = ContextProvider.getResponse();
        StartupPage.setResponseHeaders(response);
        StartupPageTemplateHolder template = this.configurer.getTemplate();
        StartupPage.processTemplate(template);
        StartupPage.writeTemplate(response, template);
    }

    private static void setResponseHeaders(HttpServletResponse response) {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Cache-Control", "max-age=0, no-cache, must-revalidate, no-store");
    }

    private static void processTemplate(StartupPageTemplateHolder template) {
        template.replace(StartupPageTemplateHolder.VAR_BACKGROUND_IMAGE, StartupPage.getBgImage());
    }

    private static String getBgImage() {
        QxImage image;
        String resourceName;
        String result = "";
        QxType value = ThemeUtil.getCssValue("Display", "background-image", SimpleSelector.DEFAULT);
        if (value instanceof QxImage && (resourceName = (image = (QxImage)value).getResourcePath()) != null) {
            result = RWT.getResourceManager().getLocation(resourceName);
        }
        return result;
    }

    private static void writeTemplate(HttpServletResponse response, StartupPageTemplateHolder template) throws IOException {
        PrintWriter writer = response.getWriter();
        String[] stringArray = template.getTokens();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token != null) {
                writer.write(token);
            }
            ++n2;
        }
    }
}

