/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.internal.application.RWTFactory;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.textsize.MeasurementItem;
import org.eclipse.rap.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rap.rwt.internal.textsize.Probe;
import org.eclipse.rap.rwt.internal.textsize.ProbeResultStore;
import org.eclipse.rap.rwt.internal.textsize.TextSizeStorageUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.Display;

class MeasurementOperator
implements SerializableCompatibility {
    private static final String PROPERTY_STRINGS = "strings";
    private static final String METHOD_MEASURE_STRINGS = "measureStrings";
    private static final String PROPERTY_FONTS = "fonts";
    private static final String METHOD_PROBE = "probe";
    private static final String METHOD_STORE_PROBES = "storeProbes";
    private static final String METHOD_STORE_MEASUREMENTS = "storeMeasurements";
    private static final String PROPERTY_RESULTS = "results";
    private final Set<Probe> probes = new HashSet<Probe>();
    private final Set<MeasurementItem> items = new HashSet<MeasurementItem>();
    private boolean isStartupProbeMeasurementPerformed;

    static MeasurementOperator getInstance() {
        return SingletonUtil.getSessionInstance(MeasurementOperator.class);
    }

    MeasurementOperator() {
        this.addStartupProbesToBuffer();
    }

    void handleMeasurementRequests() {
        if (this.hasProbesToMeasure()) {
            MeasurementOperator.renderFontProbing();
        }
        if (this.hasItemsToMeasure()) {
            MeasurementOperator.renderStringMeasurements();
        }
    }

    boolean handleMeasurementResults() {
        this.readMeasuredFontProbeSizes();
        return this.readMeasuredTextSizes();
    }

    void handleStartupProbeMeasurementResults() {
        if (!this.isStartupProbeMeasurementPerformed) {
            this.readMeasuredFontProbeSizes();
            this.isStartupProbeMeasurementPerformed = true;
        }
    }

    int getProbeCount() {
        return this.probes.size();
    }

    void addProbeToMeasure(FontData fontData) {
        Probe probe = RWTFactory.getProbeStore().getProbe(fontData);
        if (probe == null) {
            probe = RWTFactory.getProbeStore().createProbe(fontData);
        }
        this.probes.add(probe);
    }

    Probe[] getProbes() {
        return this.probes.toArray(new Probe[this.probes.size()]);
    }

    void addItemToMeasure(MeasurementItem newItem) {
        this.items.add(newItem);
    }

    int getItemCount() {
        return this.items.size();
    }

    MeasurementItem[] getItems() {
        return this.items.toArray(new MeasurementItem[this.items.size()]);
    }

    private boolean hasProbesToMeasure() {
        return !this.probes.isEmpty();
    }

    private void readMeasuredFontProbeSizes() {
        Iterator<Probe> probeList = this.probes.iterator();
        ClientMessage.CallOperation[] operations = MeasurementOperator.getCallOperationsFor(METHOD_STORE_PROBES);
        while (probeList.hasNext()) {
            Probe probe = probeList.next();
            String id = String.valueOf(probe.getFontData().hashCode());
            Point size = MeasurementOperator.readMeasuredSize(operations, id);
            if (size == null) continue;
            this.createProbeResult(probe, size);
            probeList.remove();
        }
    }

    private void createProbeResult(Probe probe, Point size) {
        ProbeResultStore.getInstance().createProbeResult(probe, size);
    }

    private void addStartupProbesToBuffer() {
        Probe[] probeList = RWTFactory.getProbeStore().getProbes();
        this.probes.addAll(Arrays.asList(probeList));
    }

    private boolean readMeasuredTextSizes() {
        int originalItemsSize = this.items.size();
        Iterator<MeasurementItem> itemList = this.items.iterator();
        ClientMessage.CallOperation[] operations = MeasurementOperator.getCallOperationsFor(METHOD_STORE_MEASUREMENTS);
        while (itemList.hasNext()) {
            MeasurementItem item = itemList.next();
            String id = String.valueOf(item.hashCode());
            Point size = MeasurementOperator.readMeasuredSize(operations, id);
            if (size == null) continue;
            MeasurementOperator.storeTextMeasurement(item, size);
            itemList.remove();
        }
        return this.itemsHasBeenMeasured(originalItemsSize);
    }

    private static ClientMessage.CallOperation[] getCallOperationsFor(String methodName) {
        ClientMessage.CallOperation[] result = new ClientMessage.CallOperation[]{};
        Display display = Display.getCurrent();
        if (display != null) {
            ClientMessage message = ProtocolUtil.getClientMessage();
            result = message.getAllCallOperationsFor(DisplayUtil.getId(display), methodName);
        }
        return result;
    }

    private static Point readMeasuredSize(ClientMessage.CallOperation[] operations, String id) {
        Point result = null;
        int i = 0;
        while (i < operations.length) {
            Map resultsMap = (Map)operations[i].getProperty(PROPERTY_RESULTS);
            if (resultsMap != null) {
                result = ProtocolUtil.toPoint(resultsMap.get(id));
            }
            ++i;
        }
        return result;
    }

    private static void storeTextMeasurement(MeasurementItem item, Point size) {
        FontData fontData = item.getFontData();
        String textToMeasure = item.getTextToMeasure();
        int wrapWidth = item.getWrapWidth();
        int mode = item.getMode();
        TextSizeStorageUtil.store(fontData, textToMeasure, wrapWidth, mode, size);
    }

    private boolean hasItemsToMeasure() {
        return !this.items.isEmpty();
    }

    private boolean itemsHasBeenMeasured(int originalItemsSize) {
        return originalItemsSize != this.items.size();
    }

    private static void renderStringMeasurements() {
        MeasurementItem[] items = MeasurementOperator.getInstance().getItems();
        if (items.length > 0) {
            Object[] itemsObject = new Object[items.length];
            int i = 0;
            while (i < items.length) {
                itemsObject[i] = MeasurementUtil.createItemParamObject(items[i]);
                ++i;
            }
            MeasurementOperator.callDisplayMethod(METHOD_MEASURE_STRINGS, PROPERTY_STRINGS, itemsObject);
        }
    }

    private static void renderFontProbing() {
        Probe[] probeList = MeasurementOperator.getInstance().getProbes();
        if (probeList.length > 0) {
            Object[] probesObject = new Object[probeList.length];
            int i = 0;
            while (i < probeList.length) {
                probesObject[i] = MeasurementUtil.createProbeParamObject(probeList[i]);
                ++i;
            }
            MeasurementOperator.callDisplayMethod(METHOD_PROBE, PROPERTY_FONTS, probesObject);
        }
    }

    private static void callDisplayMethod(String method, String property, Object value) {
        Display display = Display.getCurrent();
        if (display != null) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(display);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put(property, value);
            clientObject.call(method, args);
        }
    }
}

