/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.rap.rwt.IBrowserHistory;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.events.BrowserHistoryEvent;
import org.eclipse.rap.rwt.events.BrowserHistoryListener;
import org.eclipse.rap.rwt.internal.application.RWTFactory;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.lifecycle.PhaseEvent;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.lifecycle.PhaseListener;
import org.eclipse.rap.rwt.lifecycle.PhaseListenerUtil;
import org.eclipse.rap.rwt.service.SessionStoreEvent;
import org.eclipse.rap.rwt.service.SessionStoreListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public final class BrowserHistoryImpl
implements IBrowserHistory,
PhaseListener,
SessionStoreListener {
    private static final String TYPE = "rwt.client.BrowserHistory";
    private static final String PROP_NAVIGATION_LISTENER = "Navigation";
    private static final String PROP_ENTRIES = "entries";
    private static final String METHOD_ADD = "add";
    private static final String EVENT_HISTORY_NAVIGATED_ENTRY_ID = "entryId";
    private final Display display = Display.getCurrent();
    private final List<HistoryEntry> entriesToAdd = new ArrayList<HistoryEntry>();
    private final Collection<BrowserHistoryListener> listeners = new LinkedList<BrowserHistoryListener>();
    private boolean hasNavigationListener;

    public BrowserHistoryImpl() {
        RWTFactory.getLifeCycleFactory().getLifeCycle().addPhaseListener(this);
        RWT.getSessionStore().addSessionStoreListener(this);
    }

    public void createEntry(String id, String text) {
        if (id == null) {
            SWT.error(4);
        }
        if (id.length() == 0) {
            SWT.error(5);
        }
        this.entriesToAdd.add(new HistoryEntry(id, text));
    }

    public void addBrowserHistoryListener(BrowserHistoryListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        this.listeners.add(listener);
    }

    public void removeBrowserHistoryListener(BrowserHistoryListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        this.listeners.remove(listener);
    }

    public void afterPhase(PhaseEvent event) {
        Display sessionDisplay = LifeCycleUtil.getSessionDisplay();
        if (this.display == sessionDisplay) {
            if (PhaseListenerUtil.isPrepareUIRoot(event) && BrowserHistoryImpl.isStartup()) {
                this.processNavigationEvent();
            } else if (PhaseListenerUtil.isReadData(event)) {
                this.preserveNavigationListener();
            } else if (PhaseListenerUtil.isRender(event)) {
                this.renderNavigationListener();
                this.renderAdd();
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
        Display sessionDisplay = LifeCycleUtil.getSessionDisplay();
        if (this.display == sessionDisplay && PhaseListenerUtil.isProcessAction(event) && !BrowserHistoryImpl.isStartup()) {
            this.processNavigationEvent();
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY;
    }

    public void beforeDestroy(SessionStoreEvent event) {
        RWTFactory.getLifeCycleFactory().getLifeCycle().removePhaseListener(this);
    }

    private static boolean isStartup() {
        return "true".equals(ProtocolUtil.readHeadPropertyValue("rwt_initialize"));
    }

    private void processNavigationEvent() {
        if (ProtocolUtil.wasEventSent(TYPE, PROP_NAVIGATION_LISTENER)) {
            BrowserHistoryListener[] listeners;
            String entryId = ProtocolUtil.readEventPropertyValueAsString(TYPE, PROP_NAVIGATION_LISTENER, EVENT_HISTORY_NAVIGATED_ENTRY_ID);
            BrowserHistoryEvent event = new BrowserHistoryEvent(this, entryId);
            BrowserHistoryListener[] browserHistoryListenerArray = listeners = this.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                BrowserHistoryListener listener = browserHistoryListenerArray[n2];
                listener.navigated(event);
                ++n2;
            }
        }
    }

    private BrowserHistoryListener[] getListeners() {
        return this.listeners.toArray(new BrowserHistoryListener[this.listeners.size()]);
    }

    private void preserveNavigationListener() {
        this.hasNavigationListener = !this.listeners.isEmpty();
    }

    private boolean getPreservedNavigationListener() {
        return this.hasNavigationListener;
    }

    private void renderNavigationListener() {
        boolean actual = !this.listeners.isEmpty();
        boolean preserved = this.getPreservedNavigationListener();
        if (preserved != actual) {
            ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
            protocolWriter.appendListen(TYPE, PROP_NAVIGATION_LISTENER, actual);
        }
    }

    private void renderAdd() {
        if (!this.entriesToAdd.isEmpty()) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(PROP_ENTRIES, this.entriesAsArray());
            ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
            protocolWriter.appendCall(TYPE, METHOD_ADD, properties);
            this.entriesToAdd.clear();
        }
    }

    private Object[] entriesAsArray() {
        HistoryEntry[] entries = this.getEntries();
        Object[][] result = new Object[entries.length][2];
        int i = 0;
        while (i < result.length) {
            result[i][0] = entries[i].id;
            result[i][1] = entries[i].text;
            ++i;
        }
        return result;
    }

    HistoryEntry[] getEntries() {
        return this.entriesToAdd.toArray(new HistoryEntry[this.entriesToAdd.size()]);
    }

    final class HistoryEntry {
        final String id;
        final String text;

        HistoryEntry(String id, String text) {
            this.id = id;
            this.text = text;
        }
    }
}

