/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.jetty.osgi.boot.utils.BundleClassLoaderHelper;
import org.osgi.framework.Bundle;

public class DefaultBundleClassLoaderHelper
implements BundleClassLoaderHelper {
    private static boolean identifiedOsgiImpl = false;
    private static boolean isEquinox = false;
    private static boolean isFelix = false;
    private static Method Equinox_BundleHost_getBundleLoader_method;
    private static Method Equinox_BundleLoader_createClassLoader_method;
    private static Field Felix_BundleImpl_m_modules_field;
    private static Field Felix_ModuleImpl_m_classLoader_field;

    private static void init(Bundle bundle) {
        identifiedOsgiImpl = true;
        try {
            isEquinox = bundle.getClass().getClassLoader().loadClass("org.eclipse.osgi.framework.internal.core.BundleHost") != null;
        }
        catch (Throwable t) {
            isEquinox = false;
        }
        if (!isEquinox) {
            try {
                isFelix = bundle.getClass().getClassLoader().loadClass("org.apache.felix.framework.BundleImpl") != null;
            }
            catch (Throwable t2) {
                isFelix = false;
            }
        }
    }

    @Override
    public ClassLoader getBundleClassLoader(Bundle bundle) {
        String bundleActivator = (String)bundle.getHeaders().get("Bundle-Activator");
        if (bundleActivator == null) {
            bundleActivator = (String)bundle.getHeaders().get("Jetty-ClassInBundle");
        }
        if (bundleActivator != null) {
            try {
                return bundle.loadClass(bundleActivator).getClassLoader();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (!identifiedOsgiImpl) {
            DefaultBundleClassLoaderHelper.init(bundle);
        }
        if (isEquinox) {
            return DefaultBundleClassLoaderHelper.internalGetEquinoxBundleClassLoader(bundle);
        }
        if (isFelix) {
            return DefaultBundleClassLoaderHelper.internalGetFelixBundleClassLoader(bundle);
        }
        return null;
    }

    private static ClassLoader internalGetEquinoxBundleClassLoader(Bundle bundle) {
        try {
            if (Equinox_BundleHost_getBundleLoader_method == null) {
                Equinox_BundleHost_getBundleLoader_method = bundle.getClass().getClassLoader().loadClass("org.eclipse.osgi.framework.internal.core.BundleHost").getDeclaredMethod("getBundleLoader", new Class[0]);
                Equinox_BundleHost_getBundleLoader_method.setAccessible(true);
            }
            Object bundleLoader = Equinox_BundleHost_getBundleLoader_method.invoke((Object)bundle, new Object[0]);
            if (Equinox_BundleLoader_createClassLoader_method == null && bundleLoader != null) {
                Equinox_BundleLoader_createClassLoader_method = bundleLoader.getClass().getClassLoader().loadClass("org.eclipse.osgi.internal.loader.BundleLoader").getDeclaredMethod("createClassLoader", new Class[0]);
                Equinox_BundleLoader_createClassLoader_method.setAccessible(true);
            }
            return (ClassLoader)Equinox_BundleLoader_createClassLoader_method.invoke(bundleLoader, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static ClassLoader internalGetFelixBundleClassLoader(Bundle bundle) {
        try {
            ClassLoader cl;
            if (Felix_BundleImpl_m_modules_field == null) {
                Felix_BundleImpl_m_modules_field = bundle.getClass().getClassLoader().loadClass("org.apache.felix.framework.BundleImpl").getDeclaredField("m_modules");
                Felix_BundleImpl_m_modules_field.setAccessible(true);
            }
            Object[] moduleArray = (Object[])Felix_BundleImpl_m_modules_field.get(bundle);
            Object currentModuleImpl = moduleArray[moduleArray.length - 1];
            if (Felix_ModuleImpl_m_classLoader_field == null && currentModuleImpl != null) {
                Felix_ModuleImpl_m_classLoader_field = bundle.getClass().getClassLoader().loadClass("org.apache.felix.framework.ModuleImpl").getDeclaredField("m_classLoader");
                Felix_ModuleImpl_m_classLoader_field.setAccessible(true);
            }
            if ((cl = (ClassLoader)Felix_ModuleImpl_m_classLoader_field.get(currentModuleImpl)) == null) {
                bundle.loadClass("java.lang.Object");
                cl = (ClassLoader)Felix_ModuleImpl_m_classLoader_field.get(currentModuleImpl);
                return cl;
            }
            return cl;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

