/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.UncheckedPrintWriter;
import org.eclipse.jetty.servlets.GzipFilter;

public class IncludableGzipFilter
extends GzipFilter {
    boolean _uncheckedPrintWriter = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String tmp = filterConfig.getInitParameter("uncheckedPrintWriter");
        if (tmp != null) {
            this._uncheckedPrintWriter = Boolean.valueOf(tmp);
        }
    }

    protected GzipFilter.GZIPResponseWrapper newGZIPResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        return new IncludableResponseWrapper(request, response);
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        if (this._uncheckedPrintWriter) {
            return encoding == null ? new UncheckedPrintWriter(out) : new UncheckedPrintWriter((Writer)new OutputStreamWriter(out, encoding));
        }
        return super.newWriter(out, encoding);
    }

    public class IncludableGzipStream
    extends GzipFilter.GzipStream {
        public IncludableGzipStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minGzipSize) throws IOException {
            super(request, response, contentLength, bufferSize, minGzipSize);
        }

        protected boolean setContentEncodingGzip() {
            if (this._request.getAttribute("javax.servlet.include.request_uri") != null) {
                this._response.setHeader("org.eclipse.jetty.server.include.Content-Encoding", "gzip");
            } else {
                this._response.setHeader("Content-Encoding", "gzip");
            }
            return this._response.containsHeader("Content-Encoding");
        }
    }

    public class IncludableResponseWrapper
    extends GzipFilter.GZIPResponseWrapper {
        public IncludableResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(IncludableGzipFilter.this, request, response);
        }

        protected GzipFilter.GzipStream newGzipStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minGzipSize) throws IOException {
            return new IncludableGzipStream(request, response, contentLength, bufferSize, minGzipSize);
        }
    }
}

